/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


#ifndef NET_INSTAWEB_REWRITER_PUBLIC_USAGE_DATA_REPORTER_H_
#define NET_INSTAWEB_REWRITER_PUBLIC_USAGE_DATA_REPORTER_H_

#include "pagespeed/kernel/base/basictypes.h"
#include "pagespeed/kernel/base/string.h"
#include "pagespeed/kernel/base/string_util.h"

namespace net_instaweb {

class GoogleUrl;
struct ContentType;

// General interface for reporting usage data such as page load time,
// error response codes, various rewriter warnings.
// Default implementation ignores all reports, other implementations may
// do things like aggregate the top 10 most common error URls, etc.
class UsageDataReporter {
 public:
  UsageDataReporter() {}
  virtual ~UsageDataReporter();

  // Reports client-side instrumentation beacon.
  // The mod_pagespeed beacons are of the form:
  //   http://www.example.com/mod_pagespeed_beacon?ets=load:xxx
  // Implementation must parse the URL and extract interesting information.
  virtual void ReportCsiBeacon(const GoogleUrl& url) {}

  // Reports all useful response data.
  virtual void ReportResponseData(const GoogleUrl& url, int32 response_code,
                                  const GoogleString& reason_phrase,
                                  const ContentType* content_type,
                                  int64 time_taken,
                                  const GoogleString& ip,
                                  const GoogleString& user_agent) {}

  // Reports fetch errors.
  virtual void ReportFetchErrors(const GoogleString& host,
                                 const GoogleString& url,
                                 int32 error_code,
                                 const StringPiece& fetch_error) {}


  // Report a warning.
  virtual void ReportWarning(const GoogleUrl& url, int32 warning_code,
                             const StringPiece& warning_message) {}

  // Report bandwidth.
  virtual void ReportBandwidth(int64 project_id, const GoogleUrl& url,
                               int64 bandwidth, StringPiece referer) {}

 private:
  DISALLOW_COPY_AND_ASSIGN(UsageDataReporter);
};

}  // namespace net_instaweb

#endif  // NET_INSTAWEB_REWRITER_PUBLIC_USAGE_DATA_REPORTER_H_
