# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'libwebp_dec',
      'type': 'static_library',
      'dependencies' : [
        'libwebp_dsp',
        'libwebp_dsp_neon',
        'libwebp_mux',
        'libwebp_utils',
      ],
      'sources': [
        '<(DEPTH)/third_party/libwebp/src/dec/alpha_dec.c',
        '<(DEPTH)/third_party/libwebp/src/dec/buffer_dec.c',
        '<(DEPTH)/third_party/libwebp/src/dec/frame_dec.c',
        '<(DEPTH)/third_party/libwebp/src/dec/idec_dec.c',
        '<(DEPTH)/third_party/libwebp/src/dec/io_dec.c',
        '<(DEPTH)/third_party/libwebp/src/dec/quant_dec.c',
        '<(DEPTH)/third_party/libwebp/src/dec/tree_dec.c',
        '<(DEPTH)/third_party/libwebp/src/dec/vp8_dec.c',
        '<(DEPTH)/third_party/libwebp/src/dec/vp8l_dec.c',
        '<(DEPTH)/third_party/libwebp/src/dec/webp_dec.c',
      ],
      'include_dirs': [
        '<(DEPTH)/third_party/libwebp',
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '<(DEPTH)/third_party/libwebp/src/webp'
        ],
      },
    },
    {
      'target_name': 'libwebp_dsp',
      'type': 'static_library',
      'sources': [
        '<(DEPTH)/third_party/libwebp/src/dsp/alpha_processing.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/alpha_processing_mips_dsp_r2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/alpha_processing_sse2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/alpha_processing_sse41.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/cost.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/cost_mips32.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/cost_mips_dsp_r2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/cost_sse2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/cpu.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/dec.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/dec_clip_tables.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/dec_mips32.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/dec_mips_dsp_r2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/dec_msa.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/dec_sse2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/dec_sse41.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/enc.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/enc_avx2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/enc_mips32.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/enc_mips_dsp_r2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/enc_msa.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/enc_sse2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/enc_sse41.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/filters.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/filters_mips_dsp_r2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/filters_msa.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/filters_sse2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/lossless.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/lossless_enc.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/lossless_enc_mips32.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/lossless_enc_mips_dsp_r2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/lossless_enc_msa.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/lossless_enc_sse2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/lossless_enc_sse41.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/lossless_mips_dsp_r2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/lossless_msa.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/lossless_sse2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/rescaler.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/rescaler_mips32.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/rescaler_mips_dsp_r2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/rescaler_msa.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/rescaler_sse2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/ssim.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/ssim_sse2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/upsampling.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/upsampling_mips_dsp_r2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/upsampling_msa.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/upsampling_sse2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/yuv.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/yuv_mips32.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/yuv_mips_dsp_r2.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/yuv_sse2.c',
      ],
      'include_dirs': [
        '<(DEPTH)/third_party/libwebp',
      ],
    },
    {
      'target_name': 'libwebp_dsp_neon',
      'type': 'static_library',
      'sources': [
        '<(DEPTH)/third_party/libwebp/src/dsp/alpha_processing_neon.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/dec_neon.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/enc_neon.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/filters_neon.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/lossless_enc_neon.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/lossless_neon.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/rescaler_neon.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/upsampling_neon.c',
        '<(DEPTH)/third_party/libwebp/src/dsp/yuv_neon.c',
      ],
      'include_dirs': [
        '<(DEPTH)/third_party/libwebp',
      ],
    },
    {
      'target_name': 'libwebp_enc',
      'type': 'static_library',
      # note these dependencies are shared with libwebp_dec, if they are merged
      # into each lib causing duplicate symbol issues when both are used then
      # the deps could be split to enc/dec parts or a combined libwebp target
      # could be added similar to chrome.
      'dependencies' : [
        'libwebp_dsp',
        'libwebp_dsp_neon',
        'libwebp_mux',
        'libwebp_utils',
      ],
      'sources': [
        '<(DEPTH)/third_party/libwebp/src/enc/alpha_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/analysis_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/backward_references_cost_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/backward_references_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/config_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/cost_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/delta_palettization_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/filter_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/frame_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/histogram_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/iterator_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/near_lossless_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/picture_csp_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/picture_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/picture_psnr_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/picture_rescale_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/picture_tools_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/predictor_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/quant_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/syntax_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/token_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/tree_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/vp8l_enc.c',
        '<(DEPTH)/third_party/libwebp/src/enc/webp_enc.c',
      ],
      'include_dirs': [
        '<(DEPTH)/third_party/libwebp',
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          '<(DEPTH)/third_party/libwebp/src/webp'
        ],
      },
    },
    {
      'target_name': 'libwebp_utils',
      'type': 'static_library',
      'sources': [
        '<(DEPTH)/third_party/libwebp/src/utils/bit_reader_utils.c',
        '<(DEPTH)/third_party/libwebp/src/utils/bit_writer_utils.c',
        '<(DEPTH)/third_party/libwebp/src/utils/color_cache_utils.c',
        '<(DEPTH)/third_party/libwebp/src/utils/filters_utils.c',
        '<(DEPTH)/third_party/libwebp/src/utils/huffman_encode_utils.c',
        '<(DEPTH)/third_party/libwebp/src/utils/huffman_utils.c',
        '<(DEPTH)/third_party/libwebp/src/utils/quant_levels_dec_utils.c',
        '<(DEPTH)/third_party/libwebp/src/utils/quant_levels_utils.c',
        '<(DEPTH)/third_party/libwebp/src/utils/random_utils.c',
        '<(DEPTH)/third_party/libwebp/src/utils/rescaler_utils.c',
        '<(DEPTH)/third_party/libwebp/src/utils/thread_utils.c',
        '<(DEPTH)/third_party/libwebp/src/utils/utils.c',
      ],
      'include_dirs': [
        '<(DEPTH)/third_party/libwebp',
      ],
    },
    {
      'target_name': 'libwebp_mux',
      'type': 'static_library',
      'sources': [
        '<(DEPTH)/third_party/libwebp/src/mux/anim_encode.c',
        '<(DEPTH)/third_party/libwebp/src/mux/muxedit.c',
        '<(DEPTH)/third_party/libwebp/src/mux/muxinternal.c',
        '<(DEPTH)/third_party/libwebp/src/mux/muxread.c',
      ],
      'include_dirs': [
        '<(DEPTH)/third_party/libwebp',
      ],
    },
  ],
}
