/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.service.impl;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.google.common.collect.Maps;
import com.xiaomi.data.push.common.SafeRun;
import com.xiaomi.data.push.nacos.NacosNaming;
import com.xiaomi.data.push.rpc.RpcClient;
import com.xiaomi.youpin.docean.anno.Service;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.agent.service.ServiceRegistryService;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.utils.ConfigUtils;
import org.apache.ozhera.log.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class ServiceRegistryServiceImpl
implements ServiceRegistryService {
    private static final Logger log = LoggerFactory.getLogger(ServiceRegistryServiceImpl.class);
    @Resource
    private RpcClient rpcClient;
    private static final String SERVER_PREFIX = "prometheus_server";
    private static final String APP_NAME_LABEL = "app_name";
    private static final String APP_ID_LABEL = "app_id";
    private static final String ENV_ID_LABEL = "env_id";
    private static final String ENV_NAME_LABEL = "env_name";
    private static final String DEFAULT_TIME_DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    public static final String STREAM_VERSION = "hera-log-agent:1.0.0:2023-12-20";
    private String appName;
    private String appId;
    private String envId;
    private String envName;
    private Integer port;
    private String ip;

    @Override
    public void init() {
        this.initializeEnvironmentParameters();
        String registrationInitiationFlag = Config.ins().get("registration_initiation_flag", "false");
        if (Objects.equals("true", registrationInitiationFlag)) {
            this.registerServiceInstance();
        }
    }

    @Override
    public void registerServiceInstance() {
        NacosNaming nacosNaming = this.rpcClient.getNacosNaming();
        int appIndex = ConfigUtils.getDataHashKey((String)this.ip, (int)Integer.parseInt(Config.ins().get("app_max_index", "30")));
        String serviceName = String.format("%s_%s_%s_%s", SERVER_PREFIX, this.appId, this.appName, appIndex);
        try {
            nacosNaming.registerInstance(serviceName, this.buildInstance(serviceName));
            this.addShutdownHook(nacosNaming, serviceName);
        }
        catch (NacosException e) {
            log.error("registerService error,serviceName:{}", (Object)serviceName, (Object)e);
        }
    }

    @Override
    public void addShutdownHook(NacosNaming nacosNaming, String serviceName) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                log.info("agent unregisters the instance and the service name:{}", (Object)serviceName);
                nacosNaming.deregisterInstance(serviceName, this.ip, this.port.intValue());
            }
            catch (NacosException e) {
                log.error("agent unregisters the instance error,service name:{}", (Object)serviceName, (Object)e);
            }
        }));
    }

    @Override
    public Instance buildInstance(String serviceName) {
        Instance instance = new Instance();
        instance.setEnabled(true);
        instance.setHealthy(true);
        instance.setIp(this.ip);
        instance.setPort(this.port.intValue());
        instance.setServiceName(serviceName);
        HashMap metaData = Maps.newHashMap();
        metaData.put("ctime", new SimpleDateFormat(DEFAULT_TIME_DATE_FORMAT).format(new Date()));
        metaData.put("version", STREAM_VERSION);
        metaData.put("MONE_CONTAINER_S_POD_NAME", System.getenv("MONE_CONTAINER_S_POD_NAME"));
        metaData.put(ENV_ID_LABEL, this.envId);
        metaData.put(ENV_NAME_LABEL, this.envName);
        SafeRun.run(() -> metaData.put("hostname", InetAddress.getLocalHost().getHostName()));
        instance.setMetadata((Map)metaData);
        return instance;
    }

    @Override
    public void initializeEnvironmentParameters() {
        this.appName = StringUtils.isNotBlank((CharSequence)System.getenv(APP_NAME_LABEL)) ? System.getenv(APP_NAME_LABEL) : "log_agent";
        this.appId = StringUtils.isNotBlank((CharSequence)System.getenv(APP_ID_LABEL)) ? System.getenv(APP_ID_LABEL) : "10010";
        this.envName = StringUtils.isNotBlank((CharSequence)System.getenv(ENV_NAME_LABEL)) ? System.getenv(ENV_NAME_LABEL) : "default_env";
        this.envId = StringUtils.isNotBlank((CharSequence)System.getenv(ENV_ID_LABEL)) ? System.getenv(ENV_ID_LABEL) : "1";
        this.port = Integer.parseInt(Config.ins().get("port", "9799"));
        this.ip = NetUtil.getLocalIp();
    }
}

