/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.controller;

import java.util.Map;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.ozhera.app.api.service.HeraAuthorizationApi;
import org.apache.ozhera.app.common.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AuthorizationController {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationController.class);
    @Reference(registry={"registryConfig"}, check=false, interfaceClass=HeraAuthorizationApi.class, group="${dubbo.group.heraapp}", timeout=2000)
    HeraAuthorizationApi heraAuthorizationApi;

    @PostMapping(value={"/api/getToken"})
    @ResponseBody
    public Result getToken(@RequestBody Map<String, Object> map) {
        log.info("getToken param map : {}", map);
        String userName = (String)map.get("userName");
        String sign = (String)map.get("sign");
        Long timestamp = (Long)map.get("timestamp");
        return this.heraAuthorizationApi.fetchToken(userName, sign, timestamp);
    }
}

