/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.trace.etl.extension.doris;

import java.util.List;
import org.apache.ozhera.trace.etl.api.service.DataSourceService;
import org.apache.ozhera.trace.etl.domain.DriverDomain;
import org.apache.ozhera.trace.etl.domain.ErrorTraceMessage;
import org.apache.ozhera.trace.etl.domain.tracequery.Trace;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceIdQueryVo;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceListQueryVo;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceOperationsVo;
import org.apache.ozhera.trace.etl.domain.tracequery.TraceQueryResult;
import org.apache.ozhera.trace.etl.extension.doris.QueryDorisService;
import org.apache.ozhera.trace.etl.extension.doris.WriteDorisService;
import org.apache.ozhera.tspandata.TSpanData;
import org.springframework.beans.factory.annotation.Autowired;

public class DorisDataSourceService
implements DataSourceService {
    @Autowired
    private QueryDorisService queryDorisService;
    @Autowired
    private WriteDorisService writeDorisService;

    public TraceQueryResult<List<String>> getOperations(TraceOperationsVo vo) {
        return this.queryDorisService.getOperations(vo.getService(), vo.getIndex());
    }

    public TraceQueryResult<List<Trace>> getList(TraceListQueryVo vo) {
        return this.queryDorisService.getList(vo);
    }

    public TraceQueryResult<List<Trace>> getByTraceId(TraceIdQueryVo vo) {
        return this.queryDorisService.getByTraceId(vo);
    }

    public void insertErrorTrace(ErrorTraceMessage errorTraceMessage) {
        this.writeDorisService.insertErrorTrace(errorTraceMessage);
    }

    public void insertHeraTraceService(String date, String serviceName, String operationName) {
        this.writeDorisService.insertHeraTraceService(serviceName, operationName);
    }

    public void insertDriver(DriverDomain driverDomain) {
        this.writeDorisService.insertDriver(driverDomain);
    }

    public void insertHeraSpan(TSpanData tSpanData, String serviceName, String spanName) {
        this.writeDorisService.insertHeraSpan(tSpanData, serviceName, spanName);
    }
}

