/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.controller;

import com.xiaomi.youpin.docean.anno.Controller;
import com.xiaomi.youpin.docean.anno.RequestMapping;
import com.xiaomi.youpin.docean.anno.RequestParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.manager.model.dto.DashboardDTO;
import org.apache.ozhera.log.manager.model.dto.GraphDTO;
import org.apache.ozhera.log.manager.model.dto.GraphTypeDTO;
import org.apache.ozhera.log.manager.model.dto.LogAnalyseDataDTO;
import org.apache.ozhera.log.manager.model.vo.CreateDashboardCmd;
import org.apache.ozhera.log.manager.model.vo.CreateGraphCmd;
import org.apache.ozhera.log.manager.model.vo.DGRefCmd;
import org.apache.ozhera.log.manager.model.vo.DGRefDelCmd;
import org.apache.ozhera.log.manager.model.vo.DGRefUpdateCmd;
import org.apache.ozhera.log.manager.model.vo.GraphQuery;
import org.apache.ozhera.log.manager.model.vo.LogAnalyseDataPreQuery;
import org.apache.ozhera.log.manager.model.vo.LogAnalyseDataQuery;
import org.apache.ozhera.log.manager.model.vo.LogAnalyseQuery;
import org.apache.ozhera.log.manager.model.vo.UpdateGraphCmd;
import org.apache.ozhera.log.manager.service.impl.LogAnalyseService;

@Controller
public class LogAnalyseController {
    @Resource
    private LogAnalyseService logAnalyseService;

    @RequestMapping(path="/log/analyse/show")
    public Result<DashboardDTO> logQuery(LogAnalyseQuery logAnalyseQuery) throws Exception {
        return this.logAnalyseService.getDashboardGraph(logAnalyseQuery);
    }

    @RequestMapping(path="/log/analyse/data")
    public Result<LogAnalyseDataDTO> data(LogAnalyseDataQuery query) throws Exception {
        return this.logAnalyseService.data(query);
    }

    @RequestMapping(path="/log/analyse/dataPre")
    public Result<LogAnalyseDataDTO> dataPre(LogAnalyseDataPreQuery query) throws Exception {
        return this.logAnalyseService.dataPre(query);
    }

    @RequestMapping(path="/log/analyse/type")
    public Result<List<GraphTypeDTO>> type() throws Exception {
        return this.logAnalyseService.type();
    }

    @RequestMapping(path="/log/analyse/key", method="get")
    public Result<List<String>> supportKey(@RequestParam(value="storeId") Long storeId) throws Exception {
        return this.logAnalyseService.supportKey(storeId);
    }

    @RequestMapping(path="/log/analyse/ref")
    public Result<Boolean> ref(DGRefCmd cmd) throws Exception {
        return this.logAnalyseService.ref(cmd);
    }

    @RequestMapping(path="/log/analyse/delRef")
    public Result<Boolean> delRef(DGRefDelCmd cmd) throws Exception {
        return this.logAnalyseService.delRef(cmd);
    }

    @RequestMapping(path="/log/analyse/updateRef")
    public Result<Boolean> updateRef(DGRefUpdateCmd cmd) throws Exception {
        return this.logAnalyseService.updateRef(cmd);
    }

    @RequestMapping(path="/log/graph/create")
    public Result<Long> createGraph(CreateGraphCmd cmd) throws Exception {
        return this.logAnalyseService.createGraph(cmd);
    }

    @RequestMapping(path="/log/graph/update")
    public Result<Boolean> createGraph(UpdateGraphCmd cmd) throws Exception {
        return this.logAnalyseService.updateGraph(cmd);
    }

    @RequestMapping(path="/log/graph/delete")
    public Result<Boolean> deleteGraph(Long graphId) throws Exception {
        return this.logAnalyseService.deleteGraph(graphId);
    }

    @RequestMapping(path="/log/graph/search")
    public Result<List<GraphDTO>> searchGraph(GraphQuery query) throws Exception {
        return this.logAnalyseService.searchGraph(query);
    }

    @RequestMapping(path="/log/dashboard/create")
    public Result<Long> createDashboard(CreateDashboardCmd cmd) throws Exception {
        return this.logAnalyseService.createDashboard(cmd);
    }
}

