/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.login.filter;

import com.xiaomi.mone.tpc.login.util.CommonUtil;
import com.xiaomi.mone.tpc.login.util.ConstUtil;
import com.xiaomi.mone.tpc.login.util.HttpClientUtil;
import com.xiaomi.mone.tpc.login.util.SystemReqUtil;
import com.xiaomi.mone.tpc.login.util.TokenUtil;
import com.xiaomi.mone.tpc.login.vo.AuthTokenVo;
import com.xiaomi.mone.tpc.login.vo.AuthUserVo;
import com.xiaomi.mone.tpc.login.vo.ResultVo;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthTokenFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(AuthTokenFilter.class);
    private String[] ignoreUrls = null;
    private String loginUrl = null;

    public AuthTokenFilter() {
        HttpClientUtil.init();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.loginUrl = filterConfig.getInitParameter("loginUrl");
        String authTokenUrl = filterConfig.getInitParameter("authTokenUrl");
        if (StringUtils.isBlank((CharSequence)authTokenUrl)) {
            throw new IllegalArgumentException("authTokenUrl\u503c\u4e3a\u7a7a");
        }
        ConstUtil.authTokenUrlVal = authTokenUrl;
        logger.info("auth_token_url is {}", (Object)authTokenUrl);
        String ignoreUrl = filterConfig.getInitParameter("IGNORE_URL");
        if (ignoreUrl != null && !"".equals(ignoreUrl)) {
            this.ignoreUrls = ignoreUrl.split(",");
        }
        logger.info("ignore_url_list is {}", (Object[])this.ignoreUrls);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String uri = request.getRequestURI();
        AuthTokenVo authToken = TokenUtil.parseAuthToken(request);
        logger.info("authToken={}", (Object)authToken);
        if (authToken == null) {
            if (CommonUtil.isIgnoreUrl(this.ignoreUrls, uri)) {
                logger.info("request is ignore_uri={}", (Object)uri);
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            logger.info("request not login request_uri={}", (Object)uri);
            this.noAuthResponse(servletResponse);
            return;
        }
        ResultVo<AuthUserVo> resultVo = SystemReqUtil.authRequest(authToken.getAuthToken(), !authToken.isFromCookie());
        logger.info("getResult={}", resultVo);
        if (resultVo == null || !resultVo.success()) {
            if (CommonUtil.isIgnoreUrl(this.ignoreUrls, uri)) {
                logger.info("request is ignore_uri={}", (Object)uri);
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            logger.info("request not login request_uri={}", (Object)uri);
            this.noAuthResponse(servletResponse);
            return;
        }
        if (!authToken.isFromCookie()) {
            TokenUtil.setCookie(request, resultVo.getData(), servletResponse);
        }
        servletRequest.setAttribute("TPC_USER", (Object)resultVo.getData());
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    private void noAuthResponse(ServletResponse servletResponse) throws IOException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setStatus(401);
        response.setHeader("TPC_TOKEN", "1");
        response.setHeader("loginUrl", this.loginUrl);
    }
}

