/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.dao;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.dao.mapper.AppMonitorConfigMapper;
import org.apache.ozhera.monitor.dao.model.AppMonitorConfig;
import org.apache.ozhera.monitor.dao.model.AppMonitorConfigExample;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.model.PageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AppMonitorConfigDao {
    private static final Logger log = LoggerFactory.getLogger(AppMonitorConfigDao.class);
    @Autowired
    private AppMonitorConfigMapper appMonitorConfigMapper;

    public AppMonitorConfig getById(Integer id) {
        return this.appMonitorConfigMapper.selectByPrimaryKey(id);
    }

    public Long getTotal(Integer projectId, Integer type, String configName, Integer status_, Integer page, Integer pageSize) {
        AppMonitorConfigExample example = new AppMonitorConfigExample();
        Integer status = 0;
        if (status_ != null) {
            status = status_;
        }
        AppMonitorConfigExample.Criteria ca = example.createCriteria();
        ca.andStatusEqualTo(status);
        if (projectId != null) {
            ca.andProjectIdEqualTo(projectId);
        }
        if (type != null) {
            ca.andConfigTypeEqualTo(type);
        }
        if (StringUtils.isNotBlank((CharSequence)configName)) {
            ca.andConfigNameLike(configName);
        }
        return this.appMonitorConfigMapper.countByExample(example);
    }

    public Result<PageData> getConfig(Integer projectId, Integer type, String configName, Integer status_, Integer page, Integer pageSize) {
        PageData<List<AppMonitorConfig>> pd = new PageData<List<AppMonitorConfig>>();
        AppMonitorConfigExample example = new AppMonitorConfigExample();
        if (page == null) {
            page = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        example.setOffset((page - 1) * pageSize);
        example.setLimit(pageSize);
        example.setOrderByClause("id desc");
        Integer status = 0;
        if (status_ != null) {
            status = status_;
        }
        AppMonitorConfigExample.Criteria ca = example.createCriteria();
        ca.andStatusEqualTo(status);
        if (projectId != null) {
            ca.andProjectIdEqualTo(projectId);
        }
        if (type != null) {
            ca.andConfigTypeEqualTo(type);
        }
        if (StringUtils.isNotBlank((CharSequence)configName)) {
            ca.andConfigNameLike(configName);
        }
        Long total = this.getTotal(projectId, type, configName, status_, page, pageSize);
        List<AppMonitorConfig> appMonitorConfigs = this.appMonitorConfigMapper.selectByExample(example);
        pd.setPage(page);
        pd.setPageSize(pageSize);
        pd.setTotal(total);
        pd.setList(appMonitorConfigs);
        return Result.success(pd);
    }

    public int create(AppMonitorConfig appMonitorConfig) {
        if (null == appMonitorConfig) {
            log.error("[AppMonitorConfigDao.create] null appMonitorConfig");
            return 0;
        }
        appMonitorConfig.setCreateTime(new Date());
        appMonitorConfig.setUpdateTime(new Date());
        try {
            int affected = this.appMonitorConfigMapper.insert(appMonitorConfig);
            if (affected < 1) {
                log.warn("[AppMonitorConfigDao.create] failed to insert appMonitorConfig: {}", (Object)appMonitorConfig.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[AppMonitorConfigDao.create] failed to insert appMonitorConfig: {}, err: {}", (Object)appMonitorConfig.toString(), (Object)e);
            return 0;
        }
        return 1;
    }

    public int update(AppMonitorConfig appMonitorConfig) {
        if (null == appMonitorConfig) {
            log.error("[AppMonitorConfigDao.update] null appMonitor");
            return 0;
        }
        appMonitorConfig.setUpdateTime(new Date());
        try {
            int affected = this.appMonitorConfigMapper.updateByPrimaryKey(appMonitorConfig);
            if (affected < 1) {
                log.warn("[AppMonitorConfigDao.update] failed to update appMonitor: {}", (Object)appMonitorConfig.toString());
                return 0;
            }
        }
        catch (Exception e) {
            log.error("[AppMonitorConfigDao.update] failed to update appMonitor: {}, err: {}", (Object)appMonitorConfig.toString(), (Object)e);
            return 0;
        }
        return 1;
    }
}

