# Chapter-00: Set up Your First Rust Project

Welcome to our first chapter. In this example we will set up our first rust project with OpenDAL.

## Install Rust

First of all, we need to install Rust. Refer [here](../../../CONTRIBUTING.md#bring-your-own-toolbox) to figure it out.

After rust has been installed, we will have the following components:

- `rustup`: [rustup](https://rust-lang.github.io/rustup/) is a command-line toolchain manager for the Rust programming language. It allows you to easily install, manage, and update different versions of the Rust compiler and associated tools on your system.
- `cargo`: [cargo](https://doc.rust-lang.org/cargo/index.html) is the package manager and build system for the Rust programming language. It is designed to make it easy to develop, build, and manage Rust projects.
- `rustc`: [rustc](https://rustc-dev-guide.rust-lang.org/) is the official compiler for the Rust programming language. It takes Rust source code as input and translates it into machine-readable instructions that can be executed by the computer's hardware. Most time, `rustc` will be called by `cargo` and we don't need to use it directly.

We can use `cargo --version` to check if it works as expected:

```shell
> cargo --version
cargo 1.70.0 (ec8a8a0ca 2023-04-25)
```

## Rust Project Structure

A typical Rust project follows a specific directory structure. The most simple project structure will contain the following files:

- `Cargo.toml`: The Cargo.toml file is the manifest file for the project. It specifies metadata about the project, including its name, version, dependencies, and build configuration. It is also where you declare the project's dependencies using the Cargo package manager.
- `src/`: The `src` directory is where the main source code files of the project reside. It typically contains the Rust source files with the code implementation for the project's functionality.

Let's go into more deep by our example code.

### `Cargo.toml`

Let's take a look over [`Cargo.toml`](Cargo.toml) first.

The most simple `Cargo.toml` will contains two parts:

- `package`: The metadata of this package like `name`, `version`
- `dependencies`: The dependencies that this package will depend on. `cargo` will download them from <https://crates.io> and compile them.

### `src/`

Than, let's read [`main.rs`](./src/main.rs).

The most simple `main.rs` will contain only one function: `fn main()`, this is the entry of an application.

In our example, we did the following things:

```rust
use opendal::Scheme;
```

Import the `opendal::Scheme` into current namespace, so that we can use `Scheme` instead of the full naming `opendal::Scheme` everywhere.

``` rust
fn main() {
    ...
}
```

Declare our main function, this is the most simple function that not take any input and not return any output.

```rust
println!("Hello, {}", Scheme::S3)
```

- `println!()` is a built macro in rust to prints to the standard output, with a newline. macro will be expanded to real code during compilation.
- `"Hello, {}", Scheme::S3` is the format string in rust. It will convert `Scheme::S3` to string, and construct a new string in this format.

## Build our first rust project!

Now, it's time to build our first rust project!

Make sure we are under folder `examples/rust/00-setup`, running:

```shell
cargo run
```

We will see output like:

```shell
:) cargo run
   Compiling setup v0.1.0 (/home/xuanwo/Code/apache/incubator-opendal/examples/rust/00-setup)
    Finished dev [unoptimized + debuginfo] target(s) in 0.32s
     Running `target/debug/setup`
Hello, s3
```

Congrate! Our first rust project is built and running with success!

After built, we will find that there are some new files created:

- `Cargo.lock`: Cargo.lock is a file generated by the cargo package manager when you build or run a Rust project. It serves as a lock file and records the exact versions of dependencies that were used during the previous successful build or run of the project. It's always a good idea to commit `Cargo.lock` to your repo, so developers can reproduce the same build result with you.
- `target`: `target` folder is a directory automatically generated by rustc  and managed cargo. It contains the compiled artifacts and build output for specific target platforms and architectures.

## Conclusion

In this chapter we have learnt the rust project structure and run our first rust example. We will use this knowledge to build our first rust application in the next chapter!
