/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.nemo.compiler.optimizer.pass.compiletime.annotating;

import org.apache.nemo.common.ir.IRDAG;
import org.apache.nemo.common.ir.vertex.executionproperty.ResourceLocalityProperty;

/**
 * Sets {@link ResourceLocalityProperty}.
 */
@Annotates(ResourceLocalityProperty.class)
public final class ResourceLocalityPass extends AnnotatingPass {

  /**
   * Constructor.
   */
  public ResourceLocalityPass() {
    super(ResourceLocalityPass.class);
  }

  @Override
  public IRDAG apply(final IRDAG dag) {
    // On every vertex, if ResourceLocalityProperty is not set, put it as true.
    dag.getVertices().stream()
      .filter(v -> !v.getPropertyValue(ResourceLocalityProperty.class).isPresent())
      .forEach(v -> v.setProperty(ResourceLocalityProperty.of(true)));
    return dag;
  }
}
