# Working Groups

As described in the ONNX [governance](https://github.com/onnx/onnx/tree/master/community#wg---working-groups), Working Groups (WGs) are temporary groups formed to address issues that cross SIG boundaries. Working Groups have a have a clear goal measured through specific deliverables and disband after the goal is achieved. Working groups do not own artifacts long term; they create specifications, recommendations, and/or code implementations for submission to the relevant SIGs for approval and acceptance.

## Proposing a new working group
New Working Groups are created when there is sufficient interest in a topic area and someone volunteers to be the chair for the group and submits a proposal to the steering committee. The chair facilitates the discussion and helps synthesize proposals and decisions. 

## Joining a working group
Working Groups have most of their discussions on Gitter. If you are interested in participating, please join the discussion in the respective Gitter room. Details about any upcoming meetings will also be shared in the Gitter rooms. Working Group artifacts can be found in the [working-groups repository](https://github.com/onnx/working-groups).

## Active working groups

| Working Group      | Objectives    |
| ------------------ | ------------- |
| [Training](https://gitter.im/onnx/training) | Expand ONNX to support training as well as inference |
| [Edge/Mobile](https://gitter.im/onnx/edge) | Enable deployment of ONNX models to edge platforms by identifying the ONNX operators that must be supported by mobile and IoT runtimes, defining tool chain requirements, and contributing to ONNX compatibility tests |
| [Data Pipelines](https://gitter.im/onnx/pipelines) | Define new operators for processing the data that goes in and comes out |
| [Foundation](https://gitter.im/onnx/foundation) | Identify and evaluate non-profit foundation options for the ONNX consortium.  Execute on best option. |

## Completed working groups

| Working Group      | Objectives    | Status |
| ------------------ | ------------- | ------ |
| [Control Flow and Loops](https://gitter.im/onnx/ControlFlowWG) | Enable dynamic control structures to enable advanced models for NLP, speech, and video/image processing | Completed - If, Loop, and Scan operators were added in ONNX 1.3 release. |
| [Quantization](https://gitter.im/onnx/quantization) | Enhance ONNX to support quantized data types and operators on a variety of runtimes and hardware devices | Completed - added in ONNX 1.5 release. |

## Inactive working groups

| Working Group      | Objectives    | Status |
| ------------------ | ------------- | ------ |
| [Testing/Compliance](https://gitter.im/onnx/test_compliance) | Create tools, tests and APIs to ensure models and backends comply with the ONNX specification | became part of the ArchInfra SIG for now |
