# SIGs - Special Interest Groups

As described in the ONNX [governance](https://github.com/onnx/onnx/tree/master/community#sig---special-interest-groups), Special Interest Groups (SIGs) are persistent groups responsible for specific parts of the project. SIGs have open and transparent proceedings to develop goals and implement code contributions. SIGs are also responsible for ongoing maintenance of the code in their areas.

## Joining a SIG
If you are interested in participating, please [join the discussion](https://gitter.im/onnx) in the respective Gitter room. Details about any upcoming meetings will also be shared in the Gitter rooms. SIG artifacts can be found in the [sigs repository](https://github.com/onnx/sigs).

## Current SIGs

| Name      | Responsibilities    |
| ------------------ | ------------- |
| [Architecture & Infra](https://gitter.im/onnx/archinfra) | Defining and maintaining the core ONNX format, the build and CI/CD systems for ONNX repositories, publishing release packages for ONNX, the onnx-docker repository, and creating tools to help integrate with and test against the ONNX standard. This SIG is also the defacto owner of files in the main ONNX repository unless explicitly owned by another SIG. |
| [Operators](https://gitter.im/onnx/operators) | Determining the operators that are part of the ONNX spec (ONNX and ONNX-ML domains), ensuring high quality operator definitions and documentation, establishing criteria for adding new operators, managing ops domains and compliance tiers, and enforcing versioning mechanisms. |
| [Converters](https://gitter.im/onnx/converters) | Developing and maintaining the various converter repositories under ONNX. |
| [Model zoo and tutorials](https://gitter.im/onnx/modelzoo) | Providing a comprehensive collection of state of the art ONNX models from a variety of sources and making it easy for users to get started with ONNX and the ecosystem around it. |
