from google.protobuf.descriptor import Descriptor
from google.protobuf.internal.message_listener import MessageListener
from google.protobuf.message import Message
from typing import (
    MutableSequence, Sequence, TypeVar, Generic, Any, Iterator, Iterable,
    Union, Optional, Callable
)

_T = TypeVar('_T')
class BaseContainer(Generic[_T], MutableSequence[_T]):
    def __init__(self, message_listener: MessageListener) -> None: ...
    def __len__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __repr__(self) -> str: ...
    def sort(self, *, key: Optional[Callable[[_T], Any]] = ..., reverse: bool = ...) -> None: ...

class RepeatedScalarFieldContainer(Generic[_T], BaseContainer[_T]):
    def __init__(self, message_listener: MessageListener, message_descriptor: Descriptor) -> None: ...
    def MergeFrom(self, other: RepeatedScalarFieldContainer[_T]) -> None: ...

class RepeatedCompositeFieldContainer(Generic[_T], BaseContainer[_T]):
    def __init__(self, message_listener: MessageListener, type_checker: Any) -> None: ...
    def add(self, **kwargs: Any) -> _T: ...
    def MergeFrom(self, other: RepeatedCompositeFieldContainer[_T]) -> None: ...

# Classes not yet typed
class Mapping(Any):
    pass
class MutableMapping(Mapping):
    pass
class ScalarMap(MutableMapping):
    pass
class MessageMap(MutableMapping):
    pass
