<!--- Licensed to the Apache Software Foundation (ASF) under one -->
<!--- or more contributor license agreements.  See the NOTICE file -->
<!--- distributed with this work for additional information -->
<!--- regarding copyright ownership.  The ASF licenses this file -->
<!--- to you under the Apache License, Version 2.0 (the -->
<!--- "License"); you may not use this file except in compliance -->
<!--- with the License.  You may obtain a copy of the License at -->

<!---   http://www.apache.org/licenses/LICENSE-2.0 -->

<!--- Unless required by applicable law or agreed to in writing, -->
<!--- software distributed under the License is distributed on an -->
<!--- "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY -->
<!--- KIND, either express or implied.  See the License for the -->
<!--- specific language governing permissions and limitations -->
<!--- under the License. -->

# MXNet Documentation

[MXNet.jl](https://github.com/dmlc/MXNet.jl) is the
[Julia](http://julialang.org/) package of
[dmlc/mxnet](https://github.com/dmlc/mxnet). MXNet.jl brings flexible and efficient GPU
computing and state-of-art deep learning to Julia. Some highlight of features
include:

* Efficient tensor/matrix computation across multiple devices,
  including multiple CPUs, GPUs and distributed server nodes.
* Flexible symbolic manipulation to composite and construct
  state-of-the-art deep learning models.

For more details, see documentation below. Please also checkout the
[examples](https://github.com/apache/incubator-mxnet/tree/master/julia/examples) directory.

## Tutorials

```@contents
Pages = [
  "tutorial/mnist.md",
  "tutorial/char-lstm.md",
]
Depth = 2
```

## User's Guide

```@contents
Pages = [
  "user-guide/install.md",
  "user-guide/overview.md",
  "user-guide/faq.md",
]
Depth = 2
```

## API Documentation

```@contents
Pages = api_pages
Depth = 2
```
