#!/usr/bin/env bash

# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# build and install are separated so changes to build don't invalidate
# the whole docker cache for the image

# Assumes base image is from nvidia/cuda

set -ex

if [ -z ${CUDNN_VERSION} ]; then
	echo "Error: CUDNN_VERSION environment variable undefiend"
	exit 1
fi

apt-get update || true

case ${CUDA_VERSION} in
	11\.0*)
		export libcudnn_package="libcudnn8"
		export libcudnn_version="${CUDNN_VERSION}-1+cuda11.0"
		export libcudnn_dev_version="${CUDNN_VERSION}-1+cuda11.0"
		;;
	10\.2*)
		export libcudnn_package="libcudnn7"
		export libcudnn_version="${CUDNN_VERSION}-1+cuda10.2"
		export libcudnn_dev_version="${CUDNN_VERSION}-1+cuda10.2"
		;;
	10\.1*)
		export libcudnn_package="libcudnn7"
		export libcudnn_version="${CUDNN_VERSION}-1+cuda10.1"
		export libcudnn_dev_version="${CUDNN_VERSION}-1+cuda10.1"
		;;
	10\.0*)
		export libcudnn_package="libcudnn7"
		export libcudnn_version="${CUDNN_VERSION}-1+cuda10.0"
		export libcudnn_dev_version="${CUDNN_VERSION}-1+cuda10.0"
		;;
	9\.0*)
		export libcudnn_package="libcudnn7"
		export libcudnn_version="${CUDNN_VERSION}-1+cuda9.0"
		export libcudnn_dev_version="${CUDNN_VERSION}-1+cuda9.0"
		;;
	9\.2*)
		export libcudnn_package="libcudnn7"
		export libcudnn_version="${CUDNN_VERSION}-1+cuda9.2"
		export libcudnn_dev_version="${CUDNN_VERSION}-1+cuda9.2"
		;;
	*)
		echo "Unsupported CUDA version ${CUDA_VERSION}"
		exit 1
		;;
esac

apt-get install -y --allow-downgrades ${libcudnn_package}=${libcudnn_version} ${libcudnn_package}-dev=${libcudnn_dev_version}

