<!--- Licensed to the Apache Software Foundation (ASF) under one -->
<!--- or more contributor license agreements.  See the NOTICE file -->
<!--- distributed with this work for additional information -->
<!--- regarding copyright ownership.  The ASF licenses this file -->
<!--- to you under the Apache License, Version 2.0 (the -->
<!--- "License"); you may not use this file except in compliance -->
<!--- with the License.  You may obtain a copy of the License at -->

<!---   http://www.apache.org/licenses/LICENSE-2.0 -->

<!--- Unless required by applicable law or agreed to in writing, -->
<!--- software distributed under the License is distributed on an -->
<!--- "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY -->
<!--- KIND, either express or implied.  See the License for the -->
<!--- specific language governing permissions and limitations -->
<!--- under the License. -->

# MXNet GPU Operator Benchmarks

## Settings

1. MXNet - v1.5.0 with CUDA 10.1
2. Instance - P3.2x
 
| Operator | Avg Forward Time (ms) | Avg. Backward Time (ms) | Max Mem Usage (Storage) (Bytes) | Inputs |
| :---: | :---: | :---: | :---:| :--- |
| rcbrt | 0.0384 | 0.0393 | 2097.1521 | {'data': (1024, 1024)} |
| rcbrt | 0.0268 | 0.0252 | 20.0 | {'data': (10000, 1)} |
| rcbrt | 0.0378 | 0.039 | 2000.0 | {'data': (10000, 100)} |
| min | 0.0679 | 0.0955 | 0.002 | {'axis': (), 'data': (1024, 1024)} |
| min | 0.0337 | 0.022 | 0.002 | {'axis': 0, 'data': (10000, 1)} |
| min | 0.0669 | 0.0921 | 0.002 | {'axis': (0, 1), 'data': (10000, 100)} |
| broadcast_maximum | 0.0284 | 0.0308 | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| Flatten | 0.0416 | --- | 2097.1521 | {'data': (1024, 1024)} |
| Flatten | 0.03 | --- | 20.0 | {'data': (10000, 1)} |
| Flatten | 0.0437 | --- | 2000.0 | {'data': (10000, 100)} |
| stop_gradient | --- | --- | 2097.1521 | {'data': (1024, 1024)} |
| stop_gradient | --- | --- | 20.0 | {'data': (10000, 1)} |
| stop_gradient | --- | --- | 2000.0 | {'data': (10000, 100)} |
| broadcast_minimum | 0.0284 | 0.0294 | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| random_generalized_negative_binomial | 63.299 | --- | 2097.1521 | {'shape': (1024, 1024)} |
| random_generalized_negative_binomial | 0.6491 | --- | 20.0 | {'shape': (10000, 1)} |
| random_generalized_negative_binomial | 60.3705 | --- | 2000.0 | {'shape': (10000, 100)} |
| broadcast_sub | 0.0198 | 0.0208 | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| round | 0.0363 | --- | 2097.1521 | {'data': (1024, 1024)} |
| round | 0.0248 | --- | 20.0 | {'data': (10000, 1)} |
| round | 0.0358 | --- | 2000.0 | {'data': (10000, 100)} |
| cosh | 0.0384 | 0.0389 | 2097.1521 | {'data': (1024, 1024)} |
| cosh | 0.0271 | 0.0255 | 20.0 | {'data': (10000, 1)} |
| cosh | 0.0378 | 0.0387 | 2000.0 | {'data': (10000, 100)} |
| max | 0.068 | 0.095 | 0.002 | {'axis': (), 'data': (1024, 1024)} |
| max | 0.0336 | 0.0219 | 0.002 | {'axis': 0, 'data': (10000, 1)} |
| max | 0.0665 | 0.0918 | 0.002 | {'axis': (0, 1), 'data': (10000, 100)} |
| tanh | 0.0391 | 0.038 | 2097.1521 | {'data': (1024, 1024)} |
| tanh | 0.0271 | 0.025 | 20.0 | {'data': (10000, 1)} |
| tanh | 0.0373 | 0.0376 | 2000.0 | {'data': (10000, 100)} |
| relu | 0.0382 | 0.0383 | 2097.1521 | {'data': (1024, 1024)} |
| relu | 0.0272 | 0.0251 | 20.0 | {'data': (10000, 1)} |
| relu | 0.0383 | 0.038 | 2000.0 | {'data': (10000, 100)} |
| negative | 0.0367 | --- | 2097.1521 | {'data': (1024, 1024)} |
| negative | 0.025 | --- | 20.0 | {'data': (10000, 1)} |
| negative | 0.0361 | --- | 2000.0 | {'data': (10000, 100)} |
| random_randint | 9.0025 | --- | 2097.1521 | {'shape': (1024, 1024), 'high': 5, 'low': 0} |
| random_randint | 0.0976 | --- | 20.0 | {'shape': (10000, 1), 'high': 5, 'low': 0} |
| random_randint | 8.589 | --- | 2000.0 | {'shape': (10000, 100), 'high': 5, 'low': 0} |
| trunc | 0.0367 | --- | 2097.1521 | {'data': (1024, 1024)} |
| trunc | 0.0251 | --- | 20.0 | {'data': (10000, 1)} |
| trunc | 0.0359 | --- | 2000.0 | {'data': (10000, 100)} |
| log_softmax | 0.0433 | 0.0387 | 2097.1521 | {'axis': -1, 'data': (1024, 1024), 'temperature': 0.5} |
| log_softmax | 0.055 | 0.0386 | 20.0 | {'axis': -1, 'data': (10000, 1), 'temperature': 0.5} |
| log_softmax | 0.08 | 0.0553 | 2000.0 | {'axis': -1, 'data': (10000, 100), 'temperature': 0.5} |
| broadcast_greater_equal | 0.0191 | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| arctan | 0.0386 | 0.04 | 2097.1521 | {'data': (1024, 1024)} |
| arctan | 0.0266 | 0.0248 | 20.0 | {'data': (10000, 1)} |
| arctan | 0.0378 | 0.0394 | 2000.0 | {'data': (10000, 100)} |
| sqrt | 0.0385 | 0.041 | 2097.1521 | {'data': (1024, 1024)} |
| sqrt | 0.0269 | 0.025 | 20.0 | {'data': (10000, 1)} |
| sqrt | 0.0378 | 0.0397 | 2000.0 | {'data': (10000, 100)} |
| dot | 0.215 | 0.4045 | 2097.1521 | {'lhs': (1024, 1024), 'rhs': (1024, 1024)} |
| dot | 0.031 | 0.0633 | 2000.0 | {'lhs': (1000, 10), 'transpose_b': True, 'rhs': (1000, 10)} |
| dot | 0.042 | 0.0388 | 0.2 | {'lhs': (1000, 1), 'transpose_b': True, 'transpose_a': True, 'rhs': (100, 1000)} |
| floor | 0.0366 | --- | 2097.1521 | {'data': (1024, 1024)} |
| floor | 0.0249 | --- | 20.0 | {'data': (10000, 1)} |
| floor | 0.0366 | --- | 2000.0 | {'data': (10000, 100)} |
| broadcast_logical_xor | 0.0264 | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| shuffle | 0.1016 | --- | 2097.1521 | {'data': (1024, 1024)} |
| shuffle | 0.2845 | --- | 60.0 | {'data': (10000, 1)} |
| shuffle | 0.2798 | --- | 2000.0 | {'data': (10000, 100)} |
| nansum | 0.0741 | 0.0948 | 0.002 | {'axis': (), 'data': (1024, 1024)} |
| nansum | 0.0368 | 0.0221 | 0.002 | {'axis': 0, 'data': (10000, 1)} |
| nansum | 0.0731 | 0.0918 | 0.002 | {'axis': (0, 1), 'data': (10000, 100)} |
| nanprod | 0.0717 | 0.0955 | 0.002 | {'axis': (), 'data': (1024, 1024)} |
| nanprod | 0.0344 | 0.0223 | 0.002 | {'axis': 0, 'data': (10000, 1)} |
| nanprod | 0.0711 | 0.0921 | 0.002 | {'axis': (0, 1), 'data': (10000, 100)} |
| broadcast_div | 0.02 | 0.0227 | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| LeakyReLU | 0.0326 | 0.0333 | 2097.1521 | {'slope': 0.1, 'data': (1024, 1024), 'act_type': 'leaky'} |
| LeakyReLU | 0.0347 | 0.0199 | 20.0 | {'slope': 0.1, 'data': (10000, 1), 'act_type': 'leaky'} |
| LeakyReLU | 0.0316 | 0.0327 | 2000.0 | {'slope': 0.1, 'data': (10000, 100), 'act_type': 'leaky'} |
| LeakyReLU | 0.0328 | 0.0334 | 2097.1521 | {'slope': 0.1, 'data': (1024, 1024), 'act_type': 'elu'} |
| LeakyReLU | 0.0208 | 0.0194 | 20.0 | {'slope': 0.1, 'data': (10000, 1), 'act_type': 'elu'} |
| LeakyReLU | 0.0315 | 0.0326 | 2000.0 | {'slope': 0.1, 'data': (10000, 100), 'act_type': 'elu'} |
| LeakyReLU | 0.0323 | 0.033 | 2097.1521 | {'data': (1024, 1024), 'act_type': 'selu'} |
| LeakyReLU | 0.0209 | 0.0194 | 20.0 | {'data': (10000, 1), 'act_type': 'selu'} |
| LeakyReLU | 0.0315 | 0.0325 | 2000.0 | {'data': (10000, 100), 'act_type': 'selu'} |
| LeakyReLU | 0.0349 | 0.0917 | 2097.1521 | {'gamma': (1, 1024), 'data': (1024, 1024), 'act_type': 'prelu'} |
| LeakyReLU | 0.0244 | 0.0465 | 20.0 | {'gamma': (1, 1), 'data': (10000, 1), 'act_type': 'prelu'} |
| LeakyReLU | 0.034 | 0.1003 | 2000.0 | {'gamma': (1, 100), 'data': (10000, 100), 'act_type': 'prelu'} |
| FullyConnected | 0.3141 | 0.3486 | 4.096 | {'weight': (64, 196608), 'num_hidden': 64, 'data': (32, 3, 256, 256), 'bias': (64,), 'flatten': True} |
| FullyConnected | 0.1381 | 0.5142 | 3145.728 | {'weight': (64, 256), 'num_hidden': 64, 'data': (32, 3, 256, 256), 'bias': (64,), 'flatten': False} |
| square | 0.038 | 0.038 | 2097.1521 | {'data': (1024, 1024)} |
| square | 0.0281 | 0.0262 | 20.0 | {'data': (10000, 1)} |
| square | 0.0424 | 0.0422 | 2000.0 | {'data': (10000, 100)} |
| elemwise_mul | 0.0186 | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| broadcast_not_equal | 0.0262 | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| broadcast_logical_or | 0.019 | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| logical_not | 0.0366 | --- | 2097.1521 | {'data': (1024, 1024)} |
| logical_not | 0.0247 | --- | 20.0 | {'data': (10000, 1)} |
| logical_not | 0.0357 | --- | 2000.0 | {'data': (10000, 100)} |
| broadcast_add | 0.0284 | 0.0289 | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| broadcast_hypot | 0.0202 | 0.0233 | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| sign | 0.038 | 0.0333 | 2097.1521 | {'data': (1024, 1024)} |
| sign | 0.0269 | 0.0252 | 20.0 | {'data': (10000, 1)} |
| sign | 0.0379 | 0.0326 | 2000.0 | {'data': (10000, 100)} |
| arccos | 0.0385 | 0.0424 | 2097.1521 | {'data': (1024, 1024)} |
| arccos | 0.0268 | 0.0253 | 20.0 | {'data': (10000, 1)} |
| arccos | 0.0374 | 0.0413 | 2000.0 | {'data': (10000, 100)} |
| erf | 0.0383 | 0.0384 | 2097.1521 | {'data': (1024, 1024)} |
| erf | 0.0266 | 0.0247 | 20.0 | {'data': (10000, 1)} |
| erf | 0.0374 | 0.0384 | 2000.0 | {'data': (10000, 100)} |
| degrees | 0.0375 | 0.0326 | 2097.1521 | {'data': (1024, 1024)} |
| degrees | 0.0265 | 0.0247 | 20.0 | {'data': (10000, 1)} |
| degrees | 0.0376 | 0.0317 | 2000.0 | {'data': (10000, 100)} |
| fix | 0.0366 | --- | 2097.1521 | {'data': (1024, 1024)} |
| fix | 0.0251 | --- | 20.0 | {'data': (10000, 1)} |
| fix | 0.0362 | --- | 2000.0 | {'data': (10000, 100)} |
| cos | 0.0386 | 0.0389 | 2097.1521 | {'data': (1024, 1024)} |
| cos | 0.0276 | 0.0255 | 20.0 | {'data': (10000, 1)} |
| cos | 0.0385 | 0.0388 | 2000.0 | {'data': (10000, 100)} |
| broadcast_plus | --- | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| sample_exponential | 0.1359 | --- | 4194.3042 | {'lam': [1.0, 8.5], 'shape': (1024, 1024)} |
| sample_exponential | 0.0734 | --- | 40.0 | {'lam': [1.0, 8.5], 'shape': (10000, 1)} |
| sample_exponential | 0.1323 | --- | 4000.0 | {'lam': [1.0, 8.5], 'shape': (10000, 100)} |
| make_loss | 0.0415 | --- | 2097.1521 | {'data': (1024, 1024)} |
| make_loss | 0.0301 | --- | 20.0 | {'data': (10000, 1)} |
| make_loss | 0.0432 | --- | 2000.0 | {'data': (10000, 100)} |
| argmax_channel | 0.288 | --- | 2.048 | {'data': (1024, 1024)} |
| argmax_channel | 0.0264 | --- | 20.0 | {'data': (10000, 1)} |
| argmax_channel | 0.0439 | --- | 20.0 | {'data': (10000, 100)} |
| BlockGrad | 0.042 | --- | 2097.1521 | {'data': (1024, 1024)} |
| BlockGrad | 0.0295 | --- | 20.0 | {'data': (10000, 1)} |
| BlockGrad | 0.0438 | --- | 2000.0 | {'data': (10000, 100)} |
| BatchNorm | 1.1379 | 2.3158 | 12582.9238 | {'gamma': (3,), 'moving_var': (3,), 'data': (32, 3, 256, 256), 'beta': (3,), 'moving_mean': (3,)} |
| BatchNorm | 1.7465 | 3.5398 | 19200.0117 | {'gamma': (3,), 'moving_var': (3,), 'data': (32, 3, 10000, 10), 'beta': (3,), 'moving_mean': (3,)} |
| sample_negative_binomial | 1.5065 | --- | 4194.3042 | {'shape': (1024, 1024), 'p': [0.4, 0.77], 'k': [20, 49]} |
| sample_negative_binomial | 0.8542 | --- | 40.0 | {'shape': (10000, 1), 'p': [0.4, 0.77], 'k': [20, 49]} |
| sample_negative_binomial | 1.476 | --- | 4000.0 | {'shape': (10000, 100), 'p': [0.4, 0.77], 'k': [20, 49]} |
| batch_dot | 4.7282 | 9.3181 | 67108.8672 | {'lhs': (32, 1024, 1024), 'rhs': (32, 1024, 1024)} |
| batch_dot | 0.3021 | 1.229 | 64000.0 | {'lhs': (32, 1000, 10), 'transpose_b': True, 'rhs': (32, 1000, 10)} |
| batch_dot | 0.0523 | 0.0636 | 6.4 | {'lhs': (32, 1000, 1), 'transpose_b': True, 'transpose_a': True, 'rhs': (32, 100, 1000)} |
| rsqrt | 0.0386 | 0.0422 | 2097.1521 | {'data': (1024, 1024)} |
| rsqrt | 0.0268 | 0.0252 | 20.0 | {'data': (10000, 1)} |
| rsqrt | 0.0377 | 0.0408 | 2000.0 | {'data': (10000, 100)} |
| broadcast_logical_and | 0.0191 | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| mean | 0.0818 | 0.043 | 0.002 | {'axis': (), 'data': (1024, 1024)} |
| mean | 0.0384 | 0.026 | 0.002 | {'axis': 0, 'data': (10000, 1)} |
| mean | 0.0801 | 0.0421 | 0.002 | {'axis': (0, 1), 'data': (10000, 100)} |
| ceil | 0.0363 | --- | 2097.1521 | {'data': (1024, 1024)} |
| ceil | 0.0249 | --- | 20.0 | {'data': (10000, 1)} |
| ceil | 0.0357 | --- | 2000.0 | {'data': (10000, 100)} |
| min_axis | 0.0569 | --- | 0.002 | {'axis': (), 'data': (1024, 1024)} |
| min_axis | 0.0319 | --- | 0.002 | {'axis': 0, 'data': (10000, 1)} |
| min_axis | 0.0563 | --- | 0.002 | {'axis': (0, 1), 'data': (10000, 100)} |
| sigmoid | 0.0395 | 0.0392 | 2097.1521 | {'data': (1024, 1024)} |
| sigmoid | 0.0412 | 0.0256 | 20.0 | {'data': (10000, 1)} |
| sigmoid | 0.0378 | 0.0384 | 2000.0 | {'data': (10000, 100)} |
| broadcast_power | 0.0209 | 0.023 | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| gamma | 0.0415 | 0.0761 | 2097.1521 | {'data': (1024, 1024)} |
| gamma | 0.0279 | 0.0279 | 20.0 | {'data': (10000, 1)} |
| gamma | 0.041 | 0.0736 | 2000.0 | {'data': (10000, 100)} |
| radians | 0.0378 | 0.0327 | 2097.1521 | {'data': (1024, 1024)} |
| radians | 0.0268 | 0.0248 | 20.0 | {'data': (10000, 1)} |
| radians | 0.0373 | 0.032 | 2000.0 | {'data': (10000, 100)} |
| prod | 0.0671 | 0.0949 | 0.002 | {'axis': (), 'data': (1024, 1024)} |
| prod | 0.0334 | 0.0218 | 0.002 | {'axis': 0, 'data': (10000, 1)} |
| prod | 0.0663 | 0.091 | 0.002 | {'axis': (0, 1), 'data': (10000, 100)} |
| abs | 0.0382 | 0.039 | 2097.1521 | {'data': (1024, 1024)} |
| abs | 0.0271 | 0.0254 | 20.0 | {'data': (10000, 1)} |
| abs | 0.0369 | 0.0381 | 2000.0 | {'data': (10000, 100)} |
| reciprocal | 0.0378 | 0.0399 | 2097.1521 | {'data': (1024, 1024)} |
| reciprocal | 0.0267 | 0.0248 | 20.0 | {'data': (10000, 1)} |
| reciprocal | 0.0374 | 0.0391 | 2000.0 | {'data': (10000, 100)} |
| sample_generalized_negative_binomial | 1.0903 | --- | 4194.3042 | {'mu': [2.0, 2.5], 'alpha': [0.0, 2.5], 'shape': (1024, 1024)} |
| sample_generalized_negative_binomial | 0.6051 | --- | 40.0 | {'mu': [2.0, 2.5], 'alpha': [0.0, 2.5], 'shape': (10000, 1)} |
| sample_generalized_negative_binomial | 1.0655 | --- | 4000.0 | {'mu': [2.0, 2.5], 'alpha': [0.0, 2.5], 'shape': (10000, 100)} |
| rint | 0.0369 | --- | 2097.1521 | {'data': (1024, 1024)} |
| rint | 0.025 | --- | 20.0 | {'data': (10000, 1)} |
| rint | 0.0357 | --- | 2000.0 | {'data': (10000, 100)} |
| arcsin | 0.0383 | 0.0412 | 2097.1521 | {'data': (1024, 1024)} |
| arcsin | 0.0269 | 0.0253 | 20.0 | {'data': (10000, 1)} |
| arcsin | 0.038 | 0.0402 | 2000.0 | {'data': (10000, 100)} |
| sample_poisson | 0.4035 | --- | 4194.3042 | {'lam': [1.0, 8.5], 'shape': (1024, 1024)} |
| sample_poisson | 0.3288 | --- | 40.0 | {'lam': [1.0, 8.5], 'shape': (10000, 1)} |
| sample_poisson | 0.4029 | --- | 4000.0 | {'lam': [1.0, 8.5], 'shape': (10000, 100)} |
| Pooling | 0.0225 | 0.0262 | 49.152 | {'stride': 1, 'pool_type': 'avg', 'data': (32, 3, 256), 'layout': 'NCW', 'global_pool': 0, 'kernel': 3, 'pad': 1} |
| sample_uniform | 0.1386 | --- | 4194.3042 | {'shape': (1024, 1024), 'high': [1.0, 3.7], 'low': [0.0, 2.5]} |
| sample_uniform | 0.0776 | --- | 40.0 | {'shape': (10000, 1), 'high': [1.0, 3.7], 'low': [0.0, 2.5]} |
| sample_uniform | 0.1358 | --- | 4000.0 | {'shape': (10000, 100), 'high': [1.0, 3.7], 'low': [0.0, 2.5]} |
| ones_like | 0.0326 | --- | 2097.1521 | {'data': (1024, 1024)} |
| ones_like | 0.0251 | --- | 40.0 | {'data': (10000, 1)} |
| ones_like | 0.032 | --- | 2000.0 | {'data': (10000, 100)} |
| identity | --- | --- | 2097.1521 | {'data': (1024, 1024)} |
| identity | --- | --- | 40.0 | {'data': (10000, 1)} |
| identity | --- | --- | 2000.0 | {'data': (10000, 100)} |
| broadcast_lesser_equal | 0.0189 | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| broadcast_lesser | 0.0189 | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| zeros_like | 0.0326 | --- | 2097.1521 | {'data': (1024, 1024)} |
| zeros_like | 0.0252 | --- | 40.0 | {'data': (10000, 1)} |
| zeros_like | 0.0321 | --- | 2000.0 | {'data': (10000, 100)} |
| random_uniform | 3.1027 | --- | 2097.1521 | {'shape': (1024, 1024), 'high': 5, 'low': 0} |
| random_uniform | 0.0588 | --- | 20.0 | {'shape': (10000, 1), 'high': 5, 'low': 0} |
| random_uniform | 2.9599 | --- | 2000.0 | {'shape': (10000, 100), 'high': 5, 'low': 0} |
| broadcast_mod | 0.0196 | 0.0227 | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| cbrt | 0.0383 | 0.0405 | 2097.1521 | {'data': (1024, 1024)} |
| cbrt | 0.0272 | 0.0251 | 20.0 | {'data': (10000, 1)} |
| cbrt | 0.0377 | 0.0394 | 2000.0 | {'data': (10000, 100)} |
| broadcast_minus | --- | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| random_negative_binomial | 52.4089 | --- | 2097.1521 | {'shape': (1024, 1024), 'p': 1, 'k': 1} |
| random_negative_binomial | 0.5224 | --- | 20.0 | {'shape': (10000, 1), 'p': 1, 'k': 1} |
| random_negative_binomial | 49.9987 | --- | 2000.0 | {'shape': (10000, 100), 'p': 1, 'k': 1} |
| log2 | 0.0382 | 0.0405 | 2097.1521 | {'data': (1024, 1024)} |
| log2 | 0.0269 | 0.0253 | 20.0 | {'data': (10000, 1)} |
| log2 | 0.0376 | 0.0403 | 2000.0 | {'data': (10000, 100)} |
| broadcast_greater | 0.0191 | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| max_axis | 0.0564 | --- | 0.002 | {'axis': (), 'data': (1024, 1024)} |
| max_axis | 0.0315 | --- | 0.002 | {'axis': 0, 'data': (10000, 1)} |
| max_axis | 0.0561 | --- | 0.002 | {'axis': (0, 1), 'data': (10000, 100)} |
| sample_gamma | 0.3435 | --- | 4194.3042 | {'alpha': [0.0, 2.5], 'beta': [1.0, 0.7], 'shape': (1024, 1024)} |
| sample_gamma | 0.2938 | --- | 40.0 | {'alpha': [0.0, 2.5], 'beta': [1.0, 0.7], 'shape': (10000, 1)} |
| sample_gamma | 0.341 | --- | 4000.0 | {'alpha': [0.0, 2.5], 'beta': [1.0, 0.7], 'shape': (10000, 100)} |
| sin | 0.0382 | 0.0386 | 2097.1521 | {'data': (1024, 1024)} |
| sin | 0.0268 | 0.0244 | 20.0 | {'data': (10000, 1)} |
| sin | 0.0374 | 0.0386 | 2000.0 | {'data': (10000, 100)} |
| sum | 0.0797 | 0.0341 | 0.002 | {'axis': (), 'data': (1024, 1024)} |
| sum | 0.0362 | 0.021 | 0.002 | {'axis': 0, 'data': (10000, 1)} |
| sum | 0.0771 | 0.0335 | 0.002 | {'axis': (0, 1), 'data': (10000, 100)} |
| erfinv | 0.1069 | 0.1112 | 2097.1521 | {'data': (1024, 1024)} |
| erfinv | 0.029 | 0.0271 | 20.0 | {'data': (10000, 1)} |
| erfinv | 0.1043 | 0.1055 | 2000.0 | {'data': (10000, 100)} |
| random_gamma | 46.4529 | --- | 2097.1521 | {'shape': (1024, 1024)} |
| random_gamma | 0.466 | --- | 20.0 | {'shape': (10000, 1)} |
| random_gamma | 44.4208 | --- | 2000.0 | {'shape': (10000, 100)} |
| broadcast_mul | 0.019 | 0.0222 | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| arccosh | 0.0405 | 0.0414 | 2097.1521 | {'data': (1024, 1024)} |
| arccosh | 0.0269 | 0.0253 | 20.0 | {'data': (10000, 1)} |
| arccosh | 0.0396 | 0.0402 | 2000.0 | {'data': (10000, 100)} |
| log1p | 0.0383 | 0.0399 | 2097.1521 | {'data': (1024, 1024)} |
| log1p | 0.0269 | 0.0248 | 20.0 | {'data': (10000, 1)} |
| log1p | 0.0376 | 0.0394 | 2000.0 | {'data': (10000, 100)} |
| size_array | 0.0229 | --- | 0.004 | {'data': (1024, 1024)} |
| size_array | 0.0367 | --- | 0.004 | {'data': (10000, 1)} |
| size_array | 0.022 | --- | 0.004 | {'data': (10000, 100)} |
| arcsinh | 0.0396 | 0.0406 | 2097.1521 | {'data': (1024, 1024)} |
| arcsinh | 0.0269 | 0.0249 | 20.0 | {'data': (10000, 1)} |
| arcsinh | 0.0388 | 0.0396 | 2000.0 | {'data': (10000, 100)} |
| elemwise_div | 0.0188 | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| elemwise_add | 0.019 | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| elemwise_sub | 0.0186 | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| arctanh | 0.0385 | 0.0397 | 2097.1521 | {'data': (1024, 1024)} |
| arctanh | 0.0266 | 0.0245 | 20.0 | {'data': (10000, 1)} |
| arctanh | 0.0376 | 0.0391 | 2000.0 | {'data': (10000, 100)} |
| log | 0.0381 | 0.0399 | 2097.1521 | {'data': (1024, 1024)} |
| log | 0.0268 | 0.025 | 20.0 | {'data': (10000, 1)} |
| log | 0.0377 | 0.0394 | 2000.0 | {'data': (10000, 100)} |
| gammaln | 0.0461 | 0.0664 | 2097.1521 | {'data': (1024, 1024)} |
| gammaln | 0.0273 | 0.0266 | 20.0 | {'data': (10000, 1)} |
| gammaln | 0.0455 | 0.0645 | 2000.0 | {'data': (10000, 100)} |
| Dropout | 0.122 | 0.0957 | 25165.8242 | {'mode': 'always', 'data': (32, 3, 256, 256), 'p': 0.5} |
| Dropout | 0.0739 | 0.0241 | 400.0 | {'mode': 'always', 'data': (10000, 10), 'p': 0.5} |
| softmax | 0.0454 | 0.0438 | 2097.1521 | {'axis': -1, 'data': (1024, 1024), 'temperature': 0.5} |
| softmax | 0.056 | 0.0377 | 20.0 | {'axis': -1, 'data': (10000, 1), 'temperature': 0.5} |
| softmax | 0.0805 | 0.0609 | 2000.0 | {'axis': -1, 'data': (10000, 100), 'temperature': 0.5} |
| expm1 | 0.0386 | 0.0387 | 2097.1521 | {'data': (1024, 1024)} |
| expm1 | 0.0275 | 0.025 | 20.0 | {'data': (10000, 1)} |
| expm1 | 0.0375 | 0.0381 | 2000.0 | {'data': (10000, 100)} |
| log10 | 0.0382 | 0.0403 | 2097.1521 | {'data': (1024, 1024)} |
| log10 | 0.0274 | 0.0251 | 20.0 | {'data': (10000, 1)} |
| log10 | 0.0369 | 0.0386 | 2000.0 | {'data': (10000, 100)} |
| random_poisson | 15.4201 | --- | 2097.1521 | {'shape': (1024, 1024)} |
| random_poisson | 0.176 | --- | 20.0 | {'shape': (10000, 1)} |
| random_poisson | 14.9428 | --- | 2000.0 | {'shape': (10000, 100)} |
| sinh | 0.0381 | 0.0381 | 2097.1521 | {'data': (1024, 1024)} |
| sinh | 0.0269 | 0.0246 | 20.0 | {'data': (10000, 1)} |
| sinh | 0.0376 | 0.038 | 2000.0 | {'data': (10000, 100)} |
| random_normal | 16.4453 | --- | 2097.1521 | {'shape': (1024, 1024)} |
| random_normal | 0.1864 | --- | 20.0 | {'shape': (10000, 1)} |
| random_normal | 15.553 | --- | 2000.0 | {'shape': (10000, 100)} |
| hard_sigmoid | 0.031 | 0.0336 | 2097.1521 | {'alpha': 0.25, 'data': (1024, 1024), 'beta': 0.5} |
| hard_sigmoid | 0.0197 | 0.0182 | 20.0 | {'alpha': 0.25, 'data': (10000, 1), 'beta': 0.5} |
| hard_sigmoid | 0.0303 | 0.0322 | 2000.0 | {'alpha': 0.25, 'data': (10000, 100), 'beta': 0.5} |
| flatten | --- | --- | 2097.1521 | {'data': (1024, 1024)} |
| flatten | --- | --- | 20.0 | {'data': (10000, 1)} |
| flatten | --- | --- | 2000.0 | {'data': (10000, 100)} |
| random_exponential | 15.9188 | --- | 2097.1521 | {'shape': (1024, 1024)} |
| random_exponential | 0.1663 | --- | 40.0 | {'shape': (10000, 1)} |
| random_exponential | 15.1982 | --- | 2000.0 | {'shape': (10000, 100)} |
| tan | 0.0395 | 0.0377 | 2097.1521 | {'data': (1024, 1024)} |
| tan | 0.027 | 0.025 | 20.0 | {'data': (10000, 1)} |
| tan | 0.0384 | 0.037 | 2000.0 | {'data': (10000, 100)} |
| broadcast_equal | 0.019 | --- | 0.012 | {'lhs': [(1024, 1024), (10000, 10), (10000, 1)], 'rhs': [(1024, 1024), (10000, 10), (10000, 1)]} |
| softsign | 0.0384 | 0.0402 | 2097.1521 | {'data': (1024, 1024)} |
| softsign | 0.0269 | 0.025 | 20.0 | {'data': (10000, 1)} |
| softsign | 0.0375 | 0.04 | 2000.0 | {'data': (10000, 100)} |
| Convolution | 0.0578 | 0.1121 | 1040.384 | {'stride': (1,), 'data': (32, 3, 256), 'bias': (64,), 'layout': 'NCW', 'dilate': (1,), 'kernel': (3,), 'weight': (64, 3, 3), 'pad': (0,), 'num_filter': 64} |
| sample_normal | 0.1549 | --- | 4194.3042 | {'mu': [2.0, 2.5], 'sigma': [1.0, 3.7], 'shape': (1024, 1024)} |
| sample_normal | 0.1027 | --- | 40.0 | {'mu': [2.0, 2.5], 'sigma': [1.0, 3.7], 'shape': (10000, 1)} |
| sample_normal | 0.1522 | --- | 4000.0 | {'mu': [2.0, 2.5], 'sigma': [1.0, 3.7], 'shape': (10000, 100)} |
| exp | 0.0365 | --- | 2097.1521 | {'data': (1024, 1024)} |
| exp | 0.0246 | --- | 20.0 | {'data': (10000, 1)} |
| exp | 0.0356 | --- | 2000.0 | {'data': (10000, 100)} |
| sum_axis | 0.0637 | --- | 0.004 | {'axis': (), 'data': (1024, 1024)} |
| sum_axis | 0.0351 | --- | 0.002 | {'axis': 0, 'data': (10000, 1)} |
| sum_axis | 0.0631 | --- | 0.002 | {'axis': (0, 1), 'data': (10000, 100)} |