/*
    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.
*/

/* Fixed Data in ROM - Field and Curve parameters */

var ROM_CURVE_ANSSI,
    ROM_CURVE_BLS383,
    ROM_CURVE_BLS24,
    ROM_CURVE_BLS48,
    ROM_CURVE_BLS381,
    ROM_CURVE_BLS461,
    ROM_CURVE_FP256BN,
    ROM_CURVE_FP512BN,
    ROM_CURVE_BN254,
    ROM_CURVE_BN254CX,
    ROM_CURVE_BRAINPOOL,
    ROM_CURVE_C25519,
    ROM_CURVE_C41417,
    ROM_CURVE_ED25519,
    ROM_CURVE_GOLDILOCKS,
    ROM_CURVE_HIFIVE,
    ROM_CURVE_NIST256,
    ROM_CURVE_NIST384,
    ROM_CURVE_NIST521,
    ROM_CURVE_NUMS256E,
    ROM_CURVE_NUMS256W,
    ROM_CURVE_NUMS384E,
    ROM_CURVE_NUMS384W,
    ROM_CURVE_NUMS512E,
    ROM_CURVE_NUMS512W,
    ROM_CURVE_SECP256K1;

ROM_CURVE_ANSSI = function() {

    var ROM_CURVE_ANSSI = {

        // ANSSI curve

        Curve_Cof_I: 1,
        CURVE_A: -3,
        CURVE_B_I: 0,
        CURVE_B: [0x7BB73F, 0xED967B, 0x803075, 0xE4B1A1, 0xEC0C9A, 0xC00FDF, 0x754A44, 0xD4ABA, 0x28A930, 0x3FCA54, 0xEE35],
        CURVE_Order: [0xD655E1, 0xD459C6, 0x941FFD, 0x40D2BF, 0xDC67E1, 0x435B53, 0xE8CE42, 0x10126D, 0x3AD58F, 0x178C0B, 0xF1FD],
        CURVE_Gx: [0x8F5CFF, 0x7A2DD9, 0x164C9, 0xAF98B7, 0x27D2DC, 0x23958C, 0x4749D4, 0x31183D, 0xC139EB, 0xD4C356, 0xB6B3],
        CURVE_Gy: [0x62CFB, 0x5A1554, 0xE18311, 0xE8E4C9, 0x1C307, 0xEF8C27, 0xF0F3EC, 0x1F9271, 0xB20491, 0xE0F7C8, 0x6142],

    };
    return ROM_CURVE_ANSSI;
};

ROM_CURVE_BLS383 = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_BLS383 = {

        // BLS383 Curve
        // Base Bits= 23

        CURVE_Cof_I: 0,
        CURVE_A: 0,
        CURVE_B_I: 15,
        CURVE_B: [0xF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0x3C0001, 0x33D7FD, 0x5CEC82, 0x9069C, 0x5F095A, 0x703BC0, 0x5A62C, 0x2200E4, 0x3809C0, 0x1801, 0x8006, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Gx: [0x734573, 0x6E7210, 0x11E311, 0x1FA3B8, 0x5DBF08, 0x688B8A, 0x12BC78, 0x43DD6C, 0x742C2F, 0x6D6103, 0x4C767D, 0x6D8287, 0x74052D, 0x1C706B, 0x5E7B39, 0x5D2ADC, 0x41FC],
        CURVE_Gy: [0x3F224, 0x2CBD00, 0x7484B4, 0x43FCC7, 0x7D49EC, 0x25BBCA, 0x2B7AD3, 0x29854A, 0x449107, 0xCD76C, 0x7436B7, 0x6236CC, 0x1CDC31, 0x495D, 0x33ECC0, 0xB393A, 0x68F],

        CURVE_Bnx: [0x1200, 0x2, 0x40020, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cof: [0x169EAB, 0x2AC2AA, 0x7ED541, 0x555DF, 0x2AAC00, 0xAAB, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cru: [0x2AC2A9, 0x4EA05D, 0x4B730D, 0x16FB2E, 0x5F681A, 0x683784, 0xD37A8, 0x2917A5, 0x715CE2, 0x69B7BA, 0x15114, 0x4A43A3, 0x34406E, 0x1408B5, 0x2ADBAD, 0x2B4AB2, 0x5565],
        CURVE_Pxa: [0x7F2D86, 0x676C5A, 0x7850F2, 0x4AE8E9, 0x7DAB67, 0x65DD03, 0x3D5895, 0x3F8E48, 0x725BD4, 0x10A5AA, 0xC9407, 0xF3A32, 0x967CB, 0x180F32, 0x7B00FA, 0x691203, 0x634],
        CURVE_Pxb: [0x52DE15, 0x483D88, 0x37BF67, 0x2BFF30, 0x4AB28D, 0x3AEB6A, 0x23A4B5, 0x6CC5D4, 0x4C89DF, 0x5B3A0B, 0x13D263, 0x1B0EE9, 0x717288, 0x5E6F4E, 0x592E, 0x3C0030, 0x300D],
        CURVE_Pya: [0x8CB41, 0x617728, 0x5971A3, 0x106B0C, 0x1EDE4F, 0x5CEB69, 0x2A44E8, 0x4BC1D6, 0x1B3E68, 0x2CE793, 0x3A643B, 0x31A3DB, 0x573FE, 0x79293B, 0x4894D1, 0x167C9E, 0x3379],
        CURVE_Pyb: [0x479093, 0xC86FE, 0x18EB61, 0x731124, 0x43CB0D, 0x131602, 0x127DEF, 0x78597A, 0x7A8F7A, 0x8D67D, 0x73835, 0x53D700, 0x3A7D15, 0x649DCF, 0x33631A, 0x123EE9, 0x20E5],
        CURVE_W: [
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_SB: [
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ]
        ],
        CURVE_WB: [
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_BB: [
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ]
        ],

        USE_GLV: true,
        USE_GS_G2: true,
        USE_GS_GT: true,
        GT_STRONG: true,

        //debug: false,

    };

    return ROM_CURVE_BLS383;
};


ROM_CURVE_BLS24 = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_BLS24 = {

        // BLS24 Curve
        // Base Bits= 23
        CURVE_Cof_I: 0,
        CURVE_A: 0,
        CURVE_B_I: 19,
        CURVE_B: [0x13, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0x1, 0x11FFE0, 0x464068, 0x1FFAA8, 0x71E703, 0x645BB5, 0x379FB8, 0x689D35, 0x49D0CE, 0x49091F, 0x4A7308, 0x286C0B, 0x3B44A0, 0x60B731, 0x6807C3, 0x8002, 0x10010, 0x0, 0x0, 0x0, 0x0],
        CURVE_Gx: [0x63CCD4, 0x41EBD7, 0x15919D, 0x576CFA, 0x1EFE2D, 0x743F98, 0xFC23A, 0x409A3C, 0x595AF8, 0x6F8DF1, 0x38B611, 0x65468D, 0x7E4BFD, 0x6B0D9D, 0x7641D, 0x2ECCDE, 0xB7FEA, 0x5BD3C3, 0x2BE521, 0x71A0BE, 0x1AB2B],
        CURVE_Gy: [0x1E5245, 0x4B95A4, 0x5B132E, 0x462AEF, 0x36D660, 0x672E8D, 0x7B4A53, 0x79E459, 0x24920F, 0x4828B0, 0x58F969, 0x1D527E, 0x4E00F6, 0x457EF3, 0x66924A, 0x294FFB, 0x66A7A4, 0x70C394, 0x4F91DE, 0x386362, 0x47FCB],

        CURVE_Bnx: [0x11FF80, 0x400, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cof: [0x7415AB, 0x7F7FF3, 0x5FFF07, 0x2AB555, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cru: [0x5794A9, 0x4E28DB, 0x690EF0, 0x1C5799, 0x63A309, 0x447BB8, 0x4485D4, 0x36FDD8, 0x7BB423, 0xE24B9, 0x5E7398, 0x11AC71, 0x806E0, 0x18DD64, 0x5DF5A0, 0x4307F, 0x314C20, 0x4D1C8, 0x2F16A2, 0x3C01E, 0x555C0],
        CURVE_Pxaa: [0x624678, 0x26A6E9, 0x22F8A, 0x212C12, 0x60C343, 0x3DF8D3, 0x5D9733, 0x6BFC87, 0x2D2888, 0x758675, 0x259D1C, 0x7E922C, 0x4BAB37, 0x11DAAB, 0x6214A4, 0x758A55, 0x786671, 0x72B190, 0x32581D, 0x729D1F, 0x959D],
        CURVE_Pxab: [0x3099B8, 0x3D75FF, 0x40E1FE, 0x9523, 0x63775A, 0x78470A, 0x5746C7, 0x7CF1B5, 0x26A730, 0x14FE14, 0x76CA97, 0x61C7C2, 0x669261, 0x6A7C2F, 0x3E5DA9, 0x5F2D68, 0x2D39D1, 0x4A3C98, 0x4CF7F1, 0x68418B, 0x3B0DE],
        CURVE_Pxba: [0x2D15D3, 0x1BCE23, 0x5BB687, 0x46FB70, 0x185317, 0x47C134, 0x2FD0FA, 0x3597B2, 0x56DE56, 0x165B19, 0x1D3F6E, 0x10E136, 0x76B1EF, 0x1913C7, 0x4011EF, 0x1F994F, 0x3FE210, 0x545186, 0x41EBCA, 0x7D6A72, 0x3EC27],
        CURVE_Pxbb: [0x60F480, 0x650EBD, 0x2E31EA, 0x21EB62, 0x14556E, 0x1C3973, 0x48B7E0, 0xFFEFD, 0x50122F, 0x55EE1F, 0x263BD7, 0x2ED92B, 0x1BA3AD, 0x39C35E, 0x2DD201, 0x17232E, 0x1DA7CE, 0x4CB0AA, 0x1E67DF, 0x46DE50, 0xA5B3],
        CURVE_Pyaa: [0x781AA0, 0x132628, 0x2AC619, 0x181DB8, 0x3609DA, 0x3F8897, 0x4A9851, 0x189252, 0x4C42A, 0x768C5C, 0x66B9A2, 0x1C1D70, 0x4FCADC, 0x69ED7C, 0x7D286C, 0xD685, 0x198F9, 0x459DA0, 0x30250D, 0x1AEB9B, 0x5057F],
        CURVE_Pyab: [0x2E08FA, 0x58AFDD, 0x5AB6EF, 0x5D52FC, 0x78774, 0x348594, 0x32BC26, 0x23C32, 0x3BCCF7, 0xB913F, 0x3E1549, 0x5B907F, 0x77B3E6, 0x22C6ED, 0x7865FE, 0x3DAEFB, 0x60F558, 0x702D7A, 0x3A258D, 0x24B30F, 0x2CE2B],
        CURVE_Pyba: [0x70CC41, 0x4ED4B, 0x7D5CC, 0x2A9855, 0x7F8932, 0x5F1428, 0x7361E6, 0x14406C, 0x68A9FE, 0x21DCA7, 0x4DC54E, 0x10783E, 0x71F3A4, 0x3AA336, 0x6C5305, 0x1E5ADC, 0x1A39DD, 0x7C73F0, 0x18C69A, 0x2331F7, 0x18070],
        CURVE_Pybb: [0x5C1CAE, 0x65CCA2, 0x2373C6, 0x2AD84C, 0x2D40D3, 0x714EEE, 0x10FF70, 0x3AE561, 0x136B6, 0x3EBA67, 0x75CBF3, 0x327450, 0x161AC1, 0x5CB9A1, 0x2C42EE, 0x48BB8F, 0x56D046, 0x725081, 0x77B22D, 0x2756CD, 0x499D1],
        CURVE_W: [
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_SB: [
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ]
        ],
        CURVE_WB: [
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_BB: [
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ]
        ],

        USE_GLV: true,
        USE_GS_G2: true,
        USE_GS_GT: true,
        GT_STRONG: true,

        //debug: false,
    };

    return ROM_CURVE_BLS24;
};

ROM_CURVE_BLS48 = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_BLS48 = {

        // BLS48 Curve
        // Base Bits= 23
        CURVE_Cof_I: 0,
        CURVE_A: 0,
        CURVE_B_I: 17,
        CURVE_B: [0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0x1, 0x7E0000, 0x421BFF, 0x714ED3, 0x455409, 0x53842, 0x7AC588, 0x7E8A68, 0xAD8C1, 0x184DA5, 0x7FB5E2, 0x5E936, 0x5EF479, 0x12B881, 0x46FE3F, 0x32FD85, 0x2973C4, 0x3D260D, 0x318DF1, 0x88D57, 0x3F73EA, 0x1887, 0x0, 0x0, 0x0],
        CURVE_Gx: [0x571D33, 0x5A5ECB, 0x3FCA1, 0x7F196F, 0x580554, 0x23DC17, 0x591DC, 0x1987F8, 0x7CA7F6, 0x345E03, 0x203D9A, 0x1734D, 0x444E07, 0x5602B2, 0x5003E, 0x5961D5, 0x30D242, 0x336BC2, 0x79241, 0xE0499, 0x7EDD74, 0x3B712A, 0x215D65, 0x544F49, 0x9],
        CURVE_Gy: [0x6ED83A, 0x367FD4, 0x33DA69, 0x254538, 0x5C4B95, 0x2B0CEF, 0x7AA39A, 0x47D9C8, 0x677B5F, 0x4F9E3D, 0x6DC8A6, 0x71C0C7, 0x4B44E2, 0x4AA8F1, 0x4C3099, 0x3071E3, 0x240862, 0x1B9CCF, 0x579C4, 0x4D1997, 0x3349DA, 0x3F5C56, 0x5318B1, 0x56C684, 0x0],

        CURVE_Bnx: [0x640020, 0xFB, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cof: [0x12ABEB, 0x221EFE, 0x528B, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cru: [0x3BA429, 0x1CFCD9, 0x1600D9, 0x49A7BA, 0x4E30A2, 0x101275, 0xF1A0C, 0x6D146E, 0x42B839, 0x118594, 0x4EF0B4, 0x55CDB, 0x67127B, 0x3D8D31, 0x319233, 0x2571C, 0x1AEEFF, 0x72BC73, 0x91318, 0x1911E0, 0x279F78, 0x646407, 0x73DF3B, 0x68BEC1, 0xF],
        CURVE_Pxaaa: [0x23CE4A, 0x5D1D12, 0x74AA34, 0x695C09, 0x3D7102, 0x274419, 0x76284C, 0x69F0B2, 0x4637C1, 0x5FE3FE, 0x242E62, 0x3F853E, 0x4DD2B3, 0x672BDE, 0x6ED92, 0x2B9BAD, 0x6C4ABF, 0x393882, 0x32EE21, 0x2EF3A1, 0x59487E, 0x92F4B, 0x26870, 0x32BC6C, 0xE],
        CURVE_Pxaab: [0xA1BE1, 0x1B8B58, 0x7DC9C7, 0x3BEB, 0x28FE3B, 0x72E58B, 0x51E10C, 0x31856A, 0x389247, 0x15B9FD, 0x2847EA, 0x2E35A0, 0x9B0E7, 0x7F92CE, 0x6960C8, 0xC5821, 0x48632D, 0xC919C, 0x3C27F4, 0x2A934D, 0x348B6E, 0x2F6B1B, 0x179D2A, 0x4A1009, 0x2],
        CURVE_Pxaba: [0xC5DC4, 0x6498EE, 0x4B68E9, 0x6ED677, 0x2964AD, 0x7D8E6D, 0x4D0966, 0x550884, 0x1926AC, 0x47162D, 0x633555, 0x265962, 0x6402B8, 0x48F745, 0x68195F, 0x198B3A, 0x117CE2, 0x5E9EFB, 0x729335, 0x471F6E, 0x3689BA, 0x3BB4F1, 0x3DDB5C, 0x297F7C, 0xB],
        CURVE_Pxabb: [0x64B740, 0x52CD34, 0x578358, 0x464902, 0x11FD49, 0x475BA2, 0x5C150C, 0x436206, 0x335E27, 0x7CFA66, 0x53BA9F, 0x39E20F, 0x41E3C, 0x30CB43, 0x5E7D7A, 0x4869DA, 0x6B405, 0x57B683, 0x77306A, 0x3E774A, 0x63B1A6, 0x4BE47E, 0x764B7F, 0x1C2054, 0x9],
        CURVE_Pxbaa: [0x71E01F, 0x18C2E5, 0x26EC, 0x1A5853, 0x4311CD, 0x430F11, 0x43E8E4, 0x20204C, 0x35AB89, 0x775C07, 0x43202C, 0x442943, 0x1E3472, 0xB1BEA, 0x14841D, 0x56A6A1, 0x4E27C3, 0x6AC397, 0x111E6A, 0x453F3C, 0x449D32, 0x6288F9, 0x7D0633, 0x6F0F7B, 0xD],
        CURVE_Pxbab: [0x37383D, 0x70470C, 0x66C28, 0x7CCC3F, 0x220253, 0x27A425, 0x147B57, 0x64A9AE, 0x7A0147, 0x61CE2B, 0x7620BF, 0x1CEB9B, 0x3F1646, 0x5546DC, 0x12AEC8, 0x2A6D46, 0x38885E, 0xA7FD0, 0x3A2974, 0x7872F1, 0x4F91FB, 0x2ADE02, 0x632141, 0x16D9D3, 0x8],
        CURVE_Pxbba: [0x11939C, 0x7B67AE, 0x6BA5A0, 0x34D20C, 0x1BE51D, 0x65ED81, 0x6D5CB3, 0x6465E6, 0x40B384, 0x146E44, 0x54F471, 0x119F79, 0x11A9B3, 0x5235B8, 0x342402, 0x6B0380, 0x51A403, 0x22E30F, 0x1F23BA, 0x468CDF, 0x5A9CCF, 0x77C486, 0x613650, 0x411539, 0xA],
        CURVE_Pxbbb: [0x6F4899, 0x2150A, 0x750CB5, 0x4952B2, 0x1C51EB, 0x179378, 0x295E64, 0x5B5457, 0x47A789, 0x1403F8, 0x62578C, 0x2F5D38, 0x7FE82C, 0x6CFF62, 0x32162, 0x3ACBE5, 0x1E3000, 0x668F, 0x426A4B, 0x4F46ED, 0x57A328, 0x62ACF0, 0xF705B, 0x7BAA3C, 0xD],
        CURVE_Pyaaa: [0x137844, 0x2F9F68, 0x4DDB82, 0x4FFA79, 0x44EC64, 0x6D10A3, 0x1BEAF1, 0x4B2F5C, 0xB8A71, 0x20AB1C, 0x225B80, 0x663E7C, 0x673C10, 0x7E8EA9, 0x2FC388, 0x66E9CC, 0x202F56, 0x39587C, 0x343E8C, 0x52C8BF, 0x6190B, 0x11FB0E, 0x6124D5, 0x337685, 0x7],
        CURVE_Pyaab: [0x483190, 0x6491DB, 0x424978, 0x23544C, 0x2EAAF4, 0x31A65, 0x48EEB1, 0x7EEB0E, 0x91F2F, 0x2D992C, 0xF07C, 0x4AE56F, 0x688ED2, 0x62E3A0, 0x284758, 0x15CF7, 0x7E205E, 0x9FA40, 0x24EA65, 0xCE87C, 0x7A1C42, 0x1C4D1D, 0x4F76AA, 0x3CE59C, 0x2],
        CURVE_Pyaba: [0x185C0D, 0x3FA083, 0xFA771, 0x50C8EE, 0xD404D, 0x759D3, 0x697D52, 0x6598BC, 0x685C7C, 0x612D58, 0x160D06, 0x2201F3, 0x5C797C, 0x10C374, 0xE7E1C, 0x52FA00, 0x1F60B0, 0x42B24, 0x7635E0, 0xDD262, 0x140D61, 0x26A7E6, 0x595FBC, 0x22CDE4, 0xD],
        CURVE_Pyabb: [0x1D42F8, 0x41502B, 0x5D7DBF, 0x88B12, 0x243AFD, 0x3CFE57, 0x4EC3FA, 0x2FB013, 0x7C3CFF, 0x1D3717, 0x79401A, 0x33C434, 0x635F37, 0x29E4F6, 0x2CA2DB, 0x7A8EF0, 0x3FD902, 0x3309C9, 0x1F125B, 0x3FF0C9, 0x7310, 0x3137DB, 0x280E0B, 0x70755, 0xA],
        CURVE_Pybaa: [0x38039F, 0x25673E, 0x184354, 0x3E78D1, 0xEE895, 0x1279F, 0x285016, 0x445C85, 0x4BFE85, 0x7F8597, 0x2AEDD5, 0x2E62F9, 0x32710C, 0x4F5B51, 0x59016C, 0x6178C7, 0x6E268E, 0x2D39EF, 0x2C36B6, 0x717762, 0x1D1ABC, 0x323714, 0x7C7BB9, 0x582324, 0x2],
        CURVE_Pybab: [0x5F7865, 0x40DE52, 0x20E9A7, 0x7439D3, 0x3F0756, 0x595BAF, 0x7CFC76, 0x287B18, 0x56074E, 0x186679, 0x416EC0, 0x1DC812, 0x127FBE, 0x18D9B5, 0x3C4A9D, 0x1C2BB4, 0x135CA4, 0x7A40AC, 0x739984, 0x6F008C, 0x7180EA, 0x58AF6D, 0x5B4B02, 0x9194C, 0x3],
        CURVE_Pybba: [0x4C1979, 0x753ECF, 0x6F0760, 0x3BB13C, 0x4AAF9C, 0x6BFB52, 0x470858, 0x41323D, 0x5401D8, 0x494404, 0x5CCF5C, 0xBCF06, 0x7E6ECF, 0x5A9C20, 0xD2DFF, 0x64FF44, 0x31645B, 0x4EE883, 0x4E22EC, 0x112445, 0x486C5C, 0x5C8211, 0x67DA66, 0x400692, 0xC],
        CURVE_Pybbb: [0x49F25B, 0x12AC5F, 0x5D33F2, 0x35D356, 0x2C4F80, 0x3A4C9E, 0x3C5A72, 0x426C74, 0x5DAC92, 0x52C146, 0x61366B, 0x6CDE77, 0x5A9E8F, 0x6DFF70, 0x6D20E3, 0x5A60E6, 0x33DF1A, 0x2AFA7, 0x390F0, 0x6320A2, 0x3F5493, 0x1CC373, 0x174990, 0x7B09B, 0xA],
        CURVE_W: [
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_SB: [
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ]
        ],
        CURVE_WB: [
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_BB: [
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ]
        ],

        USE_GLV: true,
        USE_GS_G2: true,
        USE_GS_GT: true,
        GT_STRONG: true,

        //debug: false,


    };

    return ROM_CURVE_BLS48;
};


ROM_CURVE_BLS381 = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_BLS381 = {

        // BLS381 Curve
        // Base Bits= 23

        CURVE_Cof_I: 0,
        CURVE_A: 0,
        CURVE_B_I: 4,
        CURVE_B: [0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0x1, 0x7FFE00, 0x7BFFFF, 0x7FF2DF, 0x5A402F, 0xAA77, 0x26876, 0x1CEC04, 0x7D4833, 0x26533A, 0x4FB69D, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Gx: [0x22C6BB, 0x6015B6, 0x3FECEB, 0x4BD0D7, 0x5E83FF, 0xB0D8A, 0x45C6EB, 0x271D1F, 0x3905A1, 0x1F2EE9, 0xDA231, 0x4D607E, 0x38C4FA, 0x4D2AC, 0x65F5E5, 0x69D398, 0x17F1],
        CURVE_Gy: [0x45E7E1, 0x46528D, 0x1032A8, 0x144457, 0x4C744A, 0x7DBA07, 0x4B012C, 0x6D8C65, 0xAF600, 0x2BABA0, 0x73D782, 0x6C5727, 0xED741, 0x3413C6, 0x6AA83C, 0x7A40F1, 0x8B3],

        CURVE_Bnx: [0x10000, 0x0, 0x34804, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cof: [0xAAAB, 0x555600, 0x5A3002, 0x2AAF0A, 0x48C005, 0x72D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cru: [0x7EFFFE, 0x7FFFFF, 0x8B807, 0x105000, 0x7D8136, 0x511BC2, 0x79BE25, 0x59D49D, 0x77EADD, 0xED41E, 0x69A718, 0x36728D, 0x72FDF7, 0xBE32C, 0x0, 0x0, 0x0],

        CURVE_Pxa: [0x21BDB8, 0x2D9182, 0x3F5201, 0x402DDF, 0x40326A, 0x2EE175, 0x1EB8F4, 0x2885B2, 0x3B02B4, 0x29F480, 0x1B91EB, 0x28828E, 0x5272DC, 0x24C100, 0x23C2A4, 0x515978, 0x24A],
        CURVE_Pxb: [0x42B7E, 0x7A0ABA, 0x5F96B1, 0x1CA2EA, 0x4F1121, 0x92669, 0x771FD4, 0x6D30DD, 0x361AB5, 0x213241, 0x65AF43, 0x3A7B2A, 0x3A0882, 0xFB59A, 0x1C67D8, 0x15B029, 0x13E0],
        CURVE_Pya: [0x382801, 0x290C11, 0x27864D, 0x5D6514, 0x2C9CC3, 0x259247, 0x545834, 0x214D34, 0x53A76D, 0x55197B, 0x37F66E, 0x71A8D5, 0x5C6DA2, 0x319939, 0x1F5B84, 0x6A93B9, 0xCE5],
        CURVE_Pyb: [0x5F79BE, 0xEBFE0, 0x6AAA4, 0x6760ED, 0x70D275, 0x3567E6, 0x55CBA6, 0x3A4955, 0x63AF26, 0x7D0B4E, 0x2CF8A1, 0x145CCE, 0x2B02BC, 0x6559A, 0x29CD33, 0x625017, 0x606],
        CURVE_W: [
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_SB: [
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ]
        ],
        CURVE_WB: [
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_BB: [
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ]
        ],

        USE_GLV: true,
        USE_GS_G2: true,
        USE_GS_GT: true,
        GT_STRONG: false,

        //debug: false,

    };

    return ROM_CURVE_BLS381;
};


ROM_CURVE_BLS461 = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_BLS461 = {

        // BLS461 Curve
        // Base Bits= 23

        Curve_Cof_I : 0,
        CURVE_A: 0,
        CURVE_B_I: 9,
        CURVE_B: [0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0x1, 0x0, 0x700000, 0x7F7FFF, 0x7FEFF, 0x22000, 0x7F2000, 0x7E00BF, 0xE801, 0x40BFA0, 0x5FF, 0x7FE00C, 0x7FFF7F, 0x1FF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Gx: [0x5EE93D, 0x4D515, 0x504534, 0x773A5B, 0x2D9C00, 0x6358FE, 0x6606D4, 0x4114E1, 0x4DC921, 0x21A6AC, 0x282599, 0x7BE149, 0x436166, 0x45632E, 0x1A2FA4, 0x38967B, 0xC8132, 0x476E74, 0x3A66D1, 0x56873A, 0x0],
        CURVE_Gy: [0x51D465, 0x462AF5, 0x51C3DD, 0x64627F, 0x517884, 0x71A42B, 0x6799A, 0x2CE854, 0x245F49, 0x15CB86, 0x2E1244, 0x45FD20, 0x16EECB, 0x3F197D, 0x3322FE, 0x1793BD, 0x5F1C3F, 0x3ED192, 0x452CC1, 0x3BDE6D, 0x0],

        CURVE_Bnx: [0x0, 0x7FFC00, 0x7FFFEF, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cof: [0x2AAAAB, 0x7FFD55, 0x5AAA9F, 0x5580AA, 0x7D55AA, 0x2A9FFF, 0x5555, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cru: [0x7FFFFE, 0x3FF, 0x10, 0x7FFF00, 0x7FFE7F, 0x61FFED, 0x311F, 0x630239, 0x6DB7BC, 0x622AF2, 0x73D1DD, 0x43AA19, 0x3F0E89, 0xA04C2, 0x581400, 0x7F5FFF, 0x1FFFF, 0x0, 0x0, 0x0, 0x0],
        CURVE_Pxa: [0x50A37C, 0x20630D, 0x31196D, 0x173AEE, 0x1C2E49, 0x2D0F15, 0x7E467, 0x7AB270, 0x74FF92, 0x610DB6, 0x19A00F, 0x36AC0D, 0x6D78D4, 0x78520F, 0x224BE5, 0x1E1386, 0x767945, 0x4A1535, 0x4E281A, 0x662A0, 0x1],
        CURVE_Pxb: [0x41C0AD, 0x395185, 0x37A7E1, 0x6212E5, 0x16CD66, 0x4512C1, 0x4A546, 0x200D63, 0x3EBEE2, 0x7AA535, 0x7D96C5, 0x504E99, 0x45AF5B, 0x6E3DA9, 0x4B9350, 0x123533, 0x2279D2, 0x1D46F9, 0x53F96B, 0x4AE0FD, 0x0],
        CURVE_Pya: [0x2FB006, 0x218360, 0xCDF33, 0x525095, 0x53D194, 0x125912, 0x5833F3, 0x6345A4, 0xF39F, 0x1E7536, 0x7B46E8, 0x3EDDE2, 0x4DFD8A, 0x5EF53, 0x3489F3, 0x7A739F, 0x6070F4, 0x74FCCE, 0x1239FA, 0x113564, 0x0],
        CURVE_Pyb: [0x71457C, 0xD5BFB, 0x2A294, 0x6E0261, 0x4D6A31, 0x6DC7F6, 0x26A3C4, 0x2B3475, 0x64492F, 0x2E7877, 0x19E84A, 0x25F55D, 0x220BE7, 0x5C70AD, 0x7C1310, 0x228AB, 0x2AB1D0, 0x6805D4, 0x6D3EAE, 0x71C080, 0x0],
        CURVE_W: [
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_SB: [
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ]
        ],
        CURVE_WB: [
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_BB: [
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ]
        ],

        USE_GLV: true,
        USE_GS_G2: true,
        USE_GS_GT: true,
        GT_STRONG: false,

        //debug: false,

    };

    return ROM_CURVE_BLS461;
};

ROM_CURVE_FP256BN = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_FP256BN = {

        // FP256BN Curve
        // Base Bits= 24

        Curve_Cof_I : 1,
        CURVE_A: 0,
        CURVE_B_I: 3,
        CURVE_B: [0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0xB500D, 0x536CD1, 0x1AF62D, 0x129992, 0xDC65FB, 0xA49E0C, 0x5EEE71, 0x46E5F2, 0xFCF0CD, 0xFFFFFF, 0xFFFF],
        CURVE_Gx: [0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Gy: [0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],

        CURVE_Bnx: [0xB0A801, 0xF5C030, 0x6882, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cof: [0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cru: [0xA1B807, 0xA24A3, 0x1EDB1C, 0xF1932D, 0xCDD79D, 0x18659B, 0x409210, 0x3988E1, 0x1, 0x0, 0x0],
        CURVE_Pxa: [0xC09EFB, 0x16B689, 0x3CD226, 0x12BF84, 0x1C539A, 0x913ACE, 0x577C28, 0x28560F, 0xC96C20, 0x3350B4, 0xFE0C],
        CURVE_Pxb: [0x7E6A2B, 0xED34A3, 0x89D269, 0x87D035, 0xDD78E2, 0x13B924, 0xC637D8, 0xDB5AE1, 0x8AC054, 0x605773, 0x4EA6],
        CURVE_Pya: [0xDC27FF, 0xB481BE, 0x48E909, 0x8D6158, 0xCB2475, 0x3E51EF, 0x75124E, 0x76770D, 0x42A3B3, 0x46E7C5, 0x7020],
        CURVE_Pyb: [0xAD049B, 0x81114A, 0xB3E012, 0x821A98, 0x4CBE80, 0xB29F8B, 0x49297E, 0x42EEA6, 0x88C290, 0xE3BCD3, 0x554],

        CURVE_W: [
            [0x54003, 0x36E1B, 0x663AF0, 0xFFFE78, 0xFFFFFF, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x615001, 0xEB8061, 0xD105, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_SB: [
            [
                [0x669004, 0xEEEE7C, 0x670BF5, 0xFFFE78, 0xFFFFFF, 0xFF, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x615001, 0xEB8061, 0xD105, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x615001, 0xEB8061, 0xD105, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x6100A, 0x4FFEB6, 0xB4BB3D, 0x129B19, 0xDC65FB, 0xA49D0C, 0x5EEE71, 0x46E5F2, 0xFCF0CD, 0xFFFFFF, 0xFFFF]
            ]
        ],
        CURVE_WB: [
            [0x30A800, 0x678F0D, 0xCC1020, 0x5554D2, 0x555555, 0x55, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x7DC805, 0x764C0D, 0xAD1AD6, 0xA10BC3, 0xDE8FBE, 0x104467, 0x806160, 0xD105EB, 0x0, 0x0, 0x0],
            [0x173803, 0xB6061F, 0xD6C1AC, 0x5085E1, 0xEF47DF, 0x82233, 0xC030B0, 0x6882F5, 0x0, 0x0, 0x0],
            [0x91F801, 0x530F6E, 0xCCE126, 0x5554D2, 0x555555, 0x55, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_BB: [
            [
                [0x5AA80D, 0x5DACA0, 0x1A8DAA, 0x129992, 0xDC65FB, 0xA49E0C, 0x5EEE71, 0x46E5F2, 0xFCF0CD, 0xFFFFFF, 0xFFFF],
                [0x5AA80C, 0x5DACA0, 0x1A8DAA, 0x129992, 0xDC65FB, 0xA49E0C, 0x5EEE71, 0x46E5F2, 0xFCF0CD, 0xFFFFFF, 0xFFFF],
                [0x5AA80C, 0x5DACA0, 0x1A8DAA, 0x129992, 0xDC65FB, 0xA49E0C, 0x5EEE71, 0x46E5F2, 0xFCF0CD, 0xFFFFFF, 0xFFFF],
                [0x615002, 0xEB8061, 0xD105, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x615001, 0xEB8061, 0xD105, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x5AA80C, 0x5DACA0, 0x1A8DAA, 0x129992, 0xDC65FB, 0xA49E0C, 0x5EEE71, 0x46E5F2, 0xFCF0CD, 0xFFFFFF, 0xFFFF],
                [0x5AA80D, 0x5DACA0, 0x1A8DAA, 0x129992, 0xDC65FB, 0xA49E0C, 0x5EEE71, 0x46E5F2, 0xFCF0CD, 0xFFFFFF, 0xFFFF],
                [0x5AA80C, 0x5DACA0, 0x1A8DAA, 0x129992, 0xDC65FB, 0xA49E0C, 0x5EEE71, 0x46E5F2, 0xFCF0CD, 0xFFFFFF, 0xFFFF]
            ],
            [
                [0x615002, 0xEB8061, 0xD105, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x615001, 0xEB8061, 0xD105, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x615001, 0xEB8061, 0xD105, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x615001, 0xEB8061, 0xD105, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0xB0A802, 0xF5C030, 0x6882, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0xC2A002, 0xD700C2, 0x1A20B, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0xAA000A, 0x67EC6F, 0x1A2527, 0x129992, 0xDC65FB, 0xA49E0C, 0x5EEE71, 0x46E5F2, 0xFCF0CD, 0xFFFFFF, 0xFFFF],
                [0xB0A802, 0xF5C030, 0x6882, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ]
        ],

        USE_GLV: true,
        USE_GS_G2: true,
        USE_GS_GT: true,
        GT_STRONG: false,

        //debug: false,

    };

    return ROM_CURVE_FP256BN;
};

ROM_CURVE_FP512BN = function() {

    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_FP512BN = {

        // FP512BN Curve

        // Base Bits= 23


        Curve_Cof_I : 1,
        CURVE_A: 0,
        CURVE_B_I: 3,
        CURVE_B: [0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0x1A09ED, 0x14BEA3, 0x501A99, 0x27CD15, 0x313E0, 0x346942, 0x2AC99E, 0x4632EF, 0x18B8E4, 0x3D597D, 0x451B3C, 0x77A22, 0x3C111B, 0x78177C, 0x32D4C1, 0x5D0EC, 0x7F01C6, 0x7FF3D8, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x3F],
        CURVE_Gx: [0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Gy: [0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],

        CURVE_Bnx: [0x1BD80F, 0xD76BC, 0x4042CC, 0x587BF, 0x2F5C03, 0xD10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cof: [0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cru: [0x79298A, 0x2C4138, 0x52C1C, 0x5C58BE, 0x6E6799, 0x1255D9, 0x2F9498, 0x43C4B3, 0x507ACD, 0x11384E, 0x1D2C80, 0x8FD18, 0x78EF76, 0x71D459, 0x2E1ACD, 0x1530A3, 0x7DC83D, 0x7FF3D8, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x3F],
        CURVE_Pxa: [0x3646B5, 0x52DC1B, 0x7A3C1E, 0x48397F, 0xF8731, 0x71E443, 0x6F2EF1, 0x2BDF10, 0x4DC6DC, 0x70C6A2, 0x40914D, 0x3C6685, 0x5A57CC, 0x3736AF, 0x4D63C3, 0x5DE94D, 0x6A1E4B, 0x25E79, 0x6E9D, 0x244AC4, 0x1E1386, 0x62CA67, 0xE],
        CURVE_Pxb: [0xAE0E9, 0x17DFB5, 0x6CF6D7, 0x6C4488, 0x4A411C, 0x5B9C81, 0x4E0F56, 0x286B70, 0x6E0D5E, 0x650AA4, 0x607889, 0x5CA6CB, 0x302566, 0x48ED51, 0x1B1BBC, 0x532B6E, 0x34825E, 0x157D1, 0x6D311A, 0x3F3644, 0x3F8506, 0x38279, 0x12],
        CURVE_Pya: [0x5E67A1, 0x6255B, 0x178920, 0xAF7DC, 0x217AD6, 0x778B9B, 0xA022D, 0x11892A, 0x3E8EDD, 0x7BD82A, 0x5B3462, 0x34CEA5, 0x65C158, 0x1BA07D, 0x5982BF, 0x42D8EF, 0x4F2770, 0x19746E, 0x3BD6AC, 0x3DC149, 0x4C827C, 0x603D90, 0x1B],
        CURVE_Pyb: [0x4F8E8B, 0x630D90, 0x5A162D, 0x25FBB0, 0x5C222, 0x11BFE, 0x7B89E7, 0x18856B, 0x714A4, 0x7C5CA, 0xA25FF, 0xCA0ED, 0x3D0496, 0x61936C, 0x46219E, 0xA1C60, 0x591F02, 0x62BEEB, 0xD9030, 0x3C18D6, 0x48B04E, 0x34779D, 0x14],
        CURVE_W: [
            [0x34583, 0x712E93, 0x4FC443, 0x68B50B, 0x5FB911, 0x47FD2C, 0x7FFF3D, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x37B01F, 0x1AED78, 0x8598, 0xB0F7F, 0x5EB806, 0x1A20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_SB: [
            [
                [0x4B9564, 0x56411A, 0x4F3EAB, 0x5DA58C, 0x1010B, 0x47E30C, 0x7FFF3D, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x6259CE, 0x79D12A, 0x4F9500, 0x1CBD96, 0x245BDA, 0x344F21, 0x2AC99E, 0x4632EF, 0x18B8E4, 0x3D597D, 0x451B3C, 0x77A22, 0x3C111B, 0x78177C, 0x32D4C1, 0x5D0EC, 0x7F01C6, 0x7FF3D8, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x3F]
            ],
            [
                [0x37B01F, 0x1AED78, 0x8598, 0xB0F7F, 0x5EB806, 0x1A20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x34583, 0x712E93, 0x4FC443, 0x68B50B, 0x5FB911, 0x47FD2C, 0x7FFF3D, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ]
        ],
        CURVE_WB: [
            [0x5A29F0, 0x66D56A, 0x305B6A, 0x2C1E98, 0x442C60, 0x42BF7F, 0x555514, 0x2AAAAA, 0x555555, 0x2AAAAA, 0x555555, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x355D4B, 0x25744, 0x45FBAC, 0x6BFC27, 0x20FC1F, 0x6BCB9E, 0x2778AE, 0x2C497D, 0x5AD40F, 0x72C0C9, 0x4549D2, 0x29A8B1, 0x576BC3, 0x42CC1, 0x587BF8, 0x75C030, 0xD105, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x289AAD, 0x7E700, 0x431F3C, 0x38C1F3, 0x282C11, 0x35EC57, 0x53BC57, 0x5624BE, 0x6D6A07, 0x396064, 0x62A4E9, 0x54D458, 0x6BB5E1, 0x21660, 0x2C3DFC, 0x7AE018, 0x6882, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x2279D1, 0x4BE7F2, 0x2FD5D2, 0x210F19, 0x65745A, 0x42A55E, 0x555514, 0x2AAAAA, 0x555555, 0x2AAAAA, 0x555555, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_BB: [
            [
                [0x1BD810, 0xD76BC, 0x4042CC, 0x587BF, 0x2F5C03, 0xD10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x1BD80F, 0xD76BC, 0x4042CC, 0x587BF, 0x2F5C03, 0xD10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x1BD80F, 0xD76BC, 0x4042CC, 0x587BF, 0x2F5C03, 0xD10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x6259CF, 0x79D12A, 0x4F9500, 0x1CBD96, 0x245BDA, 0x344F21, 0x2AC99E, 0x4632EF, 0x18B8E4, 0x3D597D, 0x451B3C, 0x77A22, 0x3C111B, 0x78177C, 0x32D4C1, 0x5D0EC, 0x7F01C6, 0x7FF3D8, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x3F]
            ],
            [
                [0x37B01F, 0x1AED78, 0x8598, 0xB0F7F, 0x5EB806, 0x1A20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x7E31DE, 0x747E6, 0xFD7CD, 0x224556, 0x53B7DD, 0x345C31, 0x2AC99E, 0x4632EF, 0x18B8E4, 0x3D597D, 0x451B3C, 0x77A22, 0x3C111B, 0x78177C, 0x32D4C1, 0x5D0EC, 0x7F01C6, 0x7FF3D8, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x3F],
                [0x7E31DD, 0x747E6, 0xFD7CD, 0x224556, 0x53B7DD, 0x345C31, 0x2AC99E, 0x4632EF, 0x18B8E4, 0x3D597D, 0x451B3C, 0x77A22, 0x3C111B, 0x78177C, 0x32D4C1, 0x5D0EC, 0x7F01C6, 0x7FF3D8, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x3F],
                [0x7E31DE, 0x747E6, 0xFD7CD, 0x224556, 0x53B7DD, 0x345C31, 0x2AC99E, 0x4632EF, 0x18B8E4, 0x3D597D, 0x451B3C, 0x77A22, 0x3C111B, 0x78177C, 0x32D4C1, 0x5D0EC, 0x7F01C6, 0x7FF3D8, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x3F]
            ],
            [
                [0x37B01E, 0x1AED78, 0x8598, 0xB0F7F, 0x5EB806, 0x1A20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x37B01F, 0x1AED78, 0x8598, 0xB0F7F, 0x5EB806, 0x1A20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x37B01F, 0x1AED78, 0x8598, 0xB0F7F, 0x5EB806, 0x1A20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x37B01F, 0x1AED78, 0x8598, 0xB0F7F, 0x5EB806, 0x1A20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x7E31DF, 0x0747E6, 0x0FD7CD, 0x224556, 0x53B7DD, 0x345C31, 0x2AC99E, 0x4632EF, 0x18B8E4, 0x3D597D, 0x451B3C, 0x77A22, 0x3C111B, 0x78177C, 0x32D4C1, 0x5D0EC, 0x7F01C6, 0x7FF3D8, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x3F],
                [0x2AA9AF, 0x5EE3B2, 0x4F0F68, 0x11AE17, 0x45A3D4, 0x343500, 0x2AC99E, 0x4632EF, 0x18B8E4, 0x3D597D, 0x451B3C, 0x77A22, 0x3C111B, 0x78177C, 0x32D4C1, 0x5D0EC, 0x7F01C6, 0x7FF3D8, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x3F],
                [0x37B01D, 0x1AED78, 0x008598, 0x0B0F7F, 0x5EB806, 0x001A20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x7E31DF, 0x0747E6, 0x0FD7CD, 0x224556, 0x53B7DD, 0x345C31, 0x2AC99E, 0x4632EF, 0x18B8E4, 0x3D597D, 0x451B3C, 0x77A22, 0x3C111B, 0x78177C, 0x32D4C1, 0x5D0EC, 0x7F01C6, 0x7FF3D8, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x3F]
            ]
        ],

        USE_GLV: true,
        USE_GS_G2: true,
        USE_GS_GT: true,
        GT_STRONG: false,

        //debug: false,

    };

    return ROM_CURVE_FP512BN;
};

ROM_CURVE_BN254 = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_BN254 = {

        // BN254 Curve

        // Base Bits= 24

        Curve_Cof_I : 1,
        CURVE_A: 0,
        CURVE_B_I: 2,
        CURVE_B: [0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0xD, 0x0, 0x10A100, 0x0, 0x9F8000, 0x7FF, 0x800000, 0xBA344D, 0x1, 0x648240, 0x2523],
        CURVE_Gx: [0x12, 0x0, 0x13A700, 0x0, 0x210000, 0x861, 0x800000, 0xBA344D, 0x1, 0x648240, 0x2523],
        CURVE_Gy: [0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],

        CURVE_Bnx: [0x1, 0x0, 0x4080, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cof: [0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cru: [0x7, 0x0, 0x6CD80, 0x0, 0x90000, 0x249, 0x400000, 0x49B362, 0x0, 0x0, 0x0],
        CURVE_Pxa: [0x3FB2B, 0x4224C8, 0xD91EE, 0x4898BF, 0x648BBB, 0xEDB6A4, 0x7E8C61, 0xEB8D8C, 0x9EB62F, 0x10BB51, 0x61A],
        CURVE_Pxb: [0xD54CF3, 0x34C1E7, 0xB70D8C, 0xAE3784, 0x4D746B, 0xAA5B1F, 0x8C5982, 0x310AA7, 0x737833, 0xAAF9BA, 0x516],
        CURVE_Pya: [0xCD2B9A, 0xE07891, 0xBD19F0, 0xBDBE09, 0xBD0AE6, 0x822329, 0x96698C, 0x9A90E0, 0xAF9343, 0x97A06B, 0x218],
        CURVE_Pyb: [0x3ACE9B, 0x1AEC6B, 0x578A2D, 0xD739C9, 0x9006FF, 0x8D37B0, 0x56F5F3, 0x8F6D44, 0x8B1526, 0x2B0E7C, 0xEBB],
        CURVE_W: [
            [0x3, 0x0, 0x20400, 0x0, 0x818000, 0x61, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x1, 0x0, 0x8100, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_SB: [
            [
                [0x4, 0x0, 0x28500, 0x0, 0x818000, 0x61, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x1, 0x0, 0x8100, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x1, 0x0, 0x8100, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0xA, 0x0, 0xE9D00, 0x0, 0x1E0000, 0x79E, 0x800000, 0xBA344D, 0x1, 0x648240, 0x2523]
            ]
        ],
        CURVE_WB: [
            [0x0, 0x0, 0x4080, 0x0, 0x808000, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x5, 0x0, 0x54A80, 0x0, 0x70000, 0x1C7, 0x800000, 0x312241, 0x0, 0x0, 0x0],
            [0x3, 0x0, 0x2C580, 0x0, 0x838000, 0xE3, 0xC00000, 0x189120, 0x0, 0x0, 0x0],
            [0x1, 0x0, 0xC180, 0x0, 0x808000, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_BB: [
            [
                [0xD, 0x0, 0x106080, 0x0, 0x9F8000, 0x7FF, 0x800000, 0xBA344D, 0x1, 0x648240, 0x2523],
                [0xC, 0x0, 0x106080, 0x0, 0x9F8000, 0x7FF, 0x800000, 0xBA344D, 0x1, 0x648240, 0x2523],
                [0xC, 0x0, 0x106080, 0x0, 0x9F8000, 0x7FF, 0x800000, 0xBA344D, 0x1, 0x648240, 0x2523],
                [0x2, 0x0, 0x8100, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x1, 0x0, 0x8100, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0xC, 0x0, 0x106080, 0x0, 0x9F8000, 0x7FF, 0x800000, 0xBA344D, 0x1, 0x648240, 0x2523],
                [0xD, 0x0, 0x106080, 0x0, 0x9F8000, 0x7FF, 0x800000, 0xBA344D, 0x1, 0x648240, 0x2523],
                [0xC, 0x0, 0x106080, 0x0, 0x9F8000, 0x7FF, 0x800000, 0xBA344D, 0x1, 0x648240, 0x2523]
            ],
            [
                [0x2, 0x0, 0x8100, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x1, 0x0, 0x8100, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x1, 0x0, 0x8100, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x1, 0x0, 0x8100, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x2, 0x0, 0x4080, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x2, 0x0, 0x10200, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0xA, 0x0, 0x102000, 0x0, 0x9F8000, 0x7FF, 0x800000, 0xBA344D, 0x1, 0x648240, 0x2523],
                [0x2, 0x0, 0x4080, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ]
        ],

        USE_GLV: true,
        USE_GS_G2: true,
        USE_GS_GT: true,
        GT_STRONG: false,

        //debug: false,
    };

    return ROM_CURVE_BN254;
};

ROM_CURVE_BN254CX = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_BN254CX = {

        // BN254CX Curve
        // Base Bits= 24

        Curve_Cof_I : 1,
        CURVE_A: 0,
        CURVE_B_I: 2,
        CURVE_B: [0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0xEB1F6D, 0xC0A636, 0xCEBE11, 0xCC906, 0x3FD6EE, 0x66D2C4, 0x647A63, 0xB0BDDF, 0x702A0D, 0x8, 0x2400],
        CURVE_Gx: [0x1B55B2, 0x23EF5C, 0xE1BE66, 0x18093E, 0x3FD6EE, 0x66D324, 0x647A63, 0xB0BDDF, 0x702A0D, 0x8, 0x2400],
        CURVE_Gy: [0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],

        CURVE_Bnx: [0xC012B1, 0x3, 0x4000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cof: [0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Cru: [0x235C97, 0x931794, 0x5631E0, 0x71EF87, 0xBDDF64, 0x3F1440, 0xCA8, 0x480000, 0x0, 0x0, 0x0],

        CURVE_Pxa: [0xD2EC74,0x1CEEE4,0x26C085,0xA03E27,0x7C85BF,0x4BBB90,0xF5C3,0x358B25,0x53B256,0x2D2C70,0x1968],
        CURVE_Pxb: [0x29CFE1,0x8E8B2E,0xF47A5,0xC209C3,0x1B97B0,0x9743F8,0x37A8E9,0xA011C9,0x19F64A,0xB9EC3E,0x1466],
        CURVE_Pya: [0xBE09F,0xFCEBCF,0xB30CFB,0x847EC1,0x61B33D,0xE20963,0x157DAE,0xD81E22,0x332B8D,0xEDD972,0xA79],
        CURVE_Pyb: [0x98EE9D,0x4B2288,0xEBED90,0x69D2ED,0x864EA5,0x3461C2,0x512D8D,0x35C6E4,0xC4C090,0xC39EC,0x616],


        CURVE_W: [
            [0x2FEB83, 0x634916, 0x120054, 0xB4038, 0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x802561, 0x7, 0x8000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_SB: [
            [
                [0xB010E4, 0x63491D, 0x128054, 0xB4038, 0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x802561, 0x7, 0x8000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x802561, 0x7, 0x8000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0xBB33EA, 0x5D5D20, 0xBCBDBD, 0x188CE, 0x3FD6EE, 0x66D264, 0x647A63, 0xB0BDDF, 0x702A0D, 0x8, 0x2400]
            ]
        ],
        CURVE_WB: [
            [0x7A84B0, 0x211856, 0xB0401C, 0x3C012, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0],
            [0x220475, 0xF995BE, 0x9A36CD, 0xA8CA7F, 0x7E94ED, 0x2A0DC0, 0x870, 0x300000, 0x0, 0x0, 0x0],
            [0xF10B93, 0xFCCAE0, 0xCD3B66, 0xD4653F, 0x3F4A76, 0x1506E0, 0x438, 0x180000, 0x0, 0x0, 0x0],
            [0xFAAA11, 0x21185D, 0xB0C01C, 0x3C012, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0]
        ],
        CURVE_BB: [
            [
                [0x2B0CBD, 0xC0A633, 0xCE7E11, 0xCC906, 0x3FD6EE, 0x66D2C4, 0x647A63, 0xB0BDDF, 0x702A0D, 0x8, 0x2400],
                [0x2B0CBC, 0xC0A633, 0xCE7E11, 0xCC906, 0x3FD6EE, 0x66D2C4, 0x647A63, 0xB0BDDF, 0x702A0D, 0x8, 0x2400],
                [0x2B0CBC, 0xC0A633, 0xCE7E11, 0xCC906, 0x3FD6EE, 0x66D2C4, 0x647A63, 0xB0BDDF, 0x702A0D, 0x8, 0x2400],
                [0x802562, 0x7, 0x8000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0x802561, 0x7, 0x8000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x2B0CBC, 0xC0A633, 0xCE7E11, 0xCC906, 0x3FD6EE, 0x66D2C4, 0x647A63, 0xB0BDDF, 0x702A0D, 0x8, 0x2400],
                [0x2B0CBD, 0xC0A633, 0xCE7E11, 0xCC906, 0x3FD6EE, 0x66D2C4, 0x647A63, 0xB0BDDF, 0x702A0D, 0x8, 0x2400],
                [0x2B0CBC, 0xC0A633, 0xCE7E11, 0xCC906, 0x3FD6EE, 0x66D2C4, 0x647A63, 0xB0BDDF, 0x702A0D, 0x8, 0x2400]
            ],
            [
                [0x802562, 0x7, 0x8000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x802561, 0x7, 0x8000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x802561, 0x7, 0x8000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x802561, 0x7, 0x8000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ],
            [
                [0xC012B2, 0x3, 0x4000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x4AC2, 0xF, 0x10000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
                [0x6AFA0A, 0xC0A62F, 0xCE3E11, 0xCC906, 0x3FD6EE, 0x66D2C4, 0x647A63, 0xB0BDDF, 0x702A0D, 0x8, 0x2400],
                [0xC012B2, 0x3, 0x4000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]
            ]
        ],

        USE_GLV: true,
        USE_GS_G2: true,
        USE_GS_GT: true,
        GT_STRONG: false,

        //debug: false,

    };

    return ROM_CURVE_BN254CX;
};

ROM_CURVE_BRAINPOOL = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    /* Note that the original curve has been transformed to an isomorphic curve with A=-3 */


    var ROM_CURVE_BRAINPOOL = {

        // Brainpool curve
        // Base Bits= 24

        Curve_Cof_I : 1,
        CURVE_A: -3,
        CURVE_B_I: 0,
        CURVE_B: [0xE92B04, 0x8101FE, 0x256AE5, 0xAF2F49, 0x93EBC4, 0x76B7BF, 0x733D0B, 0xFE66A7, 0xD84EA4, 0x61C430, 0x662C],
        CURVE_Order: [0x4856A7, 0xE8297, 0xF7901E, 0xB561A6, 0x397AA3, 0x8D718C, 0x909D83, 0x3E660A, 0xEEA9BC, 0x57DBA1, 0xA9FB],
        CURVE_Gx: [0x1305F4, 0x91562E, 0x2B79A1, 0x7AAFBC, 0xA142C4, 0x6149AF, 0xB23A65, 0x732213, 0xCFE7B7, 0xEB3CC1, 0xA3E8],
        CURVE_Gy: [0x25C9BE, 0xE8F35B, 0x1DAB, 0x39D027, 0xBCB6DE, 0x417E69, 0xE14644, 0x7F7B22, 0x39C56D, 0x6C8234, 0x2D99],
    };
    return ROM_CURVE_BRAINPOOL;
};

ROM_CURVE_C25519 = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_C25519 = {

        // C25519 Curve

        Curve_Cof_I : 8,
        CURVE_A: 486662,
        CURVE_B_I: 0,
        CURVE_B: [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0xF5D3ED, 0x631A5C, 0xD65812, 0xA2F79C, 0xDEF9DE, 0x14, 0x0, 0x0, 0x0, 0x0, 0x1000],
        CURVE_Gx: [0x9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Gy: [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
    };
    return ROM_CURVE_C25519;
};

ROM_CURVE_C41417 = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_C41417 = {

        // C41417 curve
        Curve_Cof_I : 8,
        CURVE_A: 1,
        CURVE_B_I: 3617,
        CURVE_B: [0xE21, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0x6AF79, 0x69784, 0x1B0E7, 0x18F3C6, 0x338AD, 0xDBC70, 0x6022B, 0x533DC, 0x3CC924, 0x3FFFAC, 0x3FFFFF, 0x3FFFFF, 0x3FFFFF, 0x3FFFFF, 0x3FFFFF, 0x3FFFFF, 0x3FFFFF, 0x3FFFFF, 0x7FFF],
        CURVE_Gx: [0xBC595, 0x204BCF, 0xC4FD3, 0x14DF19, 0x33FAA8, 0x4C069, 0x16BA11, 0x2AD35B, 0x1498A4, 0x15FFCD, 0x3EC7F, 0x27D130, 0xD4636, 0x9B97F, 0x631C3, 0x8630, 0x144330, 0x241450, 0x1A334],
        CURVE_Gy: [0x22, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],

    };

    return ROM_CURVE_C41417;
};

ROM_CURVE_ED25519 = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_ED25519 = {

        // ED25519 Curve

        Curve_Cof_I : 8,
        CURVE_A: -1,
        CURVE_B_I: 0,
        CURVE_B: [0x5978A3, 0x4DCA13, 0xAB75EB, 0x4141D8, 0x700A4D, 0xE89800, 0x797779, 0x8CC740, 0x6FFE73, 0x6CEE2B, 0x5203],
        CURVE_Order: [0xF5D3ED, 0x631A5C, 0xD65812, 0xA2F79C, 0xDEF9DE, 0x14, 0x0, 0x0, 0x0, 0x0, 0x1000],
        CURVE_Gx: [0x25D51A, 0x2D608F, 0xB2C956, 0x9525A7, 0x2CC760, 0xDC5C69, 0x31FDD6, 0xC0A4E2, 0x6E53FE, 0x36D3CD, 0x2169],
        CURVE_Gy: [0x666658, 0x666666, 0x666666, 0x666666, 0x666666, 0x666666, 0x666666, 0x666666, 0x666666, 0x666666, 0x6666],


    };
    return ROM_CURVE_ED25519;
};

ROM_CURVE_GOLDILOCKS = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_GOLDILOCKS = {

        // GOLDILOCKS curve
        Curve_Cof_I : 4,
        CURVE_A: 1,
        CURVE_B_I: -39081,
        CURVE_B: [0x7F6756, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7DFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FF],
        CURVE_Order: [0x5844F3, 0x52556, 0x548DE3, 0x6E2C7A, 0x4C2728, 0x52042D, 0x6BB58D, 0x276DA4, 0x23E9C4, 0x7EF994, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x1FF],
        CURVE_Gx: [0x555555, 0x2AAAAA, 0x555555, 0x2AAAAA, 0x555555, 0x2AAAAA, 0x555555, 0x2AAAAA, 0x555555, 0x52AAAA, 0x2AAAAA, 0x555555, 0x2AAAAA, 0x555555, 0x2AAAAA, 0x555555, 0x2AAAAA, 0x555555, 0x2AAAAA, 0x555],
        CURVE_Gy: [0x1386ED, 0x779BD5, 0x2F6BAB, 0xE6D03, 0x4B2BED, 0x131777, 0x4E8A8C, 0x32B2C1, 0x44B80D, 0x6515B1, 0x5F8DB5, 0x426EBD, 0x7A0358, 0x6DDA, 0x21B0AC, 0x6B1028, 0xDB359, 0x15AE09, 0x17A58D, 0x570],
    };
    return ROM_CURVE_GOLDILOCKS;
};

ROM_CURVE_HIFIVE = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_HIFIVE = {

        // HIFIVE curve

        Curve_Cof_I : 8,
        CURVE_A: 1,
        CURVE_B_I: 11111,
        CURVE_B: [0x2B67, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0x1FA805, 0x2B2E7D, 0x29ECBE, 0x3FC9DD, 0xBD6B8, 0x530A18, 0x45057E, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800],
        CURVE_Gx: [0xC, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Gy: [0x7E8632, 0xD0A0B, 0x6C4AFB, 0x501B2E, 0x55650C, 0x36DB6B, 0x1FBD0D, 0x61C08E, 0x314B46, 0x70A7A3, 0x587401, 0xC70E0, 0x56502E, 0x38C2D6, 0x303],

    };
    return ROM_CURVE_HIFIVE;
};

ROM_CURVE_NIST256 = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_NIST256 = {

        // NIST256 Curve
        Curve_Cof_I : 1,
        CURVE_A: -3,
        CURVE_B_I: 0,
        CURVE_B: [0xD2604B, 0x3C3E27, 0xF63BCE, 0xCC53B0, 0x1D06B0, 0x86BC65, 0x557698, 0xB3EBBD, 0x3A93E7, 0x35D8AA, 0x5AC6],
        CURVE_Order: [0x632551, 0xCAC2FC, 0x84F3B9, 0xA7179E, 0xE6FAAD, 0xFFFFBC, 0xFFFFFF, 0xFFFFFF, 0x0, 0xFFFF00, 0xFFFF],
        CURVE_Gx: [0x98C296, 0x3945D8, 0xA0F4A1, 0x2DEB33, 0x37D81, 0x40F277, 0xE563A4, 0xF8BCE6, 0x2C4247, 0xD1F2E1, 0x6B17],
        CURVE_Gy: [0xBF51F5, 0x406837, 0xCECBB6, 0x6B315E, 0xCE3357, 0x9E162B, 0x4A7C0F, 0x8EE7EB, 0x1A7F9B, 0x42E2FE, 0x4FE3],

    };
    return ROM_CURVE_NIST256;
};

ROM_CURVE_NIST384 = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_NIST384 = {

        // NIST384 curve
        Curve_Cof_I : 1,
        CURVE_A: -3,
        CURVE_B_I: 0,
        CURVE_B: [0x6C2AEF, 0x11DBA7, 0x74AA17, 0x51768C, 0x6398D8, 0x6B58CA, 0x5404E1, 0xA0447, 0x411203, 0x5DFD02, 0x607671, 0x4168C8, 0x56BE3F, 0x1311C0, 0xFB9F9, 0x17D3F1, 0xB331],
        CURVE_Order: [0x452973, 0x32D599, 0x6BB3B0, 0x45853B, 0x20DB24, 0x3BEB03, 0x7D0DCB, 0x31A6C0, 0x7FFFC7, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0xFFFF],
        CURVE_Gx: [0x760AB7, 0x3C70E4, 0x30E951, 0x7AA94B, 0x2F25DB, 0x470AA0, 0x20950A, 0x7BA0F0, 0x1B9859, 0x45174F, 0x3874ED, 0x56BA3, 0x71EF32, 0x71D638, 0x22C14D, 0x65115F, 0xAA87],
        CURVE_Gy: [0x6A0E5F, 0x3AF921, 0x75E90C, 0x6BF40C, 0xB1CE1, 0x18014C, 0x6D7C2E, 0x6D1889, 0x147CE9, 0x7A5134, 0x63D076, 0x16E14F, 0xBF929, 0x6BB3D3, 0x98B1B, 0x6F254B, 0x3617],
    };
    return ROM_CURVE_NIST384;
};

ROM_CURVE_NIST521 = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_NIST521 = {

        // NIST521 curve

        Curve_Cof_I : 1,
        CURVE_A: -3,
        CURVE_B_I: 0,
        CURVE_B: [0x503F00, 0x3FA8D6, 0x47BD14, 0x6961A7, 0x3DF883, 0x60E6AE, 0x4EEC6F, 0x29605E, 0x137B16, 0x23D8FD, 0x5864E5, 0x84F0A, 0x1918EF, 0x771691, 0x6CC57C, 0x392DCC, 0x6EA2DA, 0x6D0A81, 0x688682, 0x50FC94, 0x18E1C9, 0x27D72C, 0x1465],
        CURVE_Order: [0x386409, 0x6E3D22, 0x3AEDBE, 0x4CE23D, 0x5C9B88, 0x3A0776, 0x3DC269, 0x6600A4, 0x166B7F, 0x77E5F, 0x461A1E, 0x7FFFD2, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFF],
        CURVE_Gx: [0x65BD66, 0x7C6385, 0x6FE5F9, 0x2B5214, 0xB3C18, 0x1BC669, 0x68BFEA, 0xEE093, 0x5928FE, 0x6FDFCE, 0x52D79, 0x69EDD5, 0x7606B4, 0x3F0515, 0x4FED48, 0x409C82, 0x429C64, 0x472B68, 0x7B2D98, 0x4E6CF1, 0x70404E, 0x31C0D6, 0x31A1],
        CURVE_Gy: [0x516650, 0x28ED3F, 0x222FA, 0x139612, 0x47086A, 0x6C26A7, 0x4FEB41, 0x285C80, 0x2640C5, 0x32BDE8, 0x5FB9CA, 0x733164, 0x517273, 0x2F5F7, 0x66D11A, 0x2224AB, 0x5998F5, 0x58FA37, 0x297ED0, 0x22E4, 0x9A3BC, 0x252D4F, 0x460E],
    };
    return ROM_CURVE_NIST521;
};

ROM_CURVE_NUMS256E = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_NUMS256E = {

        // NUMS256E Curve
        Curve_Cof_I : 4,
        CURVE_A: 1,
        CURVE_B_I: -15342,
        CURVE_B: [0xFFC355, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFF],
        CURVE_Order: [0xDD4AF5, 0xB190EE, 0x9B1A47, 0x2F5943, 0x955AA5, 0x41, 0x0, 0x0, 0x0, 0x0, 0x4000],
        CURVE_Gx: [0xED13DA, 0xC0902E, 0x86A0DE, 0xE30835, 0x398A0E, 0x9BD60C, 0x5F6920, 0xCD1E3D, 0xEA237D, 0x14FB6A, 0x8A75],
        CURVE_Gy: [0x8A89E6, 0x16E779, 0xD32FA6, 0x10856E, 0x5F61D8, 0x801071, 0xD9A64B, 0xCE9665, 0xD925C7, 0x3E9FD9, 0x44D5],


    };
    return ROM_CURVE_NUMS256E;
};

ROM_CURVE_NUMS256W = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_NUMS256W = {

        // NUMS256W Curve
        Curve_Cof_I : 1,
        CURVE_A: -3,
        CURVE_B_I: 152961,
        CURVE_B: [0x25581, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0x51A825, 0x202947, 0x6020AB, 0xEA265C, 0x3C8275, 0xFFFFE4, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFF],
        CURVE_Gx: [0x1AACB1, 0xEE1EB2, 0x3ABC52, 0x3D4C7, 0x579B09, 0xCB0983, 0xA04F42, 0x297A95, 0xAADB61, 0xD6B65A, 0xBC9E],
        CURVE_Gy: [0x84DE9F, 0xB9CB21, 0xBB80B5, 0x15310F, 0x55C3D1, 0xE035C9, 0xF77E04, 0x73448B, 0x99B6A6, 0xC0F133, 0xD08F],


    };
    return ROM_CURVE_NUMS256W;
};

ROM_CURVE_NUMS384E = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_NUMS384E = {

        // NUMS384E Curve
        Curve_Cof_I : 4,
        CURVE_A: 1,
        CURVE_B_I: -11556,
        CURVE_B: [0x7FD19F, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0xFFFF],
        CURVE_Order: [0x23897D, 0x3989CD, 0x6482E7, 0x59AE43, 0x4555AA, 0x39EC3C, 0x2D1AF8, 0x238D0E, 0x7FFFE2, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x3FFF],
        CURVE_Gx: [0x206BDE, 0x1C8D8, 0x4D4355, 0x2A2CA0, 0x292B16, 0x680DFE, 0x3CCC58, 0x31FFD4, 0x4C0057, 0xDCB7C, 0x4C2FD1, 0x2AEDAD, 0x2129AE, 0x1816D4, 0x6A499B, 0x8FDA2, 0x61B1],
        CURVE_Gy: [0x729392, 0x7C3E0, 0x727634, 0x376246, 0x2B0F94, 0x49600E, 0x7D9165, 0x7CC7B, 0x5F5683, 0x69E284, 0x5AB609, 0x86EB8, 0x1A423B, 0x10E716, 0x69BBAC, 0x1F33DC, 0x8298],

    };
    return ROM_CURVE_NUMS384E;
};

ROM_CURVE_NUMS384W = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_NUMS384W = {

        // NUMS384W Curve
        Curve_Cof_I : 1,
        CURVE_A: -3,
        CURVE_B_I: -34568,
        CURVE_B: [0x7F77BB, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0xFFFF],
        CURVE_Order: [0xE61B9, 0x3ECF6, 0x698136, 0x61BF13, 0x29D3D4, 0x1037DB, 0x3AD75A, 0xF578F, 0x7FFFD6, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0xFFFF],
        CURVE_Gx: [0x18152A, 0x740841, 0x6FAE72, 0x7B0E23, 0x6ED100, 0x684A45, 0x4A9B31, 0x5E948D, 0x79F4F3, 0x1BF703, 0x89707, 0x2F8D30, 0x222410, 0x91019, 0x5BC607, 0x2B7858, 0x7579],
        CURVE_Gy: [0x180716, 0x71D8CC, 0x1971D2, 0x7FA569, 0x6B4DBB, 0x6FD79A, 0x4486A0, 0x1041BE, 0x739CB9, 0x6FF0FE, 0x4011A5, 0x267BF5, 0x530058, 0x1AFC67, 0x66E38E, 0x71B470, 0xACDE],


    };
    return ROM_CURVE_NUMS384W;
};

ROM_CURVE_NUMS512E = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_NUMS512E = {

        // NUMS512E Curve
        Curve_Cof_I : 4,
        CURVE_A: 1,
        CURVE_B_I: -78296,
        CURVE_B: [0x7ECBEF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x3F],
        CURVE_Order: [0x6ED46D, 0x19EA37, 0x7D9D1A, 0x6F7F67, 0x605786, 0x5EA548, 0x5C2DA1, 0x1FEC64, 0x11BA9E, 0x5A5F9F, 0x53C18D, 0x7FFFFD, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0xF],
        CURVE_Gx: [0x6C57FE, 0x565333, 0x5716E6, 0x662780, 0x525427, 0x15A1FC, 0x15A241, 0x5EE4C9, 0x730F78, 0x1DDC8C, 0x188705, 0x5C0A3A, 0x6BE273, 0x44F42F, 0x7128E0, 0x73CFA6, 0x332FD1, 0x11A78A, 0x632DE2, 0x34E3D0, 0x5128DB, 0x71C62D, 0x37],
        CURVE_Gy: [0x62F5E1, 0x3D8183, 0x7CC9B7, 0x5F8E80, 0x6D38A9, 0x3FA04C, 0xABB30, 0xD0343, 0x356260, 0x65D32C, 0x3294F, 0x741A09, 0x395909, 0x55256D, 0x96748, 0x7B936C, 0x6EE476, 0x50544A, 0x43D5DE, 0x538CC5, 0x39D49C, 0x2137FE, 0x1B],

    };
    return ROM_CURVE_NUMS512E;
};

ROM_CURVE_NUMS512W = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_NUMS512W = {

        // NUMS512W Curve
        Curve_Cof_I : 1,
        CURVE_A: -3,
        CURVE_B_I: 121243,
        CURVE_B: [0x1D99B, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0x33555D, 0x7E7208, 0xF3854, 0x3E692, 0x68B366, 0x38C76A, 0x65F42F, 0x612C76, 0x31B4F, 0x7729CF, 0x6CF293, 0x7FFFFA, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x7FFFFF, 0x3F],
        CURVE_Gx: [0x2BAE57, 0xF2B19, 0xB720A, 0x6B7AEF, 0x560137, 0x3063AB, 0x95585, 0x3CA143, 0x359E93, 0x220ED6, 0x408685, 0x36CFCA, 0xC2530, 0x28A0DC, 0x407DA1, 0x6C1DDA, 0x5298CA, 0x407A76, 0x2DC00A, 0x549ED1, 0x7141D0, 0x580688, 0xE],
        CURVE_Gy: [0x3527A6, 0xEC070, 0x248E82, 0x67E87F, 0x35C1E4, 0x4059E5, 0x2C9695, 0x10D420, 0x6DE9C1, 0x35161D, 0xA1057, 0xA78A5, 0x60C7BD, 0x11E964, 0x6F2EE3, 0x6DEF55, 0x4B97, 0x47D762, 0x3BBB71, 0x359E70, 0x229AD5, 0x74A99, 0x25],

    };
    return ROM_CURVE_NUMS512W;
};

ROM_CURVE_SECP256K1 = function() {
    /* Fixed Data in ROM - Field and Curve parameters */

    var ROM_CURVE_SECP256K1 = {

        // SECP256K1 Curve
        // Base Bits= 24

        CURVE_Cof_I: 1,
        CURVE_A: 0,
        CURVE_B_I: 7,
        CURVE_B: [0x7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
        CURVE_Order: [0x364141, 0x5E8CD0, 0x3BBFD2, 0xAF48A0, 0xAEDCE6, 0xFFFEBA, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFF],
        CURVE_Gx: [0xF81798, 0x815B16, 0xD959F2, 0x2DCE28, 0x9BFCDB, 0xB0702, 0x95CE87, 0x55A062, 0xDCBBAC, 0x667EF9, 0x79BE],
        CURVE_Gy: [0x10D4B8, 0xD08FFB, 0x199C47, 0xA68554, 0x17B448, 0x8A8FD, 0xFC0E11, 0x5DA4FB, 0xA3C465, 0xDA7726, 0x483A],

    };
    return ROM_CURVE_SECP256K1;
};

if (typeof module !== "undefined" && typeof module.exports !== "undefined") {
    module.exports = {
        ROM_CURVE_ANSSI: ROM_CURVE_ANSSI,
        ROM_CURVE_BLS383: ROM_CURVE_BLS383,
        ROM_CURVE_BLS24: ROM_CURVE_BLS24,
        ROM_CURVE_BLS48: ROM_CURVE_BLS48,
        ROM_CURVE_BLS381: ROM_CURVE_BLS381,
        ROM_CURVE_BLS461: ROM_CURVE_BLS461,
        ROM_CURVE_FP256BN: ROM_CURVE_FP256BN,
        ROM_CURVE_FP512BN: ROM_CURVE_FP512BN,
        ROM_CURVE_BN254: ROM_CURVE_BN254,
        ROM_CURVE_BN254CX: ROM_CURVE_BN254CX,
        ROM_CURVE_BRAINPOOL: ROM_CURVE_BRAINPOOL,
        ROM_CURVE_C25519: ROM_CURVE_C25519,
        ROM_CURVE_C41417: ROM_CURVE_C41417,
        ROM_CURVE_ED25519: ROM_CURVE_ED25519,
        ROM_CURVE_GOLDILOCKS: ROM_CURVE_GOLDILOCKS,
        ROM_CURVE_HIFIVE: ROM_CURVE_HIFIVE,
        ROM_CURVE_NIST256: ROM_CURVE_NIST256,
        ROM_CURVE_NIST384: ROM_CURVE_NIST384,
        ROM_CURVE_NIST521: ROM_CURVE_NIST521,
        ROM_CURVE_NUMS256E: ROM_CURVE_NUMS256E,
        ROM_CURVE_NUMS256W: ROM_CURVE_NUMS256W,
        ROM_CURVE_NUMS384E: ROM_CURVE_NUMS384E,
        ROM_CURVE_NUMS384W: ROM_CURVE_NUMS384W,
        ROM_CURVE_NUMS512E: ROM_CURVE_NUMS512E,
        ROM_CURVE_NUMS512W: ROM_CURVE_NUMS512W,
        ROM_CURVE_SECP256K1: ROM_CURVE_SECP256K1
    };
}
