<a name="FP48"></a>

## FP48
**Kind**: global class  
**this**: <code>{FP48}</code>  

* [FP48](#FP48)
    * [new FP48()](#new_FP48_new)
    * _instance_
        * [.reduce()](#FP48+reduce)
        * [.norm()](#FP48+norm)
        * [.iszilch()](#FP48+iszilch)
        * [.isunity()](#FP48+isunity)
        * [.cmove(g, d)](#FP48+cmove)
        * [.select()](#FP48+select)
        * [.geta()](#FP48+geta)
        * [.getb()](#FP48+getb)
        * [.getc()](#FP48+getc)
        * [.equals(x)](#FP48+equals)
        * [.copy(x)](#FP48+copy)
        * [.one(x)](#FP48+one)
        * [.zero()](#FP48+zero)
        * [.conj()](#FP48+conj)
        * [.set(d, e, f)](#FP48+set)
        * [.seta(c)](#FP48+seta)
        * [.usqr()](#FP48+usqr)
        * [.sqr()](#FP48+sqr)
        * [.mul(y)](#FP48+mul)
        * [.smul(y)](#FP48+smul)
        * [.ssmul(y)](#FP48+ssmul)
        * [.inverse()](#FP48+inverse)
        * [.frob(f)](#FP48+frob)
        * [.trace()](#FP48+trace)
        * [.toString()](#FP48+toString)
        * [.toBytes(w)](#FP48+toBytes)
        * [.pow(e)](#FP48+pow)
        * [.pinpow(e, bts)](#FP48+pinpow)
        * [.compow(e, r)](#FP48+compow)
    * _static_
        * [.fromBytes(w)](#FP48.fromBytes)
        * [.teq()](#FP48.teq)
        * [.pow16()](#FP48.pow16)

<a name="new_FP48_new"></a>

### new FP48()
Creates an instance of FP48.

<a name="FP48+reduce"></a>

### fP48.reduce()
Reduces all components of possibly unreduced FP48 mod Modulus

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+norm"></a>

### fP48.norm()
Normalises the components of an FP48

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+iszilch"></a>

### fP48.iszilch()
Tests for FP48 equal to zero

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+isunity"></a>

### fP48.isunity()
Tests for FP48 equal to unity

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+cmove"></a>

### fP48.cmove(g, d)
Conditional copy of FP48 number

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| g | FP48 instance |
| d | copy depends on this value |

<a name="FP48+select"></a>

### fP48.select()
Constant time select from pre-computed table

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+geta"></a>

### fP48.geta()
extract a from this

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+getb"></a>

### fP48.getb()
extract b from this

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+getc"></a>

### fP48.getc()
extract c from this

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+equals"></a>

### fP48.equals(x)
Tests for equality of two FP48s

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| x | FP48 instance to compare |

<a name="FP48+copy"></a>

### fP48.copy(x)
Copy FP48 to another FP48

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| x | FP48 instance to be copied |

<a name="FP48+one"></a>

### fP48.one(x)
Set FP48 to unity

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| x | FP48 instance to be set to one |

<a name="FP48+zero"></a>

### fP48.zero()
Set FP48 to zero

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+conj"></a>

### fP48.conj()
Conjugation of FP48

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+set"></a>

### fP48.set(d, e, f)
Set FP48 from three FP16 values

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| d | FP16 instance |
| e | FP16 instance |
| f | FP16 instance |

<a name="FP48+seta"></a>

### fP48.seta(c)
Set FP48 from one FP16 value

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| c | FP16 instance |

<a name="FP48+usqr"></a>

### fP48.usqr()
Fast Squaring of an FP48 in "unitary" form

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+sqr"></a>

### fP48.sqr()
Fast Squaring of an FP48

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+mul"></a>

### fP48.mul(y)
Full unconditional Multiplication of two FP48s

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| y | FP48 instance, the multiplier |

<a name="FP48+smul"></a>

### fP48.smul(y)
Fast multiplication of two sparse FP48s that arises from ATE pairing line functions

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| y | FP48 instance, the multiplier |

<a name="FP48+ssmul"></a>

### fP48.ssmul(y)
Fast multiplication of what may be sparse multiplicands

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| y | FP48 instance, the multiplier |

<a name="FP48+inverse"></a>

### fP48.inverse()
Inverting an FP48

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+frob"></a>

### fP48.frob(f)
Raises an FP48 to the power of the internal modulus p, using the Frobenius

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| f | Modulus |

<a name="FP48+trace"></a>

### fP48.trace()
Calculate the trace of an FP48

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+toString"></a>

### fP48.toString()
convert this to hex string

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48+toBytes"></a>

### fP48.toBytes(w)
convert this to byte array

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| w | Byte array |

<a name="FP48+pow"></a>

### fP48.pow(e)
Raises an FP48 to the power of a BIG

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| e | BIG instance exponent |

<a name="FP48+pinpow"></a>

### fP48.pinpow(e, bts)
Raises an FP48 instance x to a small integer power, side-channel resistant

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| e | small integer exponent |
| bts | maximum number of bits in exponent |

<a name="FP48+compow"></a>

### fP48.compow(e, r)
Raises an FP48 instance to a BIG power, compressed to FP4

**Kind**: instance method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| e | BIG exponent |
| r | BIG group order |

<a name="FP48.fromBytes"></a>

### FP48.fromBytes(w)
convert from byte array to FP48

**Kind**: static method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  

| Param | Description |
| --- | --- |
| w | Byte array |

<a name="FP48.teq"></a>

### FP48.teq()
return 1 if b==c, no branching

**Kind**: static method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
<a name="FP48.pow16"></a>

### FP48.pow16()
p=q0^u0.q1^u1.q2^u2.q3^u3...

**Kind**: static method of [<code>FP48</code>](#FP48)  
**this**: <code>{FP48}</code>  
