<a name="FP24"></a>

## FP24
**Kind**: global class  
**this**: <code>{FP24}</code>  

* [FP24](#FP24)
    * [new FP24()](#new_FP24_new)
    * _instance_
        * [.reduce()](#FP24+reduce)
        * [.norm()](#FP24+norm)
        * [.iszilch()](#FP24+iszilch)
        * [.isunity()](#FP24+isunity)
        * [.cmove(g, d)](#FP24+cmove)
        * [.select()](#FP24+select)
        * [.geta()](#FP24+geta)
        * [.getb()](#FP24+getb)
        * [.getc()](#FP24+getc)
        * [.equals(x)](#FP24+equals)
        * [.copy(x)](#FP24+copy)
        * [.one(x)](#FP24+one)
        * [.zero()](#FP24+zero)
        * [.conj()](#FP24+conj)
        * [.set(d, e, f)](#FP24+set)
        * [.seta(c)](#FP24+seta)
        * [.usqr()](#FP24+usqr)
        * [.sqr()](#FP24+sqr)
        * [.mul(y)](#FP24+mul)
        * [.smul(y)](#FP24+smul)
        * [.ssmul(y)](#FP24+ssmul)
        * [.inverse()](#FP24+inverse)
        * [.frob(f)](#FP24+frob)
        * [.trace()](#FP24+trace)
        * [.toString()](#FP24+toString)
        * [.toBytes(w)](#FP24+toBytes)
        * [.pow(e)](#FP24+pow)
        * [.pinpow(e, bts)](#FP24+pinpow)
        * [.compow(e, r)](#FP24+compow)
    * _static_
        * [.fromBytes(w)](#FP24.fromBytes)
        * [.teq()](#FP24.teq)
        * [.pow8()](#FP24.pow8)

<a name="new_FP24_new"></a>

### new FP24()
Creates an instance of FP24.

<a name="FP24+reduce"></a>

### fP24.reduce()
Reduces all components of possibly unreduced FP24 mod Modulus

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+norm"></a>

### fP24.norm()
Normalises the components of an FP24

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+iszilch"></a>

### fP24.iszilch()
Tests for FP24 equal to zero

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+isunity"></a>

### fP24.isunity()
Tests for FP24 equal to unity

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+cmove"></a>

### fP24.cmove(g, d)
Conditional copy of FP24 number

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| g | FP24 instance |
| d | copy depends on this value |

<a name="FP24+select"></a>

### fP24.select()
Constant time select from pre-computed table

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+geta"></a>

### fP24.geta()
extract a from this

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+getb"></a>

### fP24.getb()
extract b from this

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+getc"></a>

### fP24.getc()
extract c from this

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+equals"></a>

### fP24.equals(x)
Tests for equality of two FP24s

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| x | FP24 instance to compare |

<a name="FP24+copy"></a>

### fP24.copy(x)
Copy FP24 to another FP24

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| x | FP24 instance to be copied |

<a name="FP24+one"></a>

### fP24.one(x)
Set FP24 to unity

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| x | FP24 instance to be set to one |

<a name="FP24+zero"></a>

### fP24.zero()
Set FP24 to zero

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+conj"></a>

### fP24.conj()
Conjugation of FP24

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+set"></a>

### fP24.set(d, e, f)
Set FP24 from three FP8 values

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| d | FP8 instance |
| e | FP8 instance |
| f | FP8 instance |

<a name="FP24+seta"></a>

### fP24.seta(c)
Set FP24 from one FP8 value

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| c | FP8 instance |

<a name="FP24+usqr"></a>

### fP24.usqr()
Fast Squaring of an FP24 in "unitary" form

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+sqr"></a>

### fP24.sqr()
Fast Squaring of an FP24

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+mul"></a>

### fP24.mul(y)
Full unconditional Multiplication of two FP24s

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| y | FP24 instance, the multiplier |

<a name="FP24+smul"></a>

### fP24.smul(y)
Fast multiplication of two sparse FP24s that arises from ATE pairing line functions

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| y | FP24 instance, the multiplier |

<a name="FP24+ssmul"></a>

### fP24.ssmul(y)
Fast multiplication of what may be sparse multiplicands

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| y | FP24 instance, the multiplier |

<a name="FP24+inverse"></a>

### fP24.inverse()
Inverting an FP24

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+frob"></a>

### fP24.frob(f)
Raises an FP24 to the power of the internal modulus p, using the Frobenius

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| f | Modulus |

<a name="FP24+trace"></a>

### fP24.trace()
Calculate the trace of an FP24

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+toString"></a>

### fP24.toString()
convert this to hex string

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24+toBytes"></a>

### fP24.toBytes(w)
convert this to byte array

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| w | Byte array |

<a name="FP24+pow"></a>

### fP24.pow(e)
Raises an FP24 to the power of a BIG

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| e | BIG instance exponent |

<a name="FP24+pinpow"></a>

### fP24.pinpow(e, bts)
Raises an FP24 instance x to a small integer power, side-channel resistant

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| e | small integer exponent |
| bts | maximum number of bits in exponent |

<a name="FP24+compow"></a>

### fP24.compow(e, r)
Raises an FP24 instance to a BIG power, compressed to FP4

**Kind**: instance method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| e | BIG exponent |
| r | BIG group order |

<a name="FP24.fromBytes"></a>

### FP24.fromBytes(w)
convert from byte array to FP24

**Kind**: static method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  

| Param | Description |
| --- | --- |
| w | Byte array |

<a name="FP24.teq"></a>

### FP24.teq()
return 1 if b==c, no branching

**Kind**: static method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
<a name="FP24.pow8"></a>

### FP24.pow8()
p=q0^u0.q1^u1.q2^u2.q3^u3...

**Kind**: static method of [<code>FP24</code>](#FP24)  
**this**: <code>{FP24}</code>  
