<a name="FP16"></a>

## FP16
**Kind**: global class  
**this**: <code>{FP16}</code>  

* [FP16](#FP16)
    * [new FP16()](#new_FP16_new)
    * [.reduce()](#FP16+reduce)
    * [.norm()](#FP16+norm)
    * [.iszilch()](#FP16+iszilch)
    * [.isunity()](#FP16+isunity)
    * [.cmove(g, d)](#FP16+cmove)
    * [.isreal()](#FP16+isreal)
    * [.real()](#FP16+real)
    * [.geta()](#FP16+geta)
    * [.getb()](#FP16+getb)
    * [.equals(x)](#FP16+equals)
    * [.copy(x)](#FP16+copy)
    * [.zero()](#FP16+zero)
    * [.one(x)](#FP16+one)
    * [.set(c, d)](#FP16+set)
    * [.seta(c)](#FP16+seta)
    * [.neg()](#FP16+neg)
    * [.conj()](#FP16+conj)
    * [.nconj()](#FP16+nconj)
    * [.add(x)](#FP16+add)
    * [.sub(x)](#FP16+sub)
    * [.pmul(s)](#FP16+pmul)
    * [.qmul(s)](#FP16+qmul)
    * [.imul(s)](#FP16+imul)
    * [.sqr()](#FP16+sqr)
    * [.mul(y)](#FP16+mul)
    * [.toString()](#FP16+toString)
    * [.inverse()](#FP16+inverse)
    * [.times_i()](#FP16+times_i)
    * [.times_i2()](#FP16+times_i2)
    * [.times_i4()](#FP16+times_i4)
    * [.frob(f)](#FP16+frob)
    * [.pow(e)](#FP16+pow)
    * [.xtr_A(w, y, z)](#FP16+xtr_A)
    * [.xtr_D()](#FP16+xtr_D)
    * [.xtr_pow(n)](#FP16+xtr_pow)
    * [.xtr_pow2()](#FP16+xtr_pow2)

<a name="new_FP16_new"></a>

### new FP16()
Creates an instance of FP16.

<a name="FP16+reduce"></a>

### fP16.reduce()
Reduces all components of possibly unreduced FP16 mod Modulus

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+norm"></a>

### fP16.norm()
Normalises the components of an FP16

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+iszilch"></a>

### fP16.iszilch()
Tests for FP16 equal to zero

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+isunity"></a>

### fP16.isunity()
Tests for FP16 equal to unity

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+cmove"></a>

### fP16.cmove(g, d)
Conditional copy of FP16 number

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| g | FP16 instance |
| d | copy depends on this value |

<a name="FP16+isreal"></a>

### fP16.isreal()
test is w real? That is in a+ib test b is zero

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+real"></a>

### fP16.real()
extract real part a

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+geta"></a>

### fP16.geta()
extract a from this

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+getb"></a>

### fP16.getb()
extract b from this

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+equals"></a>

### fP16.equals(x)
Tests for equality of two FP16s

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| x | FP16 instance to compare |

<a name="FP16+copy"></a>

### fP16.copy(x)
Copy FP16 to another FP16

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| x | FP16 instance to be copied |

<a name="FP16+zero"></a>

### fP16.zero()
Set FP16 to zero

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+one"></a>

### fP16.one(x)
Set FP16 to unity

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| x | FP16 instance to be set to one |

<a name="FP16+set"></a>

### fP16.set(c, d)
Set FP16 from two FP8 values

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| c | FP8 instance |
| d | FP8 instance |

<a name="FP16+seta"></a>

### fP16.seta(c)
Set FP16 from one FP8 value

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| c | FP8 instance |

<a name="FP16+neg"></a>

### fP16.neg()
this=-this

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+conj"></a>

### fP16.conj()
Conjugation of FP16

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+nconj"></a>

### fP16.nconj()
Negative conjugation of FP16

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+add"></a>

### fP16.add(x)
addition of two FP16s

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| x | FP16 instance |

<a name="FP16+sub"></a>

### fP16.sub(x)
subtraction of two FP16s

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| x | FP16 instance |

<a name="FP16+pmul"></a>

### fP16.pmul(s)
Multiplication of an FP16 by an FP8

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| s | FP8 instance |

<a name="FP16+qmul"></a>

### fP16.qmul(s)
Multiplication of an FP16 by an FP2

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| s | FP2 instance |

<a name="FP16+imul"></a>

### fP16.imul(s)
Multiplication of an FP16 by a small integer

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| s | integer |

<a name="FP16+sqr"></a>

### fP16.sqr()
Fast Squaring of an FP16

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+mul"></a>

### fP16.mul(y)
Full unconditional Multiplication of two FP16s

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| y | FP16 instance, the multiplier |

<a name="FP16+toString"></a>

### fP16.toString()
convert this to hex string

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+inverse"></a>

### fP16.inverse()
Inverting an FP16

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+times_i"></a>

### fP16.times\_i()
multiplies an FP16 instance by irreducible polynomial sqrt(1+sqrt(-1))

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+times_i2"></a>

### fP16.times\_i2()
multiplies an FP16 instance by irreducible polynomial (1+sqrt(-1))

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+times_i4"></a>

### fP16.times\_i4()
multiplies an FP16 instance by irreducible polynomial (1+sqrt(-1))

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+frob"></a>

### fP16.frob(f)
Raises an FP16 to the power of the internal modulus p, using the Frobenius

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| f | Modulus |

<a name="FP16+pow"></a>

### fP16.pow(e)
Raises an FP16 to the power of a BIG

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| e | BIG instance exponent |

<a name="FP16+xtr_A"></a>

### fP16.xtr\_A(w, y, z)
Calculates the XTR addition function r=w*x-conj(x)*y+z

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| w | FP16 instance |
| y | FP16 instance |
| z | FP16 instance |

<a name="FP16+xtr_D"></a>

### fP16.xtr\_D()
Calculates the XTR doubling function r=x^2-2*conj(x)

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
<a name="FP16+xtr_pow"></a>

### fP16.xtr\_pow(n)
Calculates FP16 trace of an FP16 raised to the power of a BIG number

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  

| Param | Description |
| --- | --- |
| n | Big number |

<a name="FP16+xtr_pow2"></a>

### fP16.xtr\_pow2()
Calculates FP16 trace of c^a.d^b, where c and d are derived from FP16 traces of FP16s

**Kind**: instance method of [<code>FP16</code>](#FP16)  
**this**: <code>{FP16}</code>  
