<a name="FP12"></a>

## FP12
**Kind**: global class  
**this**: <code>{FP12}</code>  

* [FP12](#FP12)
    * [new FP12()](#new_FP12_new)
    * _instance_
        * [.reduce()](#FP12+reduce)
        * [.norm()](#FP12+norm)
        * [.iszilch()](#FP12+iszilch)
        * [.isunity()](#FP12+isunity)
        * [.cmove(g, d)](#FP12+cmove)
        * [.select()](#FP12+select)
        * [.geta()](#FP12+geta)
        * [.getb()](#FP12+getb)
        * [.getc()](#FP12+getc)
        * [.equals(x)](#FP12+equals)
        * [.copy(x)](#FP12+copy)
        * [.one(x)](#FP12+one)
        * [.zero()](#FP12+zero)
        * [.conj()](#FP12+conj)
        * [.set(d, e, f)](#FP12+set)
        * [.seta(d)](#FP12+seta)
        * [.usqr()](#FP12+usqr)
        * [.sqr()](#FP12+sqr)
        * [.mul(y)](#FP12+mul)
        * [.smul(y)](#FP12+smul)
        * [.ssmul(y)](#FP12+ssmul)
        * [.inverse()](#FP12+inverse)
        * [.frob(f)](#FP12+frob)
        * [.trace()](#FP12+trace)
        * [.toString()](#FP12+toString)
        * [.toBytes(w)](#FP12+toBytes)
        * [.pow(e)](#FP12+pow)
        * [.pinpow(e, bts)](#FP12+pinpow)
        * [.compow(e, r)](#FP12+compow)
    * _static_
        * [.fromBytes(w)](#FP12.fromBytes)
        * [.teq()](#FP12.teq)
        * [.pow4()](#FP12.pow4)

<a name="new_FP12_new"></a>

### new FP12()
Creates an instance of FP12.

<a name="FP12+reduce"></a>

### fP12.reduce()
Reduces all components of possibly unreduced FP12 mod Modulus

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+norm"></a>

### fP12.norm()
Normalises the components of an FP12

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+iszilch"></a>

### fP12.iszilch()
Tests for FP12 equal to zero

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+isunity"></a>

### fP12.isunity()
Tests for FP12 equal to unity

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+cmove"></a>

### fP12.cmove(g, d)
Conditional copy of FP12 number

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| g | FP12 instance |
| d | copy depends on this value |

<a name="FP12+select"></a>

### fP12.select()
Constant time select from pre-computed table

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+geta"></a>

### fP12.geta()
extract a from this

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+getb"></a>

### fP12.getb()
extract b from this

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+getc"></a>

### fP12.getc()
extract c from this

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+equals"></a>

### fP12.equals(x)
Tests for equality of two FP12s

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| x | FP12 instance to compare |

<a name="FP12+copy"></a>

### fP12.copy(x)
Copy FP12 to another FP12

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| x | FP12 instance to be copied |

<a name="FP12+one"></a>

### fP12.one(x)
Set FP12 to unity

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| x | FP12 instance to be set to one |

<a name="FP12+zero"></a>

### fP12.zero()
Set FP12 to zero

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+conj"></a>

### fP12.conj()
Conjugation of FP12

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+set"></a>

### fP12.set(d, e, f)
Set FP12 from three FP4 values

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| d | FP4 instance |
| e | FP4 instance |
| f | FP4 instance |

<a name="FP12+seta"></a>

### fP12.seta(d)
Set FP12 from one FP4 value

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| d | FP4 instance |

<a name="FP12+usqr"></a>

### fP12.usqr()
Fast Squaring of an FP12 in "unitary" form

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+sqr"></a>

### fP12.sqr()
Fast Squaring of an FP12

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+mul"></a>

### fP12.mul(y)
Full unconditional Multiplication of two FP12s

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| y | FP12 instance, the multiplier |

<a name="FP12+smul"></a>

### fP12.smul(y)
Fast multiplication of two sparse FP12s that arises from ATE pairing line functions

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| y | FP12 instance, the multiplier |

<a name="FP12+ssmul"></a>

### fP12.ssmul(y)
Fast multiplication of what may be sparse multiplicands

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| y | FP12 instance, the multiplier |

<a name="FP12+inverse"></a>

### fP12.inverse()
Inverting an FP12

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+frob"></a>

### fP12.frob(f)
Raises an FP12 to the power of the internal modulus p, using the Frobenius

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| f | Modulus |

<a name="FP12+trace"></a>

### fP12.trace()
Calculate the trace of an FP12

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+toString"></a>

### fP12.toString()
convert this to hex string

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12+toBytes"></a>

### fP12.toBytes(w)
convert this to byte array

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| w | Byte array |

<a name="FP12+pow"></a>

### fP12.pow(e)
Raises an FP12 to the power of a BIG

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| e | BIG instance exponent |

<a name="FP12+pinpow"></a>

### fP12.pinpow(e, bts)
Raises an FP12 instance x to a small integer power, side-channel resistant

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| e | small integer exponent |
| bts | maximum number of bits in exponent |

<a name="FP12+compow"></a>

### fP12.compow(e, r)
Raises an FP12 instance to a BIG power, compressed to FP4

**Kind**: instance method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| e | BIG exponent |
| r | BIG group order |

<a name="FP12.fromBytes"></a>

### FP12.fromBytes(w)
convert from byte array to FP12

**Kind**: static method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  

| Param | Description |
| --- | --- |
| w | Byte array |

<a name="FP12.teq"></a>

### FP12.teq()
return 1 if b==c, no branching

**Kind**: static method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
<a name="FP12.pow4"></a>

### FP12.pow4()
p=q0^u0.q1^u1.q2^u2.q3^u3

**Kind**: static method of [<code>FP12</code>](#FP12)  
**this**: <code>{FP12}</code>  
