<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

# kubernetes executor

The `kubernetes` executor allows you to run tasks on kubernetes.

```yaml
  - executor: my_kubernetes_executor
    type: kubernetes
```

## attributes

If running pipelines on Airflow, any attribute of
[KubernetesPodOperator](https://airflow.apache.org/docs/apache-airflow/1.10.12/_api/airflow/contrib/operators/kubernetes_pod_operator/index.html)
can be set as an attribute of the executor.

Note that some of these attributes are set in the `task`:
```
image
cmd
mounts
name
env_vars
```
For example, see: [python task](../tasks/python.md)
