/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.spark.kyuubi

import org.apache.spark.SparkContext

import org.apache.kyuubi.engine.spark.events.{EventLogger, KyuubiEvent}

/**
 * A place to invoke non-public APIs of [[SparkContext]], anything to be added here need to
 * think twice
 */
object SparkContextHelper {
  def createSparkHistoryLogger(sc: SparkContext): EventLogger = {
    new SparkHistoryEventLogger(sc)
  }
}

/**
 * A [[EventLogger]] that logs everything to SparkHistory
 * @param sc SparkContext
 */
private class SparkHistoryEventLogger(sc: SparkContext) extends EventLogger {
  override def logEvent(kyuubiEvent: KyuubiEvent): Unit = {
    sc.eventLogger.foreach(_.onOtherEvent(kyuubiEvent))
  }
}
