/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.sort.protocol.transformation;

import java.io.Serializable;
import java.util.Objects;

import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public class TransformationInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @JsonProperty("transform_rule")
    private final TransformationRule transformRule;

    @JsonCreator
    public TransformationInfo(@JsonProperty("transform_rule") TransformationRule transformRule) {
        this.transformRule = transformRule;
    }

    @JsonProperty("transform_rule")
    public TransformationRule getTransformRule() {
        return transformRule;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TransformationInfo that = (TransformationInfo) o;
        return Objects.equals(transformRule, that.transformRule);
    }

    @Override
    public int hashCode() {
        return Objects.hash(transformRule);
    }
}
