/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.manager.common.settings;

public class InlongGroupSettings {

    public static String PULSAR_ADMIN_URL = "pulsar.adminUrl";

    public static String PULSAR_SERVICE_URL = "pulsar.serviceUrl";

    public static String PULSAR_AUTHENTICATION = "pulsar.authentication";

    public static String PULSAR_AUTHENTICATION_TYPE = "pulsar.authentication.type";

    public static String DEFAULT_PULSAR_AUTHENTICATION_TYPE = "token";

    public static String TUBE_MANAGER_URL = "tube.manager.url";

    public static String TUBE_MASTER_URL = "tube.master.url";

    public static String TUBE_CLUSTER_ID = "tube.cluster.id";

    /**
     * oceanus need param start
     */
    public static String SORT_JOB_ID = "sort.job.id";

    public static String ENDPOINT = "endpoint";

    public static String DATA_FLOW = "dataFlow";

    public static String SECRET_ID = "secretId";

    public static String SECRET_KEY = "secretKey";

    public static String REGION = "region";

    public static String CLUSTER_ID = "clusterId";

    public static String FS_ABSTRACT_FILE_SYSTEM_COSN_IMPL = "fs.AbstractFileSystem.cosn.impl";

    public static String FS_COSN_IMPL = "fs.cosn.impl";

    public static String FS_COSN_BUCKET_REGION = "fs.cosn.bucket.region";

    public static String FS_COSN_USERINFO_APPID = "fs.cosn.userinfo.appid";

    public static String FS_COSN_USERINFO_SECRET_ID = "fs.cosn.userinfo.secretId";

    public static String FS_COSN_USERINFO_SECRET_KEY = "fs.cosn.userinfo.secretKey";

    public static String FS_ABSTRACT_FILE_SYSTEM_OFS_IMPL = "fs.AbstractFileSystem.ofs.impl";

    public static String FS_OFS_IMPL = "fs.ofs.impl";

    public static String FS_OFS_TMP_CACHE_DIR = "fs.ofs.tmp.cache.dir";

    public static String FS_OFS_USER_APPID = "fs.ofs.user.appid";

    public static String SORT_TYPE = "sort.type";

    public static String DEFAULT_SORT_TYPE = "flink";

    public static String SORT_NAME = "sort.name";

    public static String SORT_URL = "sort.url";

    public static String SORT_AUTHENTICATION = "sort.authentication";

    public static String SORT_AUTHENTICATION_TYPE = "sort.authentication.type";

    public static String DEFAULT_SORT_AUTHENTICATION_TYPE = "secret_and_token";

    public static String SORT_PROPERTIES = "sort.properties";

}
