/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.manager.common.enums;

/**
 * Constant for system
 */
@Deprecated
public class Constant {

    public static final Integer UN_DELETED = 0;
    public static final Integer IS_DELETED = 1;
    public static final String URL_SPLITTER = ",";
    public static final String HOST_SPLITTER = ":";

    public static final String DATA_SOURCE_DB = "DB";

    public static final String DATA_SOURCE_FILE = "FILE";

    public static final String DATA_SOURCE_AUTO_PUSH = "AUTO_PUSH";

    public static final String DATA_TYPE_TEXT = "TEXT";

    public static final String DATA_TYPE_KEY_VALUE = "KEY-VALUE";

    public static final String FILE_FORMAT_TEXT = "TextFile";

    public static final String FILE_FORMAT_ORC = "OrcFile";

    public static final String FILE_FORMAT_SEQUENCE = "SequenceFile";

    public static final String FILE_FORMAT_PARQUET = "Parquet";

    public static final String SCHEMA_M0_DAY = "m0_day";

    public static final String CLUSTER_TUBE = "TUBE";
    public static final String CLUSTER_PULSAR = "PULSAR";
    public static final String CLUSTER_TDMQ_PULSAR = "TDMQ_PULSAR";
    public static final String CLUSTER_DATA_PROXY = "DATA_PROXY";

    public static final String ID_IS_EMPTY = "primary key is empty";

    public static final String GROUP_ID_IS_EMPTY = "inlong group id is empty";

    public static final String STREAM_ID_IS_EMPTY = "inlong stream id is empty";

    public static final String REQUEST_IS_EMPTY = "request is empty";

    public static final String PULSAR_TOPIC_TYPE_SERIAL = "SERIAL";

    public static final String PULSAR_TOPIC_TYPE_PARALLEL = "PARALLEL";

    public static final String SYSTEM_USER = "SYSTEM"; // system user

    public static final String PREFIX_DLQ = "dlq"; // prefix of the Topic of the dead letter queue

    public static final String PREFIX_RLQ = "rlq"; // prefix of the Topic of the retry letter queue

    public static final Integer ENABLE_CREATE_RESOURCE = 1; // Enable create resource

    public static final Integer DISABLE_CREATE_RESOURCE = 0; // Disable create resource

    public static final String CLUSTER_TUBE_MANAGER = "cluster_tube_manager";

    public static final String CLUSTER_TUBE_CLUSTER_ID = "cluster_tube_clusterId";

    public static final String PULSAR_ADMINURL = "pulsar_adminUrl";

    public static final String PULSAR_SERVICEURL = "pulsar_serviceUrl";

    public static final String TUBE_MASTER_URL = "tube_masterUrl";

    public static final String DATA_FLOW_GROUP_ID_KEY = "inlong.group.id";

}
