/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.agent.plugin.sources;

import com.google.gson.Gson;
import org.apache.inlong.agent.pojo.DebeziumFormat;
import org.junit.Assert;
import org.junit.Test;

public class TestBinlogReader {

    private static Gson gson = new Gson();

    @Test
    public void testDebeziumFormat() {
        String debeziumJson = "{\n"
            + "    \"before\": null,\n"
            + "    \"after\": {\n"
            + "      \"id\": 1004,\n"
            + "      \"first_name\": \"Anne\",\n"
            + "      \"last_name\": \"Kretchmar\",\n"
            + "      \"email\": \"annek@noanswer.org\"\n"
            + "    },\n"
            + "    \"source\": {\n"
            + "      \"version\": \"1.8.1.Final\",\n"
            + "      \"name\": \"dbserver1\",\n"
            + "      \"server_id\": 0,\n"
            + "      \"ts_sec\": 0,\n"
            + "      \"gtid\": null,\n"
            + "      \"file\": \"mysql-bin.000003\",\n"
            + "      \"pos\": 154,\n"
            + "      \"row\": 0,\n"
            + "      \"snapshot\": true,\n"
            + "      \"thread\": null,\n"
            + "      \"db\": \"inventory\",\n"
            + "      \"table\": \"customers\"\n"
            + "    },\n"
            + "    \"op\": \"r\",\n"
            + "    \"ts_ms\": 1486500577691\n"
            + "  }";
        DebeziumFormat debeziumFormat = gson
            .fromJson(debeziumJson, DebeziumFormat.class);
        Assert.assertEquals("customers", debeziumFormat.getSource().getTable());
    }
}
