/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.sort.flink.metrics;

import org.apache.flink.streaming.api.functions.sink.SinkFunction.Context;
import org.apache.inlong.sort.flink.metrics.MetricData.MetricSource;
import org.apache.inlong.sort.flink.metrics.MetricData.MetricType;
import org.junit.Test;

public class MetricsLogSinkTest {
    @Test
    public void test() throws Exception {
        final org.apache.flink.configuration.Configuration flinkConfig
                = new org.apache.flink.configuration.Configuration();
        MetricsLogSink metricsLogSink = new MetricsLogSink();
        metricsLogSink.open(flinkConfig);

        MetricData metricData = new MetricData(
                MetricSource.SOURCE,
                MetricType.SUCCESSFUL,
                0,
                1,
                "attach",
                1
        );
        metricsLogSink.invoke(metricData, new Context() {
            @Override
            public long currentProcessingTime() {
                return 0;
            }

            @Override
            public long currentWatermark() {
                return 0;
            }

            @Override
            public Long timestamp() {
                return null;
            }
        });
    }
}
