/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.store.config;

import lombok.Getter;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Getter
@Setter
public class PulsarConfig {
    @Value("${audit.pulsar.server.url}")
    private String pulsarServerUrl;

    @Value("${audit.pulsar.topic}")
    private String pulsarTopic;

    @Value("${audit.pulsar.consumer.sub.name}")
    private String pulsarConsumerSubName;

    @Value("${audit.pulsar.consumer.enable.retry:false}")
    private boolean pulsarConsumerEnableRetry = false;

    @Value("${audit.pulsar.consumer.receive.queue.size:1000}")
    private int consumerReceiveQueueSize = 1000;

    @Value("${audit.pulsar.client.operation.timeout.second:30}")
    private int clientOperationTimeoutSecond = 30;

    @Value("${audit.pulsar.client.concurrent.consumer.num:1}")
    private int concurrentConsumerNum = 1;

}
