/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.manager.workflow.core;

import org.apache.inlong.manager.workflow.model.Action;
import org.apache.inlong.manager.workflow.model.WorkflowContext;
import org.apache.inlong.manager.workflow.model.definition.ProcessForm;
import org.apache.inlong.manager.workflow.model.definition.TaskForm;

import java.util.List;

/**
 * Workflow context builder
 */
public interface WorkflowContextBuilder {

    /**
     * Build process context information when initiating a process
     *
     * @param name      Processs name
     * @param applicant Application
     * @param form      Form
     * @return
     */
    WorkflowContext buildContextForProcess(String name, String applicant, ProcessForm form);

    /**
     * Process ID construction context information
     *
     * @param processInstId Process ID
     * @return Context
     */
    WorkflowContext buildContextForProcess(Integer processInstId);


    /**
     * Build context information based on task ID
     *
     * @param taskInstId
     * @param action
     * @param remark
     * @param operator
     * @return
     */
    WorkflowContext buildContextForTask(Integer taskInstId, Action action, String remark, String operator);

    /**
     * Build task context information
     *
     * @param taskInstId
     * @param action
     * @param taskForm
     * @param remark
     * @param operator
     * @return
     */
    WorkflowContext buildContextForTask(Integer taskInstId, Action action, TaskForm taskForm, String remark,
                                        String operator);

    /**
     * Build task context information
     *
     * @param taskInstId
     * @param action
     * @param transferToUsers
     * @param remark
     * @param operator
     * @return
     */
    WorkflowContext buildContextForTask(Integer taskInstId, Action action, List<String> transferToUsers, String remark,
                                        String operator);

    /**
     * Build context information based on task ID
     *
     * @param taskInstId Process ID
     * @param action     Action
     * @return
     */
    WorkflowContext buildContextForTask(Integer taskInstId, Action action);
}
