/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.manager.service.workflow;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * Workflow operation
 */
@Data
@ApiModel("Workflow operation parameters")
public class WorkflowOperation {

    /**
     * Process name-KEY
     */
    @ApiModelProperty(value = "Process name", notes = "Specify the process name when initiating the process")
    public ProcessName name;
    /**
     * Applicant
     */
    @ApiModelProperty(value = "Applicant", notes = "Nominate applicants when initiating the process")
    public String applicant;
    /**
     * Remarks information
     */
    @ApiModelProperty(value = "Remarks information", notes = "Submit remarks when operating a flow sheet or task sheet")
    public String remark;

    /**
     * Form information
     */
    @ApiModelProperty(value = "Form information", notes = "When initiating a process or approving task, "
            + "submit the form information that needs to be submitted")
    public BaseWorkflowFormType form;
}
