// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

namespace Apache.Iggy.Publishers;

/// <summary>
///     Event arguments for publisher error events.
/// </summary>
public class PublisherErrorEventArgs : EventArgs
{
    /// <summary>
    ///     Gets the exception that occurred.
    /// </summary>
    public Exception Exception { get; }

    /// <summary>
    ///     Gets a descriptive message about the error.
    /// </summary>
    public string Message { get; }

    /// <summary>
    ///     Gets the UTC timestamp when the error occurred.
    /// </summary>
    public DateTime Timestamp { get; }

    /// <summary>
    ///     Initializes a new instance of the <see cref="PublisherErrorEventArgs" /> class.
    /// </summary>
    /// <param name="exception">The exception that occurred.</param>
    /// <param name="message">A descriptive message about the error.</param>
    public PublisherErrorEventArgs(Exception exception, string message)
    {
        Exception = exception;
        Message = message;
        Timestamp = DateTime.UtcNow;
    }
}
