/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.FileDescriptor;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.computer.core.network.buffer.NetworkBuffer;

public class FileRegionBuffer
implements NetworkBuffer {
    private final int length;
    private String path;

    public FileRegionBuffer(int length) {
        this.length = length;
    }

    public ChannelFuture transformFromChannel(SocketChannel channel, String targetPath) {
        assert (channel.eventLoop().inEventLoop());
        ChannelPromise channelPromise = channel.newPromise();
        try {
            if (channel instanceof EpollSocketChannel) {
                FileDescriptor fd = FileDescriptor.from((String)targetPath);
                try {
                    ((EpollSocketChannel)channel).spliceTo(fd, 0, this.length, channelPromise);
                    channelPromise.addListener(future -> fd.close());
                }
                catch (Throwable throwable) {
                    fd.close();
                    throw throwable;
                }
            }
            try (RandomAccessFile file = new RandomAccessFile(targetPath, "rw");){
                FileChannel fileChannel = file.getChannel();
                NioSocketChannel nioChannel = (NioSocketChannel)channel;
                ReadableByteChannel javaChannel = (ReadableByteChannel)((Object)nioChannel.unsafe().ch());
                fileChannel.transferFrom(javaChannel, 0L, this.length);
                channelPromise.setSuccess();
                fileChannel.close();
            }
            this.path = targetPath;
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            throw new ComputerException("Failed to transform from socket to file, targetPath:%s, remoteAddress:%s", throwable, new Object[]{targetPath, TransportUtil.remoteAddress((Channel)channel)});
        }
        return channelPromise;
    }

    public String path() {
        return this.path;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public NetworkBuffer retain() {
        return this;
    }

    @Override
    public NetworkBuffer release() {
        return this;
    }

    @Override
    public int referenceCount() {
        return -1;
    }

    @Override
    public ByteBuffer nioByteBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf nettyByteBuf() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] copyToByteArray() {
        throw new UnsupportedOperationException();
    }
}

