/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.algorithm.path.rings.filter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.hugegraph.computer.algorithm.path.rings.filter.FilterDescribe;
import org.apache.hugegraph.computer.algorithm.path.rings.filter.RingsDetectionMessage;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.mvel2.MVEL;

public class SpreadFilter {
    private static final String ALL = "*";
    private static final String MESSAGE = "$message";
    private static final String ELEMENT = "$element";
    private static final List<Serializable> PASS = ImmutableList.of();
    private final Map<String, Serializable> vertexFilter;
    private final Map<String, Serializable> edgeSpreadFilter;
    private final Map<String, Serializable> edgeFilter;

    public SpreadFilter(String describe) {
        FilterDescribe des = FilterDescribe.of(describe);
        this.vertexFilter = new HashMap<String, Serializable>();
        this.edgeSpreadFilter = new HashMap<String, Serializable>();
        this.edgeFilter = new HashMap<String, Serializable>();
        this.init(this.vertexFilter, des.vertexFilter(), expression -> true);
        this.init(this.edgeSpreadFilter, des.edgeFilter(), expression -> true);
        this.init(this.edgeFilter, des.edgeFilter(), expression -> !expression.contains(MESSAGE));
    }

    private void init(Map<String, Serializable> filter, List<FilterDescribe.DescribeItem> describes, Predicate<? super String> predicate) {
        for (FilterDescribe.DescribeItem describe : describes) {
            String labelName = describe.label();
            String propertyFilter = describe.propertyFilter();
            if (!predicate.test(propertyFilter) && !ALL.equals(labelName)) continue;
            Serializable expression = MVEL.compileExpression(describe.propertyFilter());
            filter.put(labelName, expression);
        }
    }

    public boolean filter(Vertex vertex) {
        String label = vertex.label();
        List<Serializable> expressions = SpreadFilter.expressions(this.vertexFilter, label);
        if (expressions == PASS) {
            return true;
        }
        ImmutableMap params = ImmutableMap.of((Object)ELEMENT, (Object)vertex.properties().get());
        return SpreadFilter.filter((Map<String, Map<String, Value>>)params, expressions);
    }

    public boolean filter(Edge edge) {
        String label = edge.label();
        List<Serializable> expressions = SpreadFilter.expressions(this.edgeFilter, label);
        if (expressions == PASS) {
            return true;
        }
        ImmutableMap params = ImmutableMap.of((Object)ELEMENT, (Object)edge.properties().get());
        return SpreadFilter.filter((Map<String, Map<String, Value>>)params, expressions);
    }

    public boolean filter(Edge edge, RingsDetectionMessage message) {
        String label = edge.label();
        List<Serializable> expressions = SpreadFilter.expressions(this.edgeSpreadFilter, label);
        if (expressions == PASS) {
            return true;
        }
        ImmutableMap params = ImmutableMap.of((Object)ELEMENT, (Object)edge.properties().get(), (Object)MESSAGE, (Object)message.walkEdgeProp().get());
        return SpreadFilter.filter((Map<String, Map<String, Value>>)params, expressions);
    }

    private static boolean filter(Map<String, Map<String, Value>> params, List<Serializable> expressions) {
        Map<String, Object> map = SpreadFilter.convertParamsValueToObject(params);
        return expressions.stream().allMatch(expression -> (Boolean)MVEL.executeExpression(expression, map));
    }

    private static List<Serializable> expressions(Map<String, Serializable> filter, String label) {
        if (filter.size() == 0) {
            return PASS;
        }
        ArrayList<Serializable> expressions = new ArrayList<Serializable>();
        if (filter.containsKey(ALL)) {
            expressions.add(filter.get(ALL));
        }
        if (filter.containsKey(label)) {
            expressions.add(filter.get(label));
        }
        return expressions;
    }

    private static Map<String, Object> convertParamsValueToObject(Map<String, Map<String, Value>> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Map<String, Value>> entry : params.entrySet()) {
            HashMap<String, Object> subKv = new HashMap<String, Object>();
            Map<String, Value> param = entry.getValue();
            for (Map.Entry<String, Value> paramItem : param.entrySet()) {
                subKv.put(paramItem.getKey(), paramItem.getValue().value());
            }
            result.put(entry.getKey(), subKv);
        }
        return result;
    }
}

