/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.blockingtransform;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.blockingtransform.BlockingTransformData;
import org.apache.hop.pipeline.transforms.blockingtransform.BlockingTransformMeta;

public class BlockingTransform
extends BaseTransform<BlockingTransformMeta, BlockingTransformData>
implements ITransform<BlockingTransformMeta, BlockingTransformData> {
    private static final Class<?> PKG = BlockingTransformMeta.class;
    private Object[] lastRow;

    public BlockingTransform(TransformMeta transformMeta, BlockingTransformMeta meta, BlockingTransformData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private boolean addBuffer(IRowMeta rowMeta, Object[] r) {
        if (r != null) {
            ((BlockingTransformData)this.data).buffer.add(r);
        }
        if (((BlockingTransformData)this.data).buffer.size() == ((BlockingTransformMeta)this.meta).getCacheSize() || ((BlockingTransformData)this.data).files.size() > 0 && r == null && ((BlockingTransformData)this.data).buffer.size() > 0) {
            try {
                DataOutputStream dos;
                GZIPOutputStream gzos;
                FileObject fileObject = HopVfs.createTempFile((String)((BlockingTransformMeta)this.meta).getPrefix(), (String)".tmp", (String)this.resolve(((BlockingTransformMeta)this.meta).getDirectory()));
                ((BlockingTransformData)this.data).files.add(fileObject);
                OutputStream outputStream = HopVfs.getOutputStream((FileObject)fileObject, (boolean)false);
                if (((BlockingTransformMeta)this.meta).isCompressFiles()) {
                    gzos = new GZIPOutputStream(new BufferedOutputStream(outputStream));
                    dos = new DataOutputStream(gzos);
                } else {
                    dos = new DataOutputStream(outputStream);
                    gzos = null;
                }
                dos.writeInt(((BlockingTransformData)this.data).buffer.size());
                for (int p = 0; p < ((BlockingTransformData)this.data).buffer.size(); ++p) {
                    rowMeta.writeData(dos, ((BlockingTransformData)this.data).buffer.get(p));
                }
                dos.close();
                if (gzos != null) {
                    gzos.close();
                }
                outputStream.close();
            }
            catch (Exception e) {
                this.logError("Error processing tmp-file: " + e.toString());
                return false;
            }
            ((BlockingTransformData)this.data).buffer.clear();
        }
        return true;
    }

    private Object[] getBuffer() {
        Object[] retval;
        block21: {
            InputStream fi;
            if (((BlockingTransformData)this.data).files.size() > 0 && (((BlockingTransformData)this.data).dis.size() == 0 || ((BlockingTransformData)this.data).fis.size() == 0)) {
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"BlockingTransform.Log.Openfiles", (String[])new String[0]));
                }
                try {
                    DataInputStream di;
                    FileObject fileObject = ((BlockingTransformData)this.data).files.get(0);
                    String filename = HopVfs.getFilename((FileObject)fileObject);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"BlockingTransform.Log.Openfilename1", (String[])new String[0]) + filename + BaseMessages.getString(PKG, (String)"BlockingTransform.Log.Openfilename2", (String[])new String[0]));
                    }
                    fi = HopVfs.getInputStream((FileObject)fileObject);
                    ((BlockingTransformData)this.data).fis.add(fi);
                    if (((BlockingTransformMeta)this.meta).isCompressFiles()) {
                        GZIPInputStream gzfi = new GZIPInputStream(new BufferedInputStream(fi));
                        di = new DataInputStream(gzfi);
                        ((BlockingTransformData)this.data).gzis.add(gzfi);
                    } else {
                        di = new DataInputStream(fi);
                    }
                    ((BlockingTransformData)this.data).dis.add(di);
                    int buffersize = di.readInt();
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"BlockingTransform.Log.BufferSize1", (String[])new String[0]) + filename + BaseMessages.getString(PKG, (String)"BlockingTransform.Log.BufferSize2", (String[])new String[0]) + buffersize + " " + BaseMessages.getString(PKG, (String)"BlockingTransform.Log.BufferSize3", (String[])new String[0]));
                    }
                    if (buffersize > 0) {
                        ((BlockingTransformData)this.data).rowbuffer.add(((BlockingTransformData)this.data).outputRowMeta.readData(di));
                    }
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"BlockingTransformMeta.ErrorReadingFile", (String[])new String[0]) + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                }
            }
            if (((BlockingTransformData)this.data).files.size() == 0) {
                if (((BlockingTransformData)this.data).buffer.size() > 0) {
                    retval = ((BlockingTransformData)this.data).buffer.get(0);
                    ((BlockingTransformData)this.data).buffer.remove(0);
                } else {
                    retval = null;
                }
            } else if (((BlockingTransformData)this.data).rowbuffer.size() == 0) {
                retval = null;
            } else {
                retval = ((BlockingTransformData)this.data).rowbuffer.get(0);
                ((BlockingTransformData)this.data).rowbuffer.remove(0);
                FileObject file = ((BlockingTransformData)this.data).files.get(0);
                DataInputStream di = ((BlockingTransformData)this.data).dis.get(0);
                fi = ((BlockingTransformData)this.data).fis.get(0);
                GZIPInputStream gzfi = ((BlockingTransformMeta)this.meta).isCompressFiles() ? ((BlockingTransformData)this.data).gzis.get(0) : null;
                try {
                    ((BlockingTransformData)this.data).rowbuffer.add(0, ((BlockingTransformData)this.data).outputRowMeta.readData(di));
                }
                catch (SocketTimeoutException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Log.UnexpectedError", (String[])new String[0]) + " : " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.setErrors(1L);
                    this.stopAll();
                }
                catch (HopFileException fe) {
                    try {
                        di.close();
                        fi.close();
                        if (gzfi != null) {
                            gzfi.close();
                        }
                        file.delete();
                    }
                    catch (IOException e) {
                        this.logError(BaseMessages.getString(PKG, (String)"BlockingTransformMeta.UnableDeleteFile", (String[])new String[0]) + file.toString());
                        this.setErrors(1L);
                        this.stopAll();
                        return null;
                    }
                    ((BlockingTransformData)this.data).files.remove(0);
                    ((BlockingTransformData)this.data).dis.remove(0);
                    ((BlockingTransformData)this.data).fis.remove(0);
                    if (gzfi == null) break block21;
                    ((BlockingTransformData)this.data).gzis.remove(0);
                }
            }
        }
        return retval;
    }

    public void dispose() {
        if (((BlockingTransformData)this.data).dis != null && ((BlockingTransformData)this.data).dis.size() > 0) {
            for (DataInputStream is : ((BlockingTransformData)this.data).dis) {
                BaseTransform.closeQuietly((Closeable)is);
            }
        }
        for (int f = 0; f < ((BlockingTransformData)this.data).files.size(); ++f) {
            FileObject fileToDelete = ((BlockingTransformData)this.data).files.get(f);
            try {
                if (fileToDelete == null || !fileToDelete.exists()) continue;
                fileToDelete.delete();
                continue;
            }
            catch (FileSystemException e) {
                this.logError(e.getLocalizedMessage(), e);
            }
        }
        super.dispose();
    }

    public boolean init() {
        return super.init();
    }

    public boolean processRow() throws HopException {
        boolean err = true;
        Object[] r = this.getRow();
        if (this.first && r != null) {
            this.first = false;
            ((BlockingTransformData)this.data).outputRowMeta = this.getInputRowMeta().clone();
        }
        if (!((BlockingTransformMeta)this.meta).isPassAllRows()) {
            if (r == null) {
                if (this.lastRow != null) {
                    this.putRow(((BlockingTransformData)this.data).outputRowMeta, this.lastRow);
                }
                this.setOutputDone();
                return false;
            }
            this.lastRow = r;
            return true;
        }
        err = this.addBuffer(this.getInputRowMeta(), r);
        if (!err) {
            this.setOutputDone();
            return false;
        }
        if (r == null) {
            r = this.getBuffer();
            while (r != null && !this.isStopped()) {
                if (this.log.isRowLevel()) {
                    this.logRowlevel("Read row: " + this.getInputRowMeta().getString(r));
                }
                this.putRow(((BlockingTransformData)this.data).outputRowMeta, r);
                r = this.getBuffer();
            }
            this.setOutputDone();
            return false;
        }
        return true;
    }
}

