/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sql;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sql.ExecSql;
import org.apache.hop.pipeline.transforms.sql.ExecSqlData;
import org.w3c.dom.Node;

@Transform(id="ExecSql", image="sql.svg", name="i18n::ExecSql.Name", description="i18n::ExecSql.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Scripting", documentationUrl="/pipeline/transforms/execsql.html")
@InjectionSupported(localizationPrefix="ExecSqlMeta.Injection.", groups={"PARAMETERS"})
public class ExecSqlMeta
extends BaseTransformMeta
implements ITransformMeta<ExecSql, ExecSqlData> {
    private static final Class<?> PKG = ExecSqlMeta.class;
    private DatabaseMeta databaseMeta;
    @Injection(name="SQL")
    private String sql;
    @Injection(name="EXECUTE_FOR_EACH_ROW")
    private boolean executedEachInputRow;
    @Injection(name="PARAMETER_NAME", group="PARAMETERS")
    private String[] arguments;
    @Injection(name="UPDATE_STATS_FIELD")
    private String updateField;
    @Injection(name="INSERT_STATS_FIELD")
    private String insertField;
    @Injection(name="DELETE_STATS_FIELD")
    private String deleteField;
    @Injection(name="READ_STATS_FIELD")
    private String readField;
    @Injection(name="EXECUTE_AS_SINGLE_STATEMENT")
    private boolean singleStatement;
    @Injection(name="REPLACE_VARIABLES")
    private boolean replaceVariables;
    @Injection(name="QUOTE_STRINGS")
    private boolean quoteString;
    @Injection(name="BIND_PARAMETERS")
    private boolean setParams;

    @Injection(name="CONNECTIONNAME")
    public void setConnection(String connectionName) {
        this.databaseMeta = DatabaseMeta.findDatabase((List)this.getParentTransformMeta().getParentPipelineMeta().getDatabases(), (String)connectionName);
    }

    public boolean isParams() {
        return this.setParams;
    }

    public void setParams(boolean value) {
        this.setParams = value;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public boolean isExecutedEachInputRow() {
        return this.executedEachInputRow;
    }

    public void setExecutedEachInputRow(boolean executedEachInputRow) {
        this.executedEachInputRow = executedEachInputRow;
    }

    public String getDeleteField() {
        return this.deleteField;
    }

    public void setDeleteField(String deleteField) {
        this.deleteField = deleteField;
    }

    public String getInsertField() {
        return this.insertField;
    }

    public void setInsertField(String insertField) {
        this.insertField = insertField;
    }

    public String getReadField() {
        return this.readField;
    }

    public void setReadField(String readField) {
        this.readField = readField;
    }

    public String getUpdateField() {
        return this.updateField;
    }

    public void setUpdateField(String updateField) {
        this.updateField = updateField;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public Object clone() {
        ExecSqlMeta retval = (ExecSqlMeta)((Object)super.clone());
        int nrArgs = this.arguments.length;
        retval.allocate(nrArgs);
        System.arraycopy(this.arguments, 0, retval.arguments, 0, nrArgs);
        return retval;
    }

    public void allocate(int nrargs) {
        this.arguments = new String[nrargs];
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            String con = XmlHandler.getTagValue((Node)transformNode, (String)"connection");
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)con);
            String eachRow = XmlHandler.getTagValue((Node)transformNode, (String)"execute_each_row");
            this.executedEachInputRow = "Y".equalsIgnoreCase(eachRow);
            this.singleStatement = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"single_statement"));
            this.replaceVariables = "Y".equals(XmlHandler.getTagValue((Node)transformNode, (String)"replace_variables"));
            this.quoteString = "Y".equals(XmlHandler.getTagValue((Node)transformNode, (String)"quoteString"));
            this.setParams = "Y".equals(XmlHandler.getTagValue((Node)transformNode, (String)"set_params"));
            this.sql = XmlHandler.getTagValue((Node)transformNode, (String)"sql");
            this.insertField = XmlHandler.getTagValue((Node)transformNode, (String)"insert_field");
            this.updateField = XmlHandler.getTagValue((Node)transformNode, (String)"update_field");
            this.deleteField = XmlHandler.getTagValue((Node)transformNode, (String)"delete_field");
            this.readField = XmlHandler.getTagValue((Node)transformNode, (String)"read_field");
            Node argsnode = XmlHandler.getSubNode((Node)transformNode, (String)"arguments");
            int nrArguments = XmlHandler.countNodes((Node)argsnode, (String)"argument");
            this.allocate(nrArguments);
            for (int i = 0; i < nrArguments; ++i) {
                Node argnode = XmlHandler.getSubNodeByNr((Node)argsnode, (String)"argument", (int)i);
                this.arguments[i] = XmlHandler.getTagValue((Node)argnode, (String)"name");
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ExecSqlMeta.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.databaseMeta = null;
        this.sql = "";
        this.arguments = new String[0];
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        RowMetaAndData add = ExecSql.getResultRow(new Result(), this.getUpdateField(), this.getInsertField(), this.getDeleteField(), this.getReadField());
        r.mergeRowMeta(add.getRowMeta());
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XmlHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XmlHandler.addTagValue((String)"execute_each_row", (boolean)this.executedEachInputRow));
        retval.append("    ").append(XmlHandler.addTagValue((String)"single_statement", (boolean)this.singleStatement));
        retval.append("    ").append(XmlHandler.addTagValue((String)"replace_variables", (boolean)this.replaceVariables));
        retval.append("    ").append(XmlHandler.addTagValue((String)"quoteString", (boolean)this.quoteString));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sql", (String)this.sql));
        retval.append("    ").append(XmlHandler.addTagValue((String)"set_params", (boolean)this.setParams));
        retval.append("    ").append(XmlHandler.addTagValue((String)"insert_field", (String)this.insertField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"update_field", (String)this.updateField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"delete_field", (String)this.deleteField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"read_field", (String)this.readField));
        retval.append("    <arguments>").append(Const.CR);
        for (int i = 0; i < this.arguments.length; ++i) {
            retval.append("       <argument>").append(XmlHandler.addTagValue((String)"name", (String)this.arguments[i], (boolean)false, (String[])new String[0])).append("</argument>").append(Const.CR);
        }
        retval.append("    </arguments>").append(Const.CR);
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (this.databaseMeta != null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.ConnectionExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Database db = new Database(loggingObject, variables, this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.DBConnectionOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                if (this.sql != null && this.sql.length() != 0) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.SQLStatementEntered", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.SQLStatementMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage(), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.ConnectionNeeded", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.executedEachInputRow) {
            if (input.length > 0) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.TransformReceivingInfoOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.SQLOnlyExecutedOnce", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecSqlMeta.CheckResult.InputReceivedOKForSQLOnlyExecuteOnce", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public ITransform createTransform(TransformMeta transformMeta, ExecSqlData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new ExecSql(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public ExecSqlData getTransformData() {
        return new ExecSqlData();
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, RowMeta prev, String[] input, String[] output, RowMeta info) throws HopTransformException {
        DatabaseImpact ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), BaseMessages.getString(PKG, (String)"ExecSqlMeta.DatabaseMeta.Unknown.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecSqlMeta.DatabaseMeta.Unknown2.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecSqlMeta.DatabaseMeta.Unknown3.Label", (String[])new String[0]), transformMeta.getName(), this.sql, BaseMessages.getString(PKG, (String)"ExecSqlMeta.DatabaseMeta.Title", (String[])new String[0]));
        impact.add(ii);
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean isReplaceVariables() {
        return this.replaceVariables;
    }

    public void setVariableReplacementActive(boolean variableReplacementActive) {
        this.replaceVariables = variableReplacementActive;
    }

    public boolean isQuoteString() {
        return this.quoteString;
    }

    public void setQuoteString(boolean quoteString) {
        this.quoteString = quoteString;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public boolean isSingleStatement() {
        return this.singleStatement;
    }

    public void setSingleStatement(boolean singleStatement) {
        this.singleStatement = singleStatement;
    }
}

