/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.closure;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.closure.ClosureGeneratorMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ClosureGeneratorDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = ClosureGeneratorDialog.class;
    private Button wRootZero;
    private CCombo wParent;
    private CCombo wChild;
    private Text wDistance;
    private final ClosureGeneratorMeta input;
    private IRowMeta inputFields;

    public ClosureGeneratorDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (ClosureGeneratorMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ClosureGeneratorDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ClosureGeneratorDialog.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlParent = new Label((Composite)this.shell, 131072);
        wlParent.setText(BaseMessages.getString(PKG, (String)"ClosureGeneratorDialog.ParentField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlParent);
        FormData fdlParent = new FormData();
        fdlParent.left = new FormAttachment(0, 0);
        fdlParent.right = new FormAttachment(middle, -margin);
        fdlParent.top = new FormAttachment((Control)this.wTransformName, margin);
        wlParent.setLayoutData((Object)fdlParent);
        this.wParent = new CCombo((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wParent);
        this.wParent.addModifyListener(lsMod);
        FormData fdParent = new FormData();
        fdParent.left = new FormAttachment(middle, 0);
        fdParent.right = new FormAttachment(100, 0);
        fdParent.top = new FormAttachment((Control)this.wTransformName, margin);
        this.wParent.setLayoutData((Object)fdParent);
        Label wlChild = new Label((Composite)this.shell, 131072);
        wlChild.setText(BaseMessages.getString(PKG, (String)"ClosureGeneratorDialog.ChildField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlChild);
        FormData fdlChild = new FormData();
        fdlChild.left = new FormAttachment(0, 0);
        fdlChild.right = new FormAttachment(middle, -margin);
        fdlChild.top = new FormAttachment((Control)this.wParent, margin);
        wlChild.setLayoutData((Object)fdlChild);
        this.wChild = new CCombo((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wChild);
        this.wChild.addModifyListener(lsMod);
        FormData fdChild = new FormData();
        fdChild.left = new FormAttachment(middle, 0);
        fdChild.right = new FormAttachment(100, 0);
        fdChild.top = new FormAttachment((Control)this.wParent, margin);
        this.wChild.setLayoutData((Object)fdChild);
        Label wlDistance = new Label((Composite)this.shell, 131072);
        wlDistance.setText(BaseMessages.getString(PKG, (String)"ClosureGeneratorDialog.DistanceField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDistance);
        FormData fdlDistance = new FormData();
        fdlDistance.left = new FormAttachment(0, 0);
        fdlDistance.right = new FormAttachment(middle, -margin);
        fdlDistance.top = new FormAttachment((Control)this.wChild, margin);
        wlDistance.setLayoutData((Object)fdlDistance);
        this.wDistance = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDistance);
        this.wDistance.addModifyListener(lsMod);
        FormData fdDistance = new FormData();
        fdDistance.left = new FormAttachment(middle, 0);
        fdDistance.right = new FormAttachment(100, 0);
        fdDistance.top = new FormAttachment((Control)this.wChild, margin);
        this.wDistance.setLayoutData((Object)fdDistance);
        Label wlRootZero = new Label((Composite)this.shell, 131072);
        wlRootZero.setText(BaseMessages.getString(PKG, (String)"ClosureGeneratorDialog.RootZero.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRootZero);
        FormData fdlRootZero = new FormData();
        fdlRootZero.left = new FormAttachment(0, 0);
        fdlRootZero.right = new FormAttachment(middle, -margin);
        fdlRootZero.top = new FormAttachment((Control)this.wDistance, margin);
        wlRootZero.setLayoutData((Object)fdlRootZero);
        this.wRootZero = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wRootZero);
        FormData fdRootZero = new FormData();
        fdRootZero.left = new FormAttachment(middle, 0);
        fdRootZero.right = new FormAttachment(100, 0);
        fdRootZero.top = new FormAttachment((Control)wlRootZero, 0, 0x1000000);
        this.wRootZero.setLayoutData((Object)fdRootZero);
        this.wRootZero.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    this.inputFields = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ClosureGeneratorDialog.Log.UnableToFindInput", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, 2 * margin, (Control)this.wRootZero);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        this.shell.getDisplay().syncExec(() -> {
            if (this.inputFields != null) {
                String[] fieldNames = this.inputFields.getFieldNames();
                this.wParent.setItems(fieldNames);
                this.wChild.setItems(fieldNames);
            }
        });
    }

    public void getData() {
        if (this.input.getParentIdFieldName() != null) {
            this.wParent.setText(this.input.getParentIdFieldName());
        }
        if (this.input.getChildIdFieldName() != null) {
            this.wChild.setText(this.input.getChildIdFieldName());
        }
        if (this.input.getDistanceFieldName() != null) {
            this.wDistance.setText(this.input.getDistanceFieldName());
        }
        this.wRootZero.setSelection(this.input.isRootIdZero());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(ClosureGeneratorMeta meta) {
        meta.setParentIdFieldName(this.wParent.getText());
        meta.setChildIdFieldName(this.wChild.getText());
        meta.setDistanceFieldName(this.wDistance.getText());
        meta.setRootIdZero(this.wRootZero.getSelection());
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }
}

