/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.closure;

import java.util.HashMap;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.closure.ClosureGeneratorData;
import org.apache.hop.pipeline.transforms.closure.ClosureGeneratorMeta;

public class ClosureGenerator
extends BaseTransform<ClosureGeneratorMeta, ClosureGeneratorData>
implements ITransform<ClosureGeneratorMeta, ClosureGeneratorData> {
    private static final Class<?> PKG = ClosureGeneratorMeta.class;

    public ClosureGenerator(TransformMeta transformMeta, ClosureGeneratorMeta meta, ClosureGeneratorData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        if (((ClosureGeneratorData)this.data).reading) {
            Object[] rowData = this.getRow();
            if (rowData == null) {
                ((ClosureGeneratorData)this.data).reading = false;
            } else {
                if (this.first) {
                    this.first = false;
                    ((ClosureGeneratorData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                    ((ClosureGeneratorMeta)this.meta).getFields(((ClosureGeneratorData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    ((ClosureGeneratorData)this.data).parentIndex = this.getInputRowMeta().indexOfValue(((ClosureGeneratorMeta)this.meta).getParentIdFieldName());
                    if (((ClosureGeneratorData)this.data).parentIndex < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ClosureGenerator.Exception.ParentFieldNotFound", (String[])new String[0]));
                    }
                    ((ClosureGeneratorData)this.data).childIndex = this.getInputRowMeta().indexOfValue(((ClosureGeneratorMeta)this.meta).getChildIdFieldName());
                    if (((ClosureGeneratorData)this.data).childIndex < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ClosureGenerator.Exception.ChildFieldNotFound", (String[])new String[0]));
                    }
                    ((ClosureGeneratorData)this.data).parentValueMeta = this.getInputRowMeta().getValueMeta(((ClosureGeneratorData)this.data).parentIndex);
                    ((ClosureGeneratorData)this.data).childValueMeta = this.getInputRowMeta().getValueMeta(((ClosureGeneratorData)this.data).childIndex);
                }
                Object parentId = rowData[((ClosureGeneratorData)this.data).parentIndex];
                Object childId = rowData[((ClosureGeneratorData)this.data).childIndex];
                ((ClosureGeneratorData)this.data).map.put(childId, parentId);
            }
        } else {
            for (Object current : ((ClosureGeneratorData)this.data).map.keySet()) {
                ((ClosureGeneratorData)this.data).parents = new HashMap<Object, Long>();
                ((ClosureGeneratorData)this.data).parents.put(current, 0L);
                this.recurseParents(current, 1L);
                for (Object parent : ((ClosureGeneratorData)this.data).parents.keySet()) {
                    Object[] outputRow = RowDataUtil.allocateRowData((int)((ClosureGeneratorData)this.data).outputRowMeta.size());
                    outputRow[0] = parent;
                    outputRow[1] = current;
                    outputRow[2] = ((ClosureGeneratorData)this.data).parents.get(parent);
                    this.putRow(((ClosureGeneratorData)this.data).outputRowMeta, outputRow);
                }
            }
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void recurseParents(Object key, long distance) {
        if (distance > 50L) {
            throw new RuntimeException("infinite loop detected:" + key);
        }
        Object parent = ((ClosureGeneratorData)this.data).map.get(key);
        if (parent == null || parent == ((ClosureGeneratorData)this.data).topLevel || parent.equals(((ClosureGeneratorData)this.data).topLevel)) {
            return;
        }
        ((ClosureGeneratorData)this.data).parents.put(parent, distance);
        this.recurseParents(parent, distance + 1L);
    }

    public boolean init() {
        if (super.init()) {
            ((ClosureGeneratorData)this.data).reading = true;
            ((ClosureGeneratorData)this.data).map = new HashMap<Object, Object>();
            ((ClosureGeneratorData)this.data).topLevel = null;
            if (((ClosureGeneratorMeta)this.meta).isRootIdZero()) {
                ((ClosureGeneratorData)this.data).topLevel = 0L;
            }
            return true;
        }
        return false;
    }
}

