/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.output;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.parquet.transforms.output.ParquetField;
import org.apache.hop.parquet.transforms.output.ParquetWriteSupport;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.schema.MessageType;

public class ParquetWriterBuilder
extends ParquetWriter.Builder<RowMetaAndData, ParquetWriterBuilder> {
    private final MessageType messageType;
    private final List<Integer> sourceFieldIndexes;
    private final List<ParquetField> fields;

    protected ParquetWriterBuilder(MessageType messageType, OutputFile path, List<Integer> sourceFieldIndexes, List<ParquetField> fields) {
        super(path);
        this.messageType = messageType;
        this.sourceFieldIndexes = sourceFieldIndexes;
        this.fields = fields;
    }

    protected ParquetWriterBuilder self() {
        return this;
    }

    protected WriteSupport<RowMetaAndData> getWriteSupport(Configuration conf) {
        return new ParquetWriteSupport(this.messageType, this.sourceFieldIndexes, this.fields);
    }
}

