/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.output;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.parquet.transforms.output.ParquetField;
import org.apache.hop.parquet.transforms.output.ParquetOutput;
import org.apache.hop.parquet.transforms.output.ParquetOutputData;
import org.apache.hop.parquet.transforms.output.ParquetVersion;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

@Transform(id="ParquetFileOutput", image="parquet_output.svg", name="i18n::ParquetOutput.Name", description="i18n::ParquetOutput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", documentationUrl="/pipeline/transforms/parquet-file-output.html", keywords={"parquet", "write", "file", "column"})
public class ParquetOutputMeta
extends BaseTransformMeta
implements ITransformMeta<ParquetOutput, ParquetOutputData> {
    @HopMetadataProperty(key="filename_base")
    private String filenameBase;
    @HopMetadataProperty(key="filename_ext")
    private String filenameExtension;
    @HopMetadataProperty(key="filename_include_date")
    private boolean filenameIncludingDate;
    @HopMetadataProperty(key="filename_include_time")
    private boolean filenameIncludingTime;
    @HopMetadataProperty(key="filename_include_datetime")
    private boolean filenameIncludingDateTime;
    @HopMetadataProperty(key="filename_datetime_format")
    private String filenameDateTimeFormat;
    @HopMetadataProperty(key="filename_include_copy")
    private boolean filenameIncludingCopyNr;
    @HopMetadataProperty(key="filename_include_split")
    private boolean filenameIncludingSplitNr;
    @HopMetadataProperty(key="filename_split_size")
    private String fileSplitSize;
    @HopMetadataProperty(key="filename_create_parent_folders")
    private boolean filenameCreatingParentFolders;
    @HopMetadataProperty(key="compression_codec")
    private CompressionCodecName compressionCodec;
    @HopMetadataProperty(key="version", storeWithCode=true)
    private ParquetVersion version;
    @HopMetadataProperty(key="row_group_size")
    private String rowGroupSize;
    @HopMetadataProperty(key="data_page_size")
    private String dataPageSize;
    @HopMetadataProperty(key="dictionary_page_size")
    private String dictionaryPageSize;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<ParquetField> fields;

    public ParquetOutputMeta() {
        this.filenameExtension = "parquet";
        this.filenameDateTimeFormat = "yyyyMMdd-HHmmss";
        this.compressionCodec = CompressionCodecName.UNCOMPRESSED;
        this.version = ParquetVersion.Version1;
        this.rowGroupSize = Integer.toString(20000);
        this.dataPageSize = Integer.toString(0x100000);
        this.dictionaryPageSize = Integer.toString(0x100000);
        this.fields = new ArrayList<ParquetField>();
        this.filenameIncludingCopyNr = true;
        this.filenameIncludingSplitNr = true;
        this.filenameCreatingParentFolders = true;
        this.fileSplitSize = "1000000";
    }

    public ParquetOutputMeta(ParquetOutputMeta m) {
        this.filenameBase = m.filenameBase;
        this.filenameExtension = m.filenameExtension;
        this.filenameIncludingDate = m.filenameIncludingDate;
        this.filenameIncludingTime = m.filenameIncludingTime;
        this.filenameIncludingDateTime = m.filenameIncludingDateTime;
        this.filenameDateTimeFormat = m.filenameDateTimeFormat;
        this.filenameIncludingCopyNr = m.filenameIncludingCopyNr;
        this.filenameIncludingSplitNr = m.filenameIncludingSplitNr;
        this.fileSplitSize = m.fileSplitSize;
        this.filenameCreatingParentFolders = m.filenameCreatingParentFolders;
        this.compressionCodec = m.compressionCodec;
        this.version = m.version;
        this.rowGroupSize = m.rowGroupSize;
        this.dataPageSize = m.dataPageSize;
        this.dictionaryPageSize = m.dictionaryPageSize;
        this.fields = m.fields;
    }

    public ParquetOutputData getTransformData() {
        return new ParquetOutputData();
    }

    public ITransform createTransform(TransformMeta transformMeta, ParquetOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new ParquetOutput(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public String getFilenameBase() {
        return this.filenameBase;
    }

    public void setFilenameBase(String filenameBase) {
        this.filenameBase = filenameBase;
    }

    public String getFilenameExtension() {
        return this.filenameExtension;
    }

    public void setFilenameExtension(String filenameExtension) {
        this.filenameExtension = filenameExtension;
    }

    public boolean isFilenameIncludingDate() {
        return this.filenameIncludingDate;
    }

    public void setFilenameIncludingDate(boolean filenameIncludingDate) {
        this.filenameIncludingDate = filenameIncludingDate;
    }

    public boolean isFilenameIncludingTime() {
        return this.filenameIncludingTime;
    }

    public void setFilenameIncludingTime(boolean filenameIncludingTime) {
        this.filenameIncludingTime = filenameIncludingTime;
    }

    public boolean isFilenameIncludingDateTime() {
        return this.filenameIncludingDateTime;
    }

    public void setFilenameIncludingDateTime(boolean filenameIncludingDateTime) {
        this.filenameIncludingDateTime = filenameIncludingDateTime;
    }

    public String getFilenameDateTimeFormat() {
        return this.filenameDateTimeFormat;
    }

    public void setFilenameDateTimeFormat(String filenameDateTimeFormat) {
        this.filenameDateTimeFormat = filenameDateTimeFormat;
    }

    public boolean isFilenameIncludingCopyNr() {
        return this.filenameIncludingCopyNr;
    }

    public void setFilenameIncludingCopyNr(boolean filenameIncludingCopyNr) {
        this.filenameIncludingCopyNr = filenameIncludingCopyNr;
    }

    public boolean isFilenameIncludingSplitNr() {
        return this.filenameIncludingSplitNr;
    }

    public void setFilenameIncludingSplitNr(boolean filenameIncludingSplitNr) {
        this.filenameIncludingSplitNr = filenameIncludingSplitNr;
    }

    public String getFileSplitSize() {
        return this.fileSplitSize;
    }

    public void setFileSplitSize(String fileSplitSize) {
        this.fileSplitSize = fileSplitSize;
    }

    public boolean isFilenameCreatingParentFolders() {
        return this.filenameCreatingParentFolders;
    }

    public void setFilenameCreatingParentFolders(boolean filenameCreatingParentFolders) {
        this.filenameCreatingParentFolders = filenameCreatingParentFolders;
    }

    public CompressionCodecName getCompressionCodec() {
        return this.compressionCodec;
    }

    public void setCompressionCodec(CompressionCodecName compressionCodec) {
        this.compressionCodec = compressionCodec;
    }

    public ParquetVersion getVersion() {
        return this.version;
    }

    public void setVersion(ParquetVersion version) {
        this.version = version;
    }

    public String getRowGroupSize() {
        return this.rowGroupSize;
    }

    public void setRowGroupSize(String rowGroupSize) {
        this.rowGroupSize = rowGroupSize;
    }

    public String getDataPageSize() {
        return this.dataPageSize;
    }

    public void setDataPageSize(String dataPageSize) {
        this.dataPageSize = dataPageSize;
    }

    public String getDictionaryPageSize() {
        return this.dictionaryPageSize;
    }

    public void setDictionaryPageSize(String dictionaryPageSize) {
        this.dictionaryPageSize = dictionaryPageSize;
    }

    public List<ParquetField> getFields() {
        return this.fields;
    }

    public void setFields(List<ParquetField> fields) {
        this.fields = fields;
    }
}

