/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.output;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.vfs2.FileObject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.parquet.transforms.output.ParquetField;
import org.apache.hop.parquet.transforms.output.ParquetOutputData;
import org.apache.hop.parquet.transforms.output.ParquetOutputFile;
import org.apache.hop.parquet.transforms.output.ParquetOutputMeta;
import org.apache.hop.parquet.transforms.output.ParquetWriterBuilder;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetOutput
extends BaseTransform<ParquetOutputMeta, ParquetOutputData>
implements ITransform<ParquetOutputMeta, ParquetOutputData> {
    public ParquetOutput(TransformMeta transformMeta, ParquetOutputMeta meta, ParquetOutputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        ((ParquetOutputData)this.data).pageSize = Const.toInt((String)this.resolve(((ParquetOutputMeta)this.meta).getDataPageSize()), (int)0x100000);
        ((ParquetOutputData)this.data).dictionaryPageSize = Const.toInt((String)this.resolve(((ParquetOutputMeta)this.meta).getDictionaryPageSize()), (int)0x100000);
        ((ParquetOutputData)this.data).rowGroupSize = Const.toInt((String)this.resolve(((ParquetOutputMeta)this.meta).getRowGroupSize()), (int)20000);
        ((ParquetOutputData)this.data).maxSplitSizeRows = Const.toLong((String)this.resolve(((ParquetOutputMeta)this.meta).getFileSplitSize()), (long)-1L);
        return super.init();
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.closeFile();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((ParquetOutputData)this.data).sourceFieldIndexes = new ArrayList();
            for (int i = 0; i < ((ParquetOutputMeta)this.meta).getFields().size(); ++i) {
                ParquetField field = ((ParquetOutputMeta)this.meta).getFields().get(i);
                int index = this.getInputRowMeta().indexOfValue(field.getSourceFieldName());
                if (index < 0) {
                    throw new HopException("Unable to find source field '" + field.getSourceFieldName());
                }
                ((ParquetOutputData)this.data).sourceFieldIndexes.add(index);
            }
            this.openNewFile();
        }
        if (((ParquetOutputMeta)this.meta).isFilenameIncludingSplitNr() && ((ParquetOutputData)this.data).maxSplitSizeRows > 0L && ((ParquetOutputData)this.data).splitRowCount >= ((ParquetOutputData)this.data).maxSplitSizeRows) {
            this.closeFile();
            this.openNewFile();
        }
        try {
            ((ParquetOutputData)this.data).writer.write((Object)new RowMetaAndData(this.getInputRowMeta(), row));
            this.incrementLinesOutput();
            ++((ParquetOutputData)this.data).splitRowCount;
        }
        catch (Exception e) {
            throw new HopException("Error writing row to parquet file", (Throwable)e);
        }
        this.putRow(this.getInputRowMeta(), row);
        return true;
    }

    private void openNewFile() throws HopException {
        ((ParquetOutputData)this.data).splitRowCount = 0L;
        ++((ParquetOutputData)this.data).split;
        ((ParquetOutputData)this.data).conf = new Configuration();
        ParquetProperties.Builder builder = ParquetProperties.builder();
        switch (((ParquetOutputMeta)this.meta).getVersion()) {
            case Version1: {
                builder = builder.withWriterVersion(ParquetProperties.WriterVersion.PARQUET_1_0);
                break;
            }
            case Version2: {
                builder = builder.withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0);
            }
        }
        ((ParquetOutputData)this.data).props = builder.build();
        ArrayList<PrimitiveType> types = new ArrayList<PrimitiveType>();
        for (int i = 0; i < ((ParquetOutputMeta)this.meta).getFields().size(); ++i) {
            ParquetField field = ((ParquetOutputMeta)this.meta).getFields().get(i);
            IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(((ParquetOutputData)this.data).sourceFieldIndexes.get(i).intValue());
            PrimitiveType.PrimitiveTypeName typeName = PrimitiveType.PrimitiveTypeName.BINARY;
            switch (valueMeta.getType()) {
                case 3: 
                case 5: {
                    typeName = PrimitiveType.PrimitiveTypeName.INT64;
                    break;
                }
                case 1: {
                    typeName = PrimitiveType.PrimitiveTypeName.DOUBLE;
                    break;
                }
                case 4: {
                    typeName = PrimitiveType.PrimitiveTypeName.BOOLEAN;
                    break;
                }
                case 8: {
                    typeName = PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
                }
            }
            PrimitiveType type = new PrimitiveType(Type.Repetition.REQUIRED, typeName, field.getTargetFieldName());
            types.add(type);
        }
        MessageType messageType = new MessageType("HopParquetSchema", types);
        ((ParquetOutputData)this.data).filename = this.buildFilename(this.getPipeline().getExecutionStartDate());
        try {
            FileObject parentFolder;
            FileObject fileObject = HopVfs.getFileObject((String)((ParquetOutputData)this.data).filename);
            if (((ParquetOutputMeta)this.meta).isFilenameCreatingParentFolders() && (parentFolder = fileObject.getParent()) != null && !parentFolder.exists()) {
                parentFolder.createFolder();
            }
            ((ParquetOutputData)this.data).outputStream = HopVfs.getOutputStream((String)((ParquetOutputData)this.data).filename, (boolean)false);
            ((ParquetOutputData)this.data).outputFile = new ParquetOutputFile(((ParquetOutputData)this.data).outputStream);
            ((ParquetOutputData)this.data).writer = ((ParquetWriterBuilder)((ParquetWriterBuilder)((ParquetWriterBuilder)((ParquetWriterBuilder)((ParquetWriterBuilder)((ParquetWriterBuilder)((ParquetWriterBuilder)new ParquetWriterBuilder(messageType, ((ParquetOutputData)this.data).outputFile, ((ParquetOutputData)this.data).sourceFieldIndexes, ((ParquetOutputMeta)this.meta).getFields()).withPageSize(((ParquetOutputData)this.data).pageSize)).withDictionaryPageSize(((ParquetOutputData)this.data).dictionaryPageSize)).withValidation(false)).withCompressionCodec(((ParquetOutputMeta)this.meta).getCompressionCodec())).withRowGroupSize(((ParquetOutputData)this.data).rowGroupSize)).withWriterVersion(((ParquetOutputData)this.data).props.getWriterVersion())).withWriteMode(ParquetFileWriter.Mode.CREATE)).build();
        }
        catch (Exception e) {
            throw new HopException("Unable to create output file '" + ((ParquetOutputData)this.data).filename + "'", (Throwable)e);
        }
    }

    private String buildFilename(Date date) {
        String filename = this.resolve(((ParquetOutputMeta)this.meta).getFilenameBase());
        if (((ParquetOutputMeta)this.meta).isFilenameIncludingDate()) {
            filename = filename + "-" + new SimpleDateFormat("yyyyMMdd").format(date);
        }
        if (((ParquetOutputMeta)this.meta).isFilenameIncludingTime()) {
            filename = filename + "-" + new SimpleDateFormat("HHmmss").format(date);
        }
        if (((ParquetOutputMeta)this.meta).isFilenameIncludingDateTime()) {
            filename = filename + "-" + new SimpleDateFormat(this.resolve(((ParquetOutputMeta)this.meta).getFilenameDateTimeFormat())).format(date);
        }
        if (((ParquetOutputMeta)this.meta).isFilenameIncludingCopyNr()) {
            filename = filename + "-" + new DecimalFormat("00").format(this.getCopyNr());
        }
        if (((ParquetOutputMeta)this.meta).isFilenameIncludingSplitNr()) {
            filename = filename + "-" + new DecimalFormat("0000").format(((ParquetOutputData)this.data).split);
        }
        filename = filename + "." + Const.NVL((String)this.resolve(((ParquetOutputMeta)this.meta).getFilenameExtension()), (String)"parquet");
        filename = filename + ((ParquetOutputMeta)this.meta).getCompressionCodec().getExtension();
        return filename;
    }

    private void closeFile() throws HopException {
        try {
            ((ParquetOutputData)this.data).writer.close();
        }
        catch (Exception e) {
            throw new HopException("Error closing file " + ((ParquetOutputData)this.data).filename, (Throwable)e);
        }
    }
}

