/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.input;

import java.util.List;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.parquet.transforms.input.ParquetField;
import org.apache.hop.parquet.transforms.input.ParquetValueConverter;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.MessageType;

public class ParquetRowConverter
extends GroupConverter {
    private final MessageType messageType;
    private RowMetaAndData group;
    private IRowMeta rowMeta;
    private List<ParquetField> fields;

    public ParquetRowConverter(MessageType messageType, IRowMeta rowMeta, List<ParquetField> fields) {
        this.messageType = messageType;
        this.group = new RowMetaAndData(rowMeta, null);
        this.rowMeta = rowMeta;
        this.fields = fields;
    }

    public Converter getConverter(int schemaIndex) {
        String sourceField = this.messageType.getFieldName(schemaIndex);
        int rowIndex = -1;
        for (int i = 0; i < this.fields.size(); ++i) {
            ParquetField field = this.fields.get(i);
            if (!field.getSourceField().equalsIgnoreCase(sourceField)) continue;
            rowIndex = i;
            break;
        }
        return new ParquetValueConverter(this.group, rowIndex);
    }

    public void start() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.rowMeta.size());
        this.group.setData(rowData);
    }

    public void end() {
    }

    public RowMetaAndData getGroup() {
        return this.group;
    }
}

