/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.input;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.parquet.transforms.input.ParquetField;
import org.apache.hop.parquet.transforms.input.ParquetInputMeta;
import org.apache.hop.parquet.transforms.input.ParquetReadSupport;
import org.apache.hop.parquet.transforms.input.ParquetReaderBuilder;
import org.apache.hop.parquet.transforms.input.ParquetStream;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ParquetInputDialog
extends BaseTransformDialog
implements ITransformDialog {
    public static final Class<?> PKG = ParquetInputMeta.class;
    protected ParquetInputMeta input;
    private Combo wFilenameField;
    private TableView wFields;
    private String returnValue;

    public ParquetInputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String transformName) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, transformName);
        this.input = (ParquetInputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ParquetInput.Name", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.getFields());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ParquetInputDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlFilenameField = new Label((Composite)this.shell, 131072);
        wlFilenameField.setText(BaseMessages.getString(PKG, (String)"ParquetInputDialog.FilenameField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFilenameField);
        FormData fdlFilenameField = new FormData();
        fdlFilenameField.left = new FormAttachment(0, 0);
        fdlFilenameField.right = new FormAttachment(middle, -margin);
        fdlFilenameField.top = new FormAttachment((Control)lastControl, margin);
        wlFilenameField.setLayoutData((Object)fdlFilenameField);
        this.wFilenameField = new Combo((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFilenameField);
        FormData fdFilenameField = new FormData();
        fdFilenameField.left = new FormAttachment(middle, 0);
        fdFilenameField.top = new FormAttachment((Control)wlFilenameField, 0, 0x1000000);
        fdFilenameField.right = new FormAttachment(100, 0);
        this.wFilenameField.setLayoutData((Object)fdFilenameField);
        lastControl = this.wFilenameField;
        Label wlFields = new Label((Composite)this.shell, 16384);
        wlFields.setText(BaseMessages.getString(PKG, (String)"ParquetInputDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.right = new FormAttachment(middle, -margin);
        fdlFields.top = new FormAttachment((Control)lastControl, margin);
        wlFields.setLayoutData((Object)fdlFields);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetInputDialog.FieldsColumn.SourceField.Label", (String[])new String[0]), 1, new String[0]), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetInputDialog.FieldsColumn.TargetField.Label", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetInputDialog.FieldsColumn.TargetType.Label", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetInputDialog.FieldsColumn.TargetFormat.Label", (String[])new String[0]), 2, Const.getDateFormats(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetInputDialog.FieldsColumn.TargetLength.Label", (String[])new String[0]), 1, true, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ParquetInputDialog.FieldsColumn.TargetPrecision.Label", (String[])new String[0]), 1, true, false)};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 2048, columns, this.input.getFields().size(), false, null, this.props);
        this.props.setLook((Control)this.wFields);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.returnValue;
    }

    private void getFields() {
        try {
            String filename = BaseDialog.presentFileDialog((Shell)this.shell, (String[])new String[]{"*.parquet*", "*.*"}, (String[])new String[]{"Parquet files", "All files"}, (boolean)true);
            if (filename != null) {
                FileObject fileObject = HopVfs.getFileObject((String)filename);
                long size = fileObject.getContent().getSize();
                InputStream inputStream = HopVfs.getInputStream((FileObject)fileObject);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream((int)size);
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                ParquetStream inputFile = new ParquetStream(outputStream.toByteArray(), filename);
                ParquetReadSupport readSupport = new ParquetReadSupport(new ArrayList<ParquetField>());
                ParquetReader reader = new ParquetReaderBuilder<RowMetaAndData>(readSupport, inputFile).build();
                reader.read();
                MessageType schema = readSupport.getMessageType();
                RowMeta rowMeta = new RowMeta();
                List columns = schema.getColumns();
                for (ColumnDescriptor column : columns) {
                    String sourceField = "";
                    String[] path = column.getPath();
                    if (path.length == 1) {
                        sourceField = path[0];
                    } else {
                        for (int i = 0; i < path.length; ++i) {
                            if (i > 0) {
                                sourceField = sourceField + ".";
                            }
                            sourceField = sourceField + path[i];
                        }
                    }
                    PrimitiveType primitiveType = column.getPrimitiveType();
                    int hopType = 2;
                    switch (primitiveType.getPrimitiveTypeName()) {
                        case INT32: 
                        case INT64: {
                            hopType = 5;
                            break;
                        }
                        case INT96: {
                            hopType = 8;
                            break;
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            hopType = 1;
                            break;
                        }
                        case BOOLEAN: {
                            hopType = 4;
                        }
                    }
                    IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)sourceField, (int)hopType, (int)-1, (int)-1);
                    rowMeta.addValueMeta(valueMeta);
                }
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)rowMeta, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[]{3}, (int)-1, (int)-1, null);
            }
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting parquet file fields", (Throwable)e);
        }
    }

    private void getData() {
        try {
            this.wFilenameField.setItems(this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName).getFieldNames());
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting source fields", (Throwable)e);
        }
        this.wTransformName.setText(Const.NVL((String)this.transformName, (String)""));
        this.wFilenameField.setText(Const.NVL((String)this.input.getFilenameField(), (String)""));
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            ParquetField field = this.input.getFields().get(i);
            TableItem item = this.wFields.table.getItem(i);
            int index = 1;
            item.setText(index++, Const.NVL((String)field.getSourceField(), (String)""));
            item.setText(index++, Const.NVL((String)field.getTargetField(), (String)""));
            item.setText(index++, Const.NVL((String)field.getTargetType(), (String)""));
            item.setText(index++, Const.NVL((String)field.getTargetFormat(), (String)""));
            item.setText(index++, Const.NVL((String)field.getTargetLength(), (String)""));
            item.setText(index++, Const.NVL((String)field.getTargetPrecision(), (String)""));
        }
    }

    private void ok() {
        this.returnValue = this.wTransformName.getText();
        this.getInfo(this.input);
        this.input.setChanged();
        this.dispose();
    }

    private void getInfo(ParquetInputMeta meta) {
        meta.setFilenameField(this.wFilenameField.getText());
        meta.getFields().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            int index = 1;
            meta.getFields().add(new ParquetField(item.getText(index++), item.getText(index++), item.getText(index++), item.getText(index++), item.getText(index++), item.getText(index)));
        }
    }

    private void cancel() {
        this.returnValue = null;
        this.dispose();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }
}

