/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.www.service;

import java.util.List;
import org.apache.hop.core.action.GuiContextAction;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.context.HopGuiPipelineTransformContext;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;
import org.apache.hop.ui.www.service.WebServiceEditor;
import org.apache.hop.www.service.WebService;
import org.eclipse.swt.widgets.MessageBox;

@GuiPlugin
public class WebServiceGuiPlugin {
    @GuiContextAction(id="pipeline-graph-transform-9000-add-web-serviec", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Info, name="Add web service", tooltip="Use the output of this transform as a web service with Hop Server", image="ui/images/webservice.svg", category="Data routing", categoryOrder="2")
    public void addWebServiceForTransform(HopGuiPipelineTransformContext context) {
        PipelineMeta pipelineMeta = context.getPipelineMeta();
        TransformMeta transformMeta = context.getTransformMeta();
        IVariables variables = context.getPipelineGraph().getVariables();
        HopGui hopGui = HopGui.getInstance();
        try {
            IRowMeta fields = pipelineMeta.getTransformFields(variables, transformMeta);
            EnterSelectionDialog fieldSelectionDialog = new EnterSelectionDialog(hopGui.getShell(), fields.getFieldNames(), "Select the output field", "Please select the field to output when the service is called");
            String fieldName = fieldSelectionDialog.open();
            if (fieldName == null) {
                return;
            }
            IHopMetadataProvider metadataProvider = hopGui.getMetadataProvider();
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(WebService.class);
            MetadataManager<WebService> manager = new MetadataManager<WebService>(hopGui.getVariables(), metadataProvider, WebService.class);
            WebService webService = null;
            List serviceNames = serializer.listObjectNames();
            if (serviceNames.isEmpty()) {
                MessageBox box = new MessageBox(hopGui.getShell(), 196);
                box.setText("No web services available");
                box.setMessage("There are no web service objects defined yet.  Do you want to create one?");
                int answer = box.open();
                if ((answer & 0x40) != 0) {
                    webService = new WebService(pipelineMeta.getName(), true, pipelineMeta.getFilename(), transformMeta.getName(), fieldName, "text/plain", false);
                    manager.newMetadata(webService);
                    return;
                }
                return;
            }
            EnterSelectionDialog dialog = new EnterSelectionDialog(hopGui.getShell(), serviceNames.toArray(new String[0]), "Select a web service", "Select the web service to update");
            String pipelineProbeName = dialog.open();
            if (pipelineProbeName != null) {
                webService = (WebService)serializer.load(pipelineProbeName);
            }
            if (webService != null) {
                String key;
                MetadataPerspective perspective = (MetadataPerspective)hopGui.getPerspectiveManager().findPerspective(MetadataPerspective.class);
                WebServiceEditor editor = (WebServiceEditor)perspective.findEditor(key = WebService.class.getAnnotation(HopMetadata.class).key(), webService.getName());
                if (editor != null) {
                    webService = new WebService();
                    editor.getWidgetsContent(webService);
                    webService.setFilename(pipelineMeta.getFilename());
                    webService.setTransformName(transformMeta.getName());
                    webService.setFieldName(fieldName);
                    editor.setMetadata(webService);
                    editor.setWidgetsContent();
                    editor.setChanged();
                    perspective.activate();
                    perspective.setActiveEditor(editor);
                    return;
                }
                webService.setFilename(pipelineMeta.getFilename());
                webService.setTransformName(transformMeta.getName());
                webService.setFieldName(fieldName);
                serializer.save((IHopMetadata)webService);
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), "Error", "Error adding web service for transform '" + transformMeta.getName() + "'", e);
        }
    }
}

