/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.pipeline.transform.common;

import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.file.EncodingType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.i18n.BaseMessages;

public class TextFileLineUtil {
    private static final Class<?> PKG = TextFileLineUtil.class;
    public static final int FILE_FORMAT_DOS = 0;
    public static final int FILE_FORMAT_UNIX = 1;
    public static final int FILE_FORMAT_MIXED = 2;
    public static final int FILE_TYPE_CSV = 0;
    public static final int FILE_TYPE_FIXED = 1;

    public static final String getLine(ILogChannel log, InputStreamReader reader, int formatNr, StringBuilder line) throws HopFileException {
        EncodingType type = EncodingType.guessEncodingType((String)reader.getEncoding());
        return TextFileLineUtil.getLine(log, reader, type, formatNr, line);
    }

    public static final String getLine(ILogChannel log, InputStreamReader reader, EncodingType encodingType, int formatNr, StringBuilder line) throws HopFileException {
        int c = 0;
        line.setLength(0);
        try {
            switch (formatNr) {
                case 0: {
                    while (c >= 0) {
                        c = reader.read();
                        if (encodingType.isReturn(c) || encodingType.isLinefeed(c)) {
                            c = reader.read();
                            if (!encodingType.isReturn(c) && !encodingType.isLinefeed(c)) {
                                throw new HopFileException(BaseMessages.getString(PKG, (String)"TextFileLineUtil.Log.SingleLineFound", (String[])new String[0]));
                            }
                            return line.toString();
                        }
                        if (c < 0) continue;
                        line.append((char)c);
                    }
                    break;
                }
                case 1: {
                    while (c >= 0) {
                        c = reader.read();
                        if (encodingType.isLinefeed(c) || encodingType.isReturn(c)) {
                            return line.toString();
                        }
                        if (c < 0) continue;
                        line.append((char)c);
                    }
                    break;
                }
                case 2: {
                    while (c >= 0) {
                        c = reader.read();
                        if (encodingType.isLinefeed(c)) {
                            return line.toString();
                        }
                        if (encodingType.isReturn(c) || c < 0) continue;
                        line.append((char)c);
                    }
                    break;
                }
            }
        }
        catch (HopFileException e) {
            throw e;
        }
        catch (Exception e) {
            if (line.length() == 0) {
                throw new HopFileException(BaseMessages.getString(PKG, (String)"TextFileLineUtil.Log.Error.ExceptionReadingLine", (String[])new String[]{e.toString()}), (Throwable)e);
            }
            return line.toString();
        }
        if (line.length() > 0) {
            return line.toString();
        }
        return null;
    }

    public static String[] guessStringsFromLine(ILogChannel log, String line, String delimiter, String enclosure, String escapeCharacter) throws HopException {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            int lenEsc;
            if (line == null) {
                return null;
            }
            int pos = 0;
            int length = line.length();
            boolean dencl = false;
            int len_encl = enclosure == null ? 0 : enclosure.length();
            int n = lenEsc = escapeCharacter == null ? 0 : escapeCharacter.length();
            while (pos < length) {
                String pol;
                int next;
                boolean encl_found;
                int from = pos;
                boolean containsEscaped_enclosures = false;
                boolean containsEscapedSeparators = false;
                if (len_encl > 0 && line.substring(from, from + len_encl).equalsIgnoreCase(enclosure)) {
                    String strnext;
                    if (log.isRowLevel()) {
                        log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileLineUtil.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileLineUtil.Log.ConvertLineToRow", (String[])new String[]{line.substring(from, from + len_encl)})});
                    }
                    encl_found = true;
                    int p = from + len_encl;
                    boolean is_enclosure = len_encl > 0 && p + len_encl < length && line.substring(p, p + len_encl).equalsIgnoreCase(enclosure);
                    boolean isEscape = lenEsc > 0 && p + lenEsc < length && line.substring(p, p + lenEsc).equalsIgnoreCase(escapeCharacter);
                    boolean enclosure_after = false;
                    if ((is_enclosure || isEscape) && p < length - 1 && (strnext = line.substring(p + len_encl, p + 2 * len_encl)).equalsIgnoreCase(enclosure)) {
                        ++p;
                        enclosure_after = true;
                        dencl = true;
                        if (isEscape) {
                            containsEscaped_enclosures = true;
                        }
                    }
                    while ((!is_enclosure || enclosure_after) && p < line.length()) {
                        enclosure_after = false;
                        is_enclosure = len_encl > 0 && ++p + len_encl < length && line.substring(p, p + len_encl).equals(enclosure);
                        boolean bl = isEscape = lenEsc > 0 && p + lenEsc < length && line.substring(p, p + lenEsc).equals(escapeCharacter);
                        if (!is_enclosure && !isEscape || p >= length - 1 || !(strnext = line.substring(p + len_encl, p + 2 * len_encl)).equals(enclosure)) continue;
                        ++p;
                        enclosure_after = true;
                        dencl = true;
                        if (!isEscape) continue;
                        containsEscaped_enclosures = true;
                    }
                    next = p >= length ? p : p + len_encl;
                    if (log.isRowLevel()) {
                        log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileLineUtil.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileLineUtil.Log.EndOfEnclosure", (String[])new String[]{"" + p})});
                    }
                } else {
                    encl_found = false;
                    boolean found = false;
                    int startpoint = from;
                    do {
                        next = line.indexOf(delimiter, startpoint);
                        if (lenEsc > 0 && next - lenEsc > 0) {
                            String before = line.substring(next - lenEsc, next);
                            if (escapeCharacter != null && escapeCharacter.equals(before)) {
                                startpoint = next + 1;
                                containsEscapedSeparators = true;
                                continue;
                            }
                            found = true;
                            continue;
                        }
                        found = true;
                    } while (!found && next >= 0);
                }
                if (next == -1) {
                    next = length;
                }
                if (encl_found) {
                    pol = line.substring(from + len_encl, next - len_encl);
                    if (log.isRowLevel()) {
                        log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileLineUtil.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileLineUtil.Log.EnclosureFieldFound", (String[])new String[]{"" + pol})});
                    }
                } else {
                    pol = line.substring(from, next);
                    if (log.isRowLevel()) {
                        log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileLineUtil.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileLineUtil.Log.NormalFieldFound", (String[])new String[]{"" + pol})});
                    }
                }
                if (dencl) {
                    StringBuilder sbpol = new StringBuilder(pol);
                    int idx = sbpol.indexOf(enclosure + enclosure);
                    while (idx >= 0) {
                        sbpol.delete(idx, idx + (enclosure == null ? 0 : enclosure.length()));
                        idx = sbpol.indexOf(enclosure + enclosure);
                    }
                    pol = sbpol.toString();
                }
                if (containsEscaped_enclosures) {
                    String replace = escapeCharacter + enclosure;
                    pol = Const.replace((String)pol, (String)replace, (String)enclosure);
                }
                if (containsEscapedSeparators) {
                    String replace = escapeCharacter + delimiter;
                    pol = Const.replace((String)pol, (String)replace, (String)delimiter);
                }
                strings.add(pol);
                pos = next + delimiter.length();
            }
            if (pos == length) {
                if (log.isRowLevel()) {
                    log.logRowlevel(BaseMessages.getString(PKG, (String)"TextFileLineUtil.Log.ConvertLineToRowTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"TextFileLineUtil.Log.EndOfEmptyLineFound", (String[])new String[0])});
                }
                strings.add("");
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"TextFileLineUtil.Log.Error.ErrorConvertingLine", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        return strings.toArray(new String[strings.size()]);
    }
}

