/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.pipeline.transform;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.TransformErrorMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TransformErrorMetaDialog
extends Dialog {
    private static final Class<?> PKG = ITransform.class;
    private final IVariables variables;
    private TransformErrorMeta transformErrorMeta;
    private List<TransformMeta> targetTransforms;
    private Composite composite;
    private Shell shell;
    private Text wSourceTransform;
    private CCombo wTargetTransform;
    private Button wEnabled;
    private TextVar wNrErrors;
    private TextVar wErrDesc;
    private TextVar wErrFields;
    private TextVar wErrCodes;
    private TextVar wMaxErrors;
    private TextVar wMaxPct;
    private TextVar wMinPctRows;
    private Button wOk;
    private Button wCancel;
    private ModifyListener lsMod;
    private PropsUi props;
    private int middle;
    private int margin;
    private TransformErrorMeta originalTransformErrorMeta;
    private boolean ok;
    private PipelineMeta pipelineMeta;

    public TransformErrorMetaDialog(Shell par, IVariables variables, TransformErrorMeta transformErrorMeta, PipelineMeta pipelineMeta, List<TransformMeta> targetTransforms) {
        super(par, 0);
        this.variables = variables;
        this.transformErrorMeta = transformErrorMeta.clone();
        this.originalTransformErrorMeta = transformErrorMeta;
        this.targetTransforms = targetTransforms;
        this.pipelineMeta = pipelineMeta;
        this.props = PropsUi.getInstance();
        this.ok = false;
    }

    public boolean open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.lsMod = e -> this.transformErrorMeta.setChanged();
        this.middle = this.props.getMiddlePct();
        this.margin = this.props.getMargin();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setText(BaseMessages.getString(PKG, (String)"BaseTransformDialog.ErrorHandling.Title.Label", (String[])new String[0]));
        this.shell.setImage(GuiResource.getInstance().getImagePipeline());
        this.shell.setLayout((Layout)formLayout);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(" &OK ");
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(" &Cancel ");
        Button[] buttons = new Button[]{this.wOk, this.wCancel};
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, buttons, this.margin, null);
        this.composite = new Composite((Composite)this.shell, 0);
        this.props.setLook((Control)this.composite);
        this.composite.setLayout((Layout)new FormLayout());
        Label wlSourceTransform = new Label(this.composite, 131072);
        this.props.setLook((Control)wlSourceTransform);
        wlSourceTransform.setText(BaseMessages.getString(PKG, (String)"BaseTransformDialog.ErrorHandling.TransformName.Label", (String[])new String[0]));
        FormData fdlSourceTransform = new FormData();
        fdlSourceTransform.top = new FormAttachment(0, 0);
        fdlSourceTransform.left = new FormAttachment(0, 0);
        fdlSourceTransform.right = new FormAttachment(this.middle, -this.margin);
        wlSourceTransform.setLayoutData((Object)fdlSourceTransform);
        this.wSourceTransform = new Text(this.composite, 18436);
        this.props.setLook((Control)this.wSourceTransform);
        this.wSourceTransform.addModifyListener(this.lsMod);
        FormData fdSourceTransform = new FormData();
        fdSourceTransform.top = new FormAttachment(0, 0);
        fdSourceTransform.left = new FormAttachment(this.middle, 0);
        fdSourceTransform.right = new FormAttachment(95, 0);
        this.wSourceTransform.setLayoutData((Object)fdSourceTransform);
        this.wSourceTransform.setEnabled(false);
        Label wlTargetTransform = new Label(this.composite, 131072);
        this.props.setLook((Control)wlTargetTransform);
        wlTargetTransform.setText(BaseMessages.getString(PKG, (String)"BaseTransformDialog.ErrorHandling.TargetTransform.Label", (String[])new String[0]));
        FormData fdlTargetTransform = new FormData();
        fdlTargetTransform.top = new FormAttachment((Control)this.wSourceTransform, this.margin);
        fdlTargetTransform.left = new FormAttachment(0, 0);
        fdlTargetTransform.right = new FormAttachment(this.middle, -this.margin);
        wlTargetTransform.setLayoutData((Object)fdlTargetTransform);
        this.wTargetTransform = new CCombo(this.composite, 18436);
        this.props.setLook((Control)this.wTargetTransform);
        this.wTargetTransform.addModifyListener(this.lsMod);
        FormData fdTargetTransform = new FormData();
        fdTargetTransform.top = new FormAttachment((Control)this.wSourceTransform, this.margin);
        fdTargetTransform.left = new FormAttachment(this.middle, 0);
        fdTargetTransform.right = new FormAttachment(95, 0);
        this.wTargetTransform.setLayoutData((Object)fdTargetTransform);
        for (int i = 0; i < this.targetTransforms.size(); ++i) {
            this.wTargetTransform.add(this.targetTransforms.get(i).getName());
        }
        Label wlEnabled = new Label(this.composite, 131072);
        this.props.setLook((Control)wlEnabled);
        wlEnabled.setText(BaseMessages.getString(PKG, (String)"BaseTransformDialog.ErrorHandling.Enable.Label", (String[])new String[0]));
        FormData fdlEnabled = new FormData();
        fdlEnabled.top = new FormAttachment((Control)this.wTargetTransform, this.margin);
        fdlEnabled.left = new FormAttachment(0, 0);
        fdlEnabled.right = new FormAttachment(this.middle, -this.margin);
        wlEnabled.setLayoutData((Object)fdlEnabled);
        this.wEnabled = new Button(this.composite, 32);
        this.props.setLook((Control)this.wEnabled);
        FormData fdEnabled = new FormData();
        fdEnabled.top = new FormAttachment((Control)this.wTargetTransform, this.margin);
        fdEnabled.left = new FormAttachment(this.middle, 0);
        this.wEnabled.setLayoutData((Object)fdEnabled);
        Label wlNrErrors = new Label(this.composite, 131072);
        this.props.setLook((Control)wlNrErrors);
        wlNrErrors.setText(BaseMessages.getString(PKG, (String)"BaseTransformDialog.ErrorHandling.NrErrField.Label", (String[])new String[0]));
        FormData fdlNrErrors = new FormData();
        fdlNrErrors.top = new FormAttachment((Control)this.wEnabled, this.margin * 2);
        fdlNrErrors.left = new FormAttachment(0, 0);
        fdlNrErrors.right = new FormAttachment(this.middle, -this.margin);
        wlNrErrors.setLayoutData((Object)fdlNrErrors);
        this.wNrErrors = new TextVar(this.variables, this.composite, 18436);
        this.props.setLook((Control)this.wNrErrors);
        this.wNrErrors.addModifyListener(this.lsMod);
        FormData fdNrErrors = new FormData();
        fdNrErrors.top = new FormAttachment((Control)this.wEnabled, this.margin * 2);
        fdNrErrors.left = new FormAttachment(this.middle, 0);
        fdNrErrors.right = new FormAttachment(95, 0);
        this.wNrErrors.setLayoutData(fdNrErrors);
        Label wlErrDesc = new Label(this.composite, 131072);
        this.props.setLook((Control)wlErrDesc);
        wlErrDesc.setText(BaseMessages.getString(PKG, (String)"BaseTransformDialog.ErrorHandling.ErrDescField.Label", (String[])new String[0]));
        FormData fdlErrDesc = new FormData();
        fdlErrDesc.top = new FormAttachment((Control)this.wNrErrors, this.margin);
        fdlErrDesc.left = new FormAttachment(0, 0);
        fdlErrDesc.right = new FormAttachment(this.middle, -this.margin);
        wlErrDesc.setLayoutData((Object)fdlErrDesc);
        this.wErrDesc = new TextVar(this.variables, this.composite, 18436);
        this.props.setLook((Control)this.wErrDesc);
        this.wErrDesc.addModifyListener(this.lsMod);
        FormData fdErrDesc = new FormData();
        fdErrDesc.top = new FormAttachment((Control)this.wNrErrors, this.margin);
        fdErrDesc.left = new FormAttachment(this.middle, 0);
        fdErrDesc.right = new FormAttachment(95, 0);
        this.wErrDesc.setLayoutData(fdErrDesc);
        Label wlErrFields = new Label(this.composite, 131072);
        wlErrFields.setText(BaseMessages.getString(PKG, (String)"BaseTransformDialog.ErrorHandling.ErrFieldName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlErrFields);
        FormData fdlErrFields = new FormData();
        fdlErrFields.top = new FormAttachment((Control)this.wErrDesc, this.margin);
        fdlErrFields.left = new FormAttachment(0, 0);
        fdlErrFields.right = new FormAttachment(this.middle, -this.margin);
        wlErrFields.setLayoutData((Object)fdlErrFields);
        this.wErrFields = new TextVar(this.variables, this.composite, 18436);
        this.props.setLook((Control)this.wErrFields);
        this.wErrFields.addModifyListener(this.lsMod);
        FormData fdErrFields = new FormData();
        fdErrFields.top = new FormAttachment((Control)this.wErrDesc, this.margin);
        fdErrFields.left = new FormAttachment(this.middle, 0);
        fdErrFields.right = new FormAttachment(95, 0);
        this.wErrFields.setLayoutData(fdErrFields);
        Label wlErrCodes = new Label(this.composite, 131072);
        wlErrCodes.setText(BaseMessages.getString(PKG, (String)"BaseTransformDialog.ErrorHandling.ErrCodeFieldName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlErrCodes);
        FormData fdlErrCodes = new FormData();
        fdlErrCodes.top = new FormAttachment((Control)this.wErrFields, this.margin);
        fdlErrCodes.left = new FormAttachment(0, 0);
        fdlErrCodes.right = new FormAttachment(this.middle, -this.margin);
        wlErrCodes.setLayoutData((Object)fdlErrCodes);
        this.wErrCodes = new TextVar(this.variables, this.composite, 18436);
        this.props.setLook((Control)this.wErrCodes);
        this.wErrCodes.addModifyListener(this.lsMod);
        FormData fdErrCodes = new FormData();
        fdErrCodes.top = new FormAttachment((Control)this.wErrFields, this.margin);
        fdErrCodes.left = new FormAttachment(this.middle, 0);
        fdErrCodes.right = new FormAttachment(95, 0);
        this.wErrCodes.setLayoutData(fdErrCodes);
        Label wlMaxErrors = new Label(this.composite, 131072);
        wlMaxErrors.setText(BaseMessages.getString(PKG, (String)"BaseTransformDialog.ErrorHandling.MaxErr.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMaxErrors);
        FormData fdlMaxErrors = new FormData();
        fdlMaxErrors.top = new FormAttachment((Control)this.wErrCodes, this.margin);
        fdlMaxErrors.left = new FormAttachment(0, 0);
        fdlMaxErrors.right = new FormAttachment(this.middle, -this.margin);
        wlMaxErrors.setLayoutData((Object)fdlMaxErrors);
        this.wMaxErrors = new TextVar(this.variables, this.composite, 18436);
        this.props.setLook((Control)this.wMaxErrors);
        this.wMaxErrors.addModifyListener(this.lsMod);
        FormData fdMaxErrors = new FormData();
        fdMaxErrors.top = new FormAttachment((Control)this.wErrCodes, this.margin);
        fdMaxErrors.left = new FormAttachment(this.middle, 0);
        fdMaxErrors.right = new FormAttachment(95, 0);
        this.wMaxErrors.setLayoutData(fdMaxErrors);
        Label wlMaxPct = new Label(this.composite, 131072);
        wlMaxPct.setText(BaseMessages.getString(PKG, (String)"BaseTransformDialog.ErrorHandling.MaxPctErr.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMaxPct);
        FormData fdlMaxPct = new FormData();
        fdlMaxPct.top = new FormAttachment((Control)this.wMaxErrors, this.margin);
        fdlMaxPct.left = new FormAttachment(0, 0);
        fdlMaxPct.right = new FormAttachment(this.middle, -this.margin);
        wlMaxPct.setLayoutData((Object)fdlMaxPct);
        this.wMaxPct = new TextVar(this.variables, this.composite, 18436);
        this.props.setLook((Control)this.wMaxPct);
        this.wMaxPct.addModifyListener(this.lsMod);
        FormData fdMaxPct = new FormData();
        fdMaxPct.top = new FormAttachment((Control)this.wMaxErrors, this.margin);
        fdMaxPct.left = new FormAttachment(this.middle, 0);
        fdMaxPct.right = new FormAttachment(95, 0);
        this.wMaxPct.setLayoutData(fdMaxPct);
        Label wlMinPctRows = new Label(this.composite, 131072);
        wlMinPctRows.setText(BaseMessages.getString(PKG, (String)"BaseTransformDialog.ErrorHandling.MinErr.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMinPctRows);
        FormData fdlMinPctRows = new FormData();
        fdlMinPctRows.top = new FormAttachment((Control)this.wMaxPct, this.margin);
        fdlMinPctRows.left = new FormAttachment(0, 0);
        fdlMinPctRows.right = new FormAttachment(this.middle, -this.margin);
        wlMinPctRows.setLayoutData((Object)fdlMinPctRows);
        this.wMinPctRows = new TextVar(this.variables, this.composite, 18436);
        this.props.setLook((Control)this.wMinPctRows);
        this.wMinPctRows.addModifyListener(this.lsMod);
        FormData fdMinPctRows = new FormData();
        fdMinPctRows.top = new FormAttachment((Control)this.wMaxPct, this.margin);
        fdMinPctRows.left = new FormAttachment(this.middle, 0);
        fdMinPctRows.right = new FormAttachment(95, 0);
        this.wMinPctRows.setLayoutData(fdMinPctRows);
        FormData fdComposite = new FormData();
        fdComposite.left = new FormAttachment(0, 0);
        fdComposite.top = new FormAttachment(0, 0);
        fdComposite.right = new FormAttachment(100, 0);
        fdComposite.bottom = new FormAttachment((Control)this.wOk, -this.margin);
        this.composite.setLayoutData((Object)fdComposite);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.ok;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wSourceTransform.setText(this.transformErrorMeta.getSourceTransform() != null ? this.transformErrorMeta.getSourceTransform().getName() : "");
        this.wTargetTransform.setText(this.transformErrorMeta.getTargetTransform() != null ? this.transformErrorMeta.getTargetTransform().getName() : "");
        this.wEnabled.setSelection(this.transformErrorMeta.isEnabled());
        this.wNrErrors.setText(Const.NVL((String)this.transformErrorMeta.getNrErrorsValuename(), (String)""));
        this.wErrDesc.setText(Const.NVL((String)this.transformErrorMeta.getErrorDescriptionsValuename(), (String)""));
        this.wErrFields.setText(Const.NVL((String)this.transformErrorMeta.getErrorFieldsValuename(), (String)""));
        this.wErrCodes.setText(Const.NVL((String)this.transformErrorMeta.getErrorCodesValuename(), (String)""));
        this.wMaxErrors.setText(this.transformErrorMeta.getMaxErrors() != null ? this.transformErrorMeta.getMaxErrors() : "");
        this.wMaxPct.setText(this.transformErrorMeta.getMaxPercentErrors() != null ? this.transformErrorMeta.getMaxPercentErrors() : "");
        this.wMinPctRows.setText(this.transformErrorMeta.getMinPercentRows() != null ? this.transformErrorMeta.getMinPercentRows() : "");
        this.wSourceTransform.setFocus();
    }

    private void cancel() {
        this.originalTransformErrorMeta = null;
        this.dispose();
    }

    public void ok() {
        this.getInfo();
        this.originalTransformErrorMeta.setTargetTransform(this.transformErrorMeta.getTargetTransform());
        this.originalTransformErrorMeta.setEnabled(this.transformErrorMeta.isEnabled());
        this.originalTransformErrorMeta.setNrErrorsValuename(this.transformErrorMeta.getNrErrorsValuename());
        this.originalTransformErrorMeta.setErrorDescriptionsValuename(this.transformErrorMeta.getErrorDescriptionsValuename());
        this.originalTransformErrorMeta.setErrorFieldsValuename(this.transformErrorMeta.getErrorFieldsValuename());
        this.originalTransformErrorMeta.setErrorCodesValuename(this.transformErrorMeta.getErrorCodesValuename());
        this.originalTransformErrorMeta.setMaxErrors(this.transformErrorMeta.getMaxErrors());
        this.originalTransformErrorMeta.setMaxPercentErrors(this.transformErrorMeta.getMaxPercentErrors());
        this.originalTransformErrorMeta.setMinPercentRows(this.transformErrorMeta.getMinPercentRows());
        this.originalTransformErrorMeta.setChanged();
        this.ok = true;
        this.dispose();
    }

    private void getInfo() {
        this.transformErrorMeta.setTargetTransform(TransformMeta.findTransform(this.targetTransforms, (String)this.wTargetTransform.getText()));
        this.transformErrorMeta.setEnabled(this.wEnabled.getSelection());
        this.transformErrorMeta.setNrErrorsValuename(this.wNrErrors.getText());
        this.transformErrorMeta.setErrorDescriptionsValuename(this.wErrDesc.getText());
        this.transformErrorMeta.setErrorFieldsValuename(this.wErrFields.getText());
        this.transformErrorMeta.setErrorCodesValuename(this.wErrCodes.getText());
        this.transformErrorMeta.setMaxErrors(this.wMaxErrors.getText());
        this.transformErrorMeta.setMaxPercentErrors(Const.replace((String)this.wMaxPct.getText(), (String)"%", (String)""));
        this.transformErrorMeta.setMinPercentRows(this.wMinPctRows.getText());
    }
}

