/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.pipeline.dialog;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.parameters.DuplicateParamException;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.IPipelineDialogPlugin;
import org.apache.hop.ui.pipeline.dialog.PipelineDialogPluginType;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PipelineDialog
extends Dialog {
    private static final Class<?> PKG = PipelineDialog.class;
    private CTabFolder wTabFolder;
    private CTabItem wPipelineTab;
    private CTabItem wParamTab;
    private CTabItem wMonitorTab;
    private Text wPipelineName;
    private Button wNameFilenameSync;
    private Text wPipelineFilename;
    private Text wPipelineDescription;
    private Text wExtendedDescription;
    private CCombo wPipelineStatus;
    private Text wPipelineVersion;
    private Text wCreateUser;
    private Text wCreateDate;
    private Text wModUser;
    private Text wModDate;
    private TableView wParamFields;
    private final IVariables variables;
    private PipelineMeta pipelineMeta;
    private Shell shell;
    private ModifyListener lsMod;
    private final PropsUi props = PropsUi.getInstance();
    private int middle;
    private int margin;
    private Button wEnableTransformPerfMonitor;
    private Text wTransformPerfInterval;
    private Tabs currentTab = null;
    protected boolean changed;
    private SelectionAdapter lsModSel;
    private TextVar wTransformPerfMaxSize;
    private ArrayList<IPipelineDialogPlugin> extraTabs;

    public PipelineDialog(Shell parent, int style, IVariables variables, PipelineMeta pipelineMeta, Tabs currentTab) {
        this(parent, style, variables, pipelineMeta);
        this.currentTab = currentTab;
    }

    public PipelineDialog(Shell parent, int style, IVariables variables, PipelineMeta pipelineMeta) {
        super(parent, style);
        this.variables = variables;
        this.pipelineMeta = pipelineMeta;
        this.changed = false;
    }

    public PipelineMeta open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImagePipeline());
        this.lsMod = e -> {
            this.changed = true;
        };
        this.lsModSel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PipelineDialog.this.changed = true;
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.Shell.Title", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = this.props.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{wOk, wCancel}, this.props.getMargin(), null);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.addPipelineTab();
        this.addParamTab();
        this.addMonitoringTab();
        this.extraTabs = new ArrayList();
        List pipelineDialogPlugins = PluginRegistry.getInstance().getPlugins(PipelineDialogPluginType.class);
        for (IPlugin pipelineDialogPlugin : pipelineDialogPlugins) {
            try {
                IPipelineDialogPlugin extraTab = (IPipelineDialogPlugin)PluginRegistry.getInstance().loadClass(pipelineDialogPlugin);
                extraTab.addTab(this.pipelineMeta, parent, this.wTabFolder);
                this.extraTabs.add(extraTab);
            }
            catch (Exception e2) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PipelineDialog.LoadDialogPlugin.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PipelineDialog.LoadDialogPlugin.Error.Message", (String[])new String[]{pipelineDialogPlugin.getIds()[0]}), e2);
            }
        }
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -2 * this.margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        if (this.currentTab != null) {
            this.setCurrentTab(this.currentTab);
        } else {
            this.wTabFolder.setSelection(0);
        }
        this.getData();
        this.changed = false;
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.pipelineMeta;
    }

    private void addPipelineTab() {
        this.wPipelineTab = new CTabItem(this.wTabFolder, 0);
        this.wPipelineTab.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.PipelineTab.Label", (String[])new String[0]));
        Composite wPipelineComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wPipelineComp);
        FormLayout workflowLayout = new FormLayout();
        workflowLayout.marginWidth = 5;
        workflowLayout.marginHeight = 5;
        wPipelineComp.setLayout((Layout)workflowLayout);
        Label wlPipelineName = new Label(wPipelineComp, 131072);
        wlPipelineName.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.PipelineName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPipelineName);
        FormData fdlPipelineName = new FormData();
        fdlPipelineName.left = new FormAttachment(0, 0);
        fdlPipelineName.right = new FormAttachment(this.middle, -this.margin);
        fdlPipelineName.top = new FormAttachment(0, this.margin);
        wlPipelineName.setLayoutData((Object)fdlPipelineName);
        this.wPipelineName = new Text(wPipelineComp, 18436);
        this.props.setLook((Control)this.wPipelineName);
        this.wPipelineName.addModifyListener(this.lsMod);
        FormData fdPipelineName = new FormData();
        fdPipelineName.left = new FormAttachment(this.middle, 0);
        fdPipelineName.top = new FormAttachment(0, this.margin);
        fdPipelineName.right = new FormAttachment(100, 0);
        this.wPipelineName.setLayoutData((Object)fdPipelineName);
        Text lastControl = this.wPipelineName;
        Label wlNameFilenameSync = new Label(wPipelineComp, 131072);
        wlNameFilenameSync.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.NameFilenameSync.Label", (String[])new String[0]));
        this.props.setLook((Control)wlNameFilenameSync);
        FormData fdlNameFilenameSync = new FormData();
        fdlNameFilenameSync.left = new FormAttachment(0, 0);
        fdlNameFilenameSync.right = new FormAttachment(this.middle, -this.margin);
        fdlNameFilenameSync.top = new FormAttachment((Control)lastControl, this.margin);
        wlNameFilenameSync.setLayoutData((Object)fdlNameFilenameSync);
        this.wNameFilenameSync = new Button(wPipelineComp, 32);
        this.props.setLook((Control)this.wNameFilenameSync);
        FormData fdNameFilenameSync = new FormData();
        fdNameFilenameSync.left = new FormAttachment(this.middle, 0);
        fdNameFilenameSync.top = new FormAttachment((Control)wlNameFilenameSync, 0, 0x1000000);
        fdNameFilenameSync.right = new FormAttachment(100, 0);
        this.wNameFilenameSync.setLayoutData((Object)fdNameFilenameSync);
        this.wNameFilenameSync.addListener(13, this::updateNameFilenameSync);
        lastControl = this.wNameFilenameSync;
        Label wlPipelineFilename = new Label(wPipelineComp, 131072);
        wlPipelineFilename.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.PipelineFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPipelineFilename);
        FormData fdlPipelineFilename = new FormData();
        fdlPipelineFilename.left = new FormAttachment(0, 0);
        fdlPipelineFilename.right = new FormAttachment(this.middle, -this.margin);
        fdlPipelineFilename.top = new FormAttachment((Control)lastControl, this.margin);
        wlPipelineFilename.setLayoutData((Object)fdlPipelineFilename);
        this.wPipelineFilename = new Text(wPipelineComp, 18436);
        this.props.setLook((Control)this.wPipelineFilename);
        this.wPipelineFilename.addModifyListener(this.lsMod);
        FormData fdPipelineFilename = new FormData();
        fdPipelineFilename.left = new FormAttachment(this.middle, 0);
        fdPipelineFilename.top = new FormAttachment((Control)wlPipelineFilename, 0, 0x1000000);
        fdPipelineFilename.right = new FormAttachment(100, 0);
        this.wPipelineFilename.setLayoutData((Object)fdPipelineFilename);
        this.wPipelineFilename.setEditable(false);
        this.wPipelineFilename.setBackground(GuiResource.getInstance().getColorLightGray());
        lastControl = this.wPipelineFilename;
        Label wlPipelineDescription = new Label(wPipelineComp, 131072);
        wlPipelineDescription.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.PipelineDescription.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPipelineDescription);
        FormData fdlPipelineDescription = new FormData();
        fdlPipelineDescription.left = new FormAttachment(0, 0);
        fdlPipelineDescription.right = new FormAttachment(this.middle, -this.margin);
        fdlPipelineDescription.top = new FormAttachment((Control)lastControl, this.margin);
        wlPipelineDescription.setLayoutData((Object)fdlPipelineDescription);
        this.wPipelineDescription = new Text(wPipelineComp, 18436);
        this.props.setLook((Control)this.wPipelineDescription);
        this.wPipelineDescription.addModifyListener(this.lsMod);
        FormData fdPipelineDescription = new FormData();
        fdPipelineDescription.left = new FormAttachment(this.middle, 0);
        fdPipelineDescription.top = new FormAttachment((Control)wlPipelineDescription, 0, 0x1000000);
        fdPipelineDescription.right = new FormAttachment(100, 0);
        this.wPipelineDescription.setLayoutData((Object)fdPipelineDescription);
        Label wlExtendedDescription = new Label(wPipelineComp, 131072);
        wlExtendedDescription.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.Extendeddescription.Label", (String[])new String[0]));
        this.props.setLook((Control)wlExtendedDescription);
        FormData fdlExtendedDescription = new FormData();
        fdlExtendedDescription.left = new FormAttachment(0, 0);
        fdlExtendedDescription.top = new FormAttachment((Control)this.wPipelineDescription, this.margin);
        fdlExtendedDescription.right = new FormAttachment(this.middle, -this.margin);
        wlExtendedDescription.setLayoutData((Object)fdlExtendedDescription);
        this.wExtendedDescription = new Text(wPipelineComp, 19202);
        this.props.setLook((Control)this.wExtendedDescription, 1);
        this.wExtendedDescription.addModifyListener(this.lsMod);
        FormData fdExtendedDescription = new FormData();
        fdExtendedDescription.left = new FormAttachment(this.middle, 0);
        fdExtendedDescription.top = new FormAttachment((Control)this.wPipelineDescription, this.margin);
        fdExtendedDescription.right = new FormAttachment(100, 0);
        fdExtendedDescription.bottom = new FormAttachment(50, -this.margin);
        this.wExtendedDescription.setLayoutData((Object)fdExtendedDescription);
        Label wlPipelineStatus = new Label(wPipelineComp, 131072);
        wlPipelineStatus.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.PipelineStatus.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPipelineStatus);
        FormData fdlPipelineStatus = new FormData();
        fdlPipelineStatus.left = new FormAttachment(0, 0);
        fdlPipelineStatus.right = new FormAttachment(this.middle, 0);
        fdlPipelineStatus.top = new FormAttachment((Control)this.wExtendedDescription, this.margin * 2);
        wlPipelineStatus.setLayoutData((Object)fdlPipelineStatus);
        this.wPipelineStatus = new CCombo(wPipelineComp, 2060);
        this.wPipelineStatus.add(BaseMessages.getString(PKG, (String)"PipelineDialog.Draft_PipelineStatus.Label", (String[])new String[0]));
        this.wPipelineStatus.add(BaseMessages.getString(PKG, (String)"PipelineDialog.Production_PipelineStatus.Label", (String[])new String[0]));
        this.wPipelineStatus.add("");
        this.wPipelineStatus.select(-1);
        this.wPipelineStatus.addSelectionListener((SelectionListener)this.lsModSel);
        this.props.setLook((Control)this.wPipelineStatus);
        FormData fdPipelineStatus = new FormData();
        fdPipelineStatus.left = new FormAttachment(this.middle, 0);
        fdPipelineStatus.top = new FormAttachment((Control)this.wExtendedDescription, this.margin * 2);
        fdPipelineStatus.right = new FormAttachment(100, 0);
        this.wPipelineStatus.setLayoutData((Object)fdPipelineStatus);
        Label wlPipelineVersion = new Label(wPipelineComp, 131072);
        wlPipelineVersion.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.PipelineVersion.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPipelineVersion);
        FormData fdlPipelineVersion = new FormData();
        fdlPipelineVersion.left = new FormAttachment(0, 0);
        fdlPipelineVersion.right = new FormAttachment(this.middle, -this.margin);
        fdlPipelineVersion.top = new FormAttachment((Control)this.wPipelineStatus, this.margin);
        wlPipelineVersion.setLayoutData((Object)fdlPipelineVersion);
        this.wPipelineVersion = new Text(wPipelineComp, 18436);
        this.props.setLook((Control)this.wPipelineVersion);
        this.wPipelineVersion.addModifyListener(this.lsMod);
        FormData fdPipelineVersion = new FormData();
        fdPipelineVersion.left = new FormAttachment(this.middle, 0);
        fdPipelineVersion.top = new FormAttachment((Control)this.wPipelineStatus, this.margin);
        fdPipelineVersion.right = new FormAttachment(100, 0);
        this.wPipelineVersion.setLayoutData((Object)fdPipelineVersion);
        Label wlCreateUser = new Label(wPipelineComp, 131072);
        wlCreateUser.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.CreateUser.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCreateUser);
        FormData fdlCreateUser = new FormData();
        fdlCreateUser.left = new FormAttachment(0, 0);
        fdlCreateUser.right = new FormAttachment(this.middle, -this.margin);
        fdlCreateUser.top = new FormAttachment((Control)this.wPipelineVersion, this.margin);
        wlCreateUser.setLayoutData((Object)fdlCreateUser);
        this.wCreateUser = new Text(wPipelineComp, 18436);
        this.props.setLook((Control)this.wCreateUser);
        this.wCreateUser.setEditable(false);
        this.wCreateUser.addModifyListener(this.lsMod);
        FormData fdCreateUser = new FormData();
        fdCreateUser.left = new FormAttachment(this.middle, 0);
        fdCreateUser.top = new FormAttachment((Control)this.wPipelineVersion, this.margin);
        fdCreateUser.right = new FormAttachment(100, 0);
        this.wCreateUser.setLayoutData((Object)fdCreateUser);
        Label wlCreateDate = new Label(wPipelineComp, 131072);
        wlCreateDate.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.CreateDate.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCreateDate);
        FormData fdlCreateDate = new FormData();
        fdlCreateDate.left = new FormAttachment(0, 0);
        fdlCreateDate.right = new FormAttachment(this.middle, -this.margin);
        fdlCreateDate.top = new FormAttachment((Control)this.wCreateUser, this.margin);
        wlCreateDate.setLayoutData((Object)fdlCreateDate);
        this.wCreateDate = new Text(wPipelineComp, 18436);
        this.props.setLook((Control)this.wCreateDate);
        this.wCreateDate.setEditable(false);
        this.wCreateDate.addModifyListener(this.lsMod);
        FormData fdCreateDate = new FormData();
        fdCreateDate.left = new FormAttachment(this.middle, 0);
        fdCreateDate.top = new FormAttachment((Control)this.wCreateUser, this.margin);
        fdCreateDate.right = new FormAttachment(100, 0);
        this.wCreateDate.setLayoutData((Object)fdCreateDate);
        Label wlModUser = new Label(wPipelineComp, 131072);
        wlModUser.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.LastModifiedUser.Label", (String[])new String[0]));
        this.props.setLook((Control)wlModUser);
        FormData fdlModUser = new FormData();
        fdlModUser.left = new FormAttachment(0, 0);
        fdlModUser.right = new FormAttachment(this.middle, -this.margin);
        fdlModUser.top = new FormAttachment((Control)this.wCreateDate, this.margin);
        wlModUser.setLayoutData((Object)fdlModUser);
        this.wModUser = new Text(wPipelineComp, 18436);
        this.props.setLook((Control)this.wModUser);
        this.wModUser.setEditable(false);
        this.wModUser.addModifyListener(this.lsMod);
        FormData fdModUser = new FormData();
        fdModUser.left = new FormAttachment(this.middle, 0);
        fdModUser.top = new FormAttachment((Control)this.wCreateDate, this.margin);
        fdModUser.right = new FormAttachment(100, 0);
        this.wModUser.setLayoutData((Object)fdModUser);
        Label wlModDate = new Label(wPipelineComp, 131072);
        wlModDate.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.LastModifiedDate.Label", (String[])new String[0]));
        this.props.setLook((Control)wlModDate);
        FormData fdlModDate = new FormData();
        fdlModDate.left = new FormAttachment(0, 0);
        fdlModDate.right = new FormAttachment(this.middle, -this.margin);
        fdlModDate.top = new FormAttachment((Control)this.wModUser, this.margin);
        wlModDate.setLayoutData((Object)fdlModDate);
        this.wModDate = new Text(wPipelineComp, 18436);
        this.props.setLook((Control)this.wModDate);
        this.wModDate.setEditable(false);
        this.wModDate.addModifyListener(this.lsMod);
        FormData fdModDate = new FormData();
        fdModDate.left = new FormAttachment(this.middle, 0);
        fdModDate.top = new FormAttachment((Control)this.wModUser, this.margin);
        fdModDate.right = new FormAttachment(100, 0);
        this.wModDate.setLayoutData((Object)fdModDate);
        FormData fdPipelineComp = new FormData();
        fdPipelineComp.left = new FormAttachment(0, 0);
        fdPipelineComp.top = new FormAttachment(0, 0);
        fdPipelineComp.right = new FormAttachment(100, 0);
        fdPipelineComp.bottom = new FormAttachment(100, 0);
        wPipelineComp.setLayoutData((Object)fdPipelineComp);
        wPipelineComp.layout();
        this.wPipelineTab.setControl((Control)wPipelineComp);
    }

    private void updateNameFilenameSync(Event event) {
        String name = this.wPipelineName.getText();
        String filename = this.wPipelineFilename.getText();
        boolean sync = this.wNameFilenameSync.getSelection();
        String actualName = PipelineMeta.extractNameFromFilename((boolean)sync, (String)name, (String)filename, (String)".hpl");
        this.wPipelineName.setEnabled(!sync);
        this.wPipelineName.setEditable(!sync);
        this.wPipelineName.setText(Const.NVL((String)actualName, (String)""));
    }

    private void addParamTab() {
        this.wParamTab = new CTabItem(this.wTabFolder, 0);
        this.wParamTab.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.ParamTab.Label", (String[])new String[0]));
        FormLayout paramLayout = new FormLayout();
        paramLayout.marginWidth = this.props.getMargin();
        paramLayout.marginHeight = this.props.getMargin();
        Composite wParamComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wParamComp);
        wParamComp.setLayout((Layout)paramLayout);
        Label wlFields = new Label(wParamComp, 131072);
        wlFields.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.Parameters.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(0, 0);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsCols = 3;
        int FieldsRows = this.pipelineMeta.listParameters().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineDialog.ColumnInfo.Parameter.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineDialog.ColumnInfo.Default.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineDialog.ColumnInfo.Description.Label", (String[])new String[0]), 1, false)};
        this.wParamFields = new TableView(this.variables, wParamComp, 67586, colinf, FieldsRows, this.lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, 0);
        this.wParamFields.setLayoutData(fdFields);
        FormData fdDepComp = new FormData();
        fdDepComp.left = new FormAttachment(0, 0);
        fdDepComp.top = new FormAttachment(0, 0);
        fdDepComp.right = new FormAttachment(100, 0);
        fdDepComp.bottom = new FormAttachment(100, 0);
        wParamComp.setLayoutData((Object)fdDepComp);
        wParamComp.layout();
        this.wParamTab.setControl((Control)wParamComp);
    }

    private void addMonitoringTab() {
        this.wMonitorTab = new CTabItem(this.wTabFolder, 0);
        this.wMonitorTab.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.MonitorTab.Label", (String[])new String[0]));
        Composite wMonitorComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wMonitorComp);
        FormLayout monitorLayout = new FormLayout();
        monitorLayout.marginWidth = 5;
        monitorLayout.marginHeight = 5;
        wMonitorComp.setLayout((Layout)monitorLayout);
        Label wlEnableTransformPerfMonitor = new Label(wMonitorComp, 16384);
        wlEnableTransformPerfMonitor.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.TransformPerformanceMonitoring.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEnableTransformPerfMonitor);
        FormData fdlSchemaName = new FormData();
        fdlSchemaName.left = new FormAttachment(0, 0);
        fdlSchemaName.right = new FormAttachment(this.middle, -this.margin);
        fdlSchemaName.top = new FormAttachment(0, 0);
        wlEnableTransformPerfMonitor.setLayoutData((Object)fdlSchemaName);
        this.wEnableTransformPerfMonitor = new Button(wMonitorComp, 32);
        this.props.setLook((Control)this.wEnableTransformPerfMonitor);
        FormData fdEnableTransformPerfMonitor = new FormData();
        fdEnableTransformPerfMonitor.left = new FormAttachment(this.middle, 0);
        fdEnableTransformPerfMonitor.right = new FormAttachment(100, 0);
        fdEnableTransformPerfMonitor.top = new FormAttachment(0, 0);
        this.wEnableTransformPerfMonitor.setLayoutData((Object)fdEnableTransformPerfMonitor);
        this.wEnableTransformPerfMonitor.addSelectionListener((SelectionListener)this.lsModSel);
        Label wlTransformPerfInterval = new Label(wMonitorComp, 16384);
        wlTransformPerfInterval.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.TransformPerformanceInterval.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTransformPerfInterval);
        FormData fdlTransformPerfInterval = new FormData();
        fdlTransformPerfInterval.left = new FormAttachment(0, 0);
        fdlTransformPerfInterval.right = new FormAttachment(this.middle, -this.margin);
        fdlTransformPerfInterval.top = new FormAttachment((Control)this.wEnableTransformPerfMonitor, this.margin);
        wlTransformPerfInterval.setLayoutData((Object)fdlTransformPerfInterval);
        this.wTransformPerfInterval = new Text(wMonitorComp, 18436);
        this.props.setLook((Control)this.wTransformPerfInterval);
        FormData fdTransformPerfInterval = new FormData();
        fdTransformPerfInterval.left = new FormAttachment(this.middle, 0);
        fdTransformPerfInterval.right = new FormAttachment(100, 0);
        fdTransformPerfInterval.top = new FormAttachment((Control)this.wEnableTransformPerfMonitor, this.margin);
        this.wTransformPerfInterval.setLayoutData((Object)fdTransformPerfInterval);
        this.wTransformPerfInterval.addModifyListener(this.lsMod);
        Label wlTransformPerfMaxSize = new Label(wMonitorComp, 16384);
        wlTransformPerfMaxSize.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.TransformPerformanceMaxSize.Label", (String[])new String[0]));
        wlTransformPerfMaxSize.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineDialog.TransformPerformanceMaxSize.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlTransformPerfMaxSize);
        FormData fdlTransformPerfMaxSize = new FormData();
        fdlTransformPerfMaxSize.left = new FormAttachment(0, 0);
        fdlTransformPerfMaxSize.right = new FormAttachment(this.middle, -this.margin);
        fdlTransformPerfMaxSize.top = new FormAttachment((Control)this.wTransformPerfInterval, this.margin);
        wlTransformPerfMaxSize.setLayoutData((Object)fdlTransformPerfMaxSize);
        this.wTransformPerfMaxSize = new TextVar(this.variables, wMonitorComp, 18436);
        this.wTransformPerfMaxSize.setToolTipText(BaseMessages.getString(PKG, (String)"PipelineDialog.TransformPerformanceMaxSize.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTransformPerfMaxSize);
        FormData fdTransformPerfMaxSize = new FormData();
        fdTransformPerfMaxSize.left = new FormAttachment(this.middle, 0);
        fdTransformPerfMaxSize.right = new FormAttachment(100, 0);
        fdTransformPerfMaxSize.top = new FormAttachment((Control)this.wTransformPerfInterval, this.margin);
        this.wTransformPerfMaxSize.setLayoutData(fdTransformPerfMaxSize);
        this.wTransformPerfMaxSize.addModifyListener(this.lsMod);
        FormData fdMonitorComp = new FormData();
        fdMonitorComp.left = new FormAttachment(0, 0);
        fdMonitorComp.top = new FormAttachment(0, 0);
        fdMonitorComp.right = new FormAttachment(100, 0);
        fdMonitorComp.bottom = new FormAttachment(100, 0);
        wMonitorComp.setLayoutData((Object)fdMonitorComp);
        wMonitorComp.layout();
        this.wMonitorTab.setControl((Control)wMonitorComp);
    }

    public void dispose() {
        this.shell.dispose();
    }

    public void getData() {
        this.wPipelineName.setText(Const.NVL((String)this.pipelineMeta.getName(), (String)""));
        this.wNameFilenameSync.setSelection(this.pipelineMeta.isNameSynchronizedWithFilename());
        this.wPipelineFilename.setText(Const.NVL((String)this.pipelineMeta.getFilename(), (String)""));
        this.updateNameFilenameSync(null);
        this.wPipelineDescription.setText(Const.NVL((String)this.pipelineMeta.getDescription(), (String)""));
        this.wExtendedDescription.setText(Const.NVL((String)this.pipelineMeta.getExtendedDescription(), (String)""));
        this.wPipelineVersion.setText(Const.NVL((String)this.pipelineMeta.getPipelineVersion(), (String)""));
        this.wPipelineStatus.select(this.pipelineMeta.getPipelineStatus() - 1);
        if (this.pipelineMeta.getCreatedUser() != null) {
            this.wCreateUser.setText(this.pipelineMeta.getCreatedUser());
        }
        if (this.pipelineMeta.getCreatedDate() != null) {
            this.wCreateDate.setText(this.pipelineMeta.getCreatedDate().toString());
        }
        if (this.pipelineMeta.getModifiedUser() != null) {
            this.wModUser.setText(this.pipelineMeta.getModifiedUser());
        }
        if (this.pipelineMeta.getModifiedDate() != null) {
            this.wModDate.setText(this.pipelineMeta.getModifiedDate().toString());
        }
        String[] parameters = this.pipelineMeta.listParameters();
        for (int idx = 0; idx < parameters.length; ++idx) {
            String description;
            String defValue;
            TableItem item = this.wParamFields.table.getItem(idx);
            try {
                defValue = this.pipelineMeta.getParameterDefault(parameters[idx]);
            }
            catch (UnknownParamException e) {
                defValue = "";
            }
            try {
                description = this.pipelineMeta.getParameterDescription(parameters[idx]);
            }
            catch (UnknownParamException e) {
                description = "";
            }
            item.setText(1, parameters[idx]);
            item.setText(2, Const.NVL((String)defValue, (String)""));
            item.setText(3, Const.NVL((String)description, (String)""));
        }
        this.wParamFields.setRowNums();
        this.wParamFields.optWidth(true);
        this.wEnableTransformPerfMonitor.setSelection(this.pipelineMeta.isCapturingTransformPerformanceSnapShots());
        this.wTransformPerfInterval.setText(Long.toString(this.pipelineMeta.getTransformPerformanceCapturingDelay()));
        this.wTransformPerfMaxSize.setText(Const.NVL((String)this.pipelineMeta.getTransformPerformanceCapturingSizeLimit(), (String)""));
        this.wPipelineName.selectAll();
        this.wPipelineName.setFocus();
        for (IPipelineDialogPlugin extraTab : this.extraTabs) {
            try {
                extraTab.getData(this.pipelineMeta);
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error adding extra plugin tab", e);
            }
        }
    }

    private void cancel() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.pipelineMeta = null;
        this.dispose();
    }

    private void ok() {
        boolean OK = true;
        this.pipelineMeta.setName(this.wPipelineName.getText());
        this.pipelineMeta.setNameSynchronizedWithFilename(this.wNameFilenameSync.getSelection());
        this.pipelineMeta.setDescription(this.wPipelineDescription.getText());
        this.pipelineMeta.setExtendedDescription(this.wExtendedDescription.getText());
        this.pipelineMeta.setPipelineVersion(this.wPipelineVersion.getText());
        if (this.wPipelineStatus.getSelectionIndex() != 2) {
            this.pipelineMeta.setPipelineStatus(this.wPipelineStatus.getSelectionIndex() + 1);
        } else {
            this.pipelineMeta.setPipelineStatus(-1);
        }
        this.pipelineMeta.removeAllParameters();
        int nrNonEmptyFields = this.wParamFields.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wParamFields.getNonEmpty(i);
            try {
                this.pipelineMeta.addParameterDefinition(item.getText(1), item.getText(2), item.getText(3));
                continue;
            }
            catch (DuplicateParamException duplicateParamException) {
                // empty catch block
            }
        }
        this.pipelineMeta.setCapturingTransformPerformanceSnapShots(this.wEnableTransformPerfMonitor.getSelection());
        this.pipelineMeta.setTransformPerformanceCapturingSizeLimit(this.wTransformPerfMaxSize.getText());
        try {
            long transformPerformanceCapturingDelay = Long.parseLong(this.wTransformPerfInterval.getText());
            if (transformPerformanceCapturingDelay <= 0L && this.pipelineMeta.isCapturingTransformPerformanceSnapShots()) {
                throw new HopException();
            }
            if (transformPerformanceCapturingDelay <= 0L) {
                transformPerformanceCapturingDelay = 1000L;
            }
            this.pipelineMeta.setTransformPerformanceCapturingDelay(transformPerformanceCapturingDelay);
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"PipelineDialog.InvalidTransformPerfIntervalNumber.DialogTitle", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"PipelineDialog.InvalidTransformPerfIntervalNumber.DialogMessage", (String[])new String[0]));
            mb.open();
            this.wTransformPerfInterval.setFocus();
            this.wTransformPerfInterval.selectAll();
            OK = false;
        }
        for (IPipelineDialogPlugin extraTab : this.extraTabs) {
            try {
                extraTab.ok(this.pipelineMeta);
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error getting information from extra plugin tab", e);
            }
        }
        if (OK) {
            this.pipelineMeta.setChanged(this.changed || this.pipelineMeta.hasChanged());
            this.dispose();
        }
    }

    private void setCurrentTab(Tabs currentTab) {
        switch (currentTab) {
            case PARAM_TAB: {
                this.wTabFolder.setSelection(this.wParamTab);
                break;
            }
            case MONITOR_TAB: {
                this.wTabFolder.setSelection(this.wMonitorTab);
                break;
            }
            case EXTRA_TAB: {
                if (this.extraTabs.size() <= 0) break;
                this.wTabFolder.setSelection(this.extraTabs.get(0).getTab());
                break;
            }
            default: {
                this.wTabFolder.setSelection(this.wPipelineTab);
            }
        }
    }

    public static enum Tabs {
        PIPELINE_TAB,
        PARAM_TAB,
        MONITOR_TAB,
        EXTRA_TAB;

    }
}

