/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.pipeline.dialog;

import java.util.Arrays;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PartitionerPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.ModPartitioner;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformPartitioningMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.pipeline.dialog.PipelineDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.HelpUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ModPartitionerDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = PipelineDialog.class;
    private TransformPartitioningMeta partitioningMeta;
    private ModPartitioner partitioner;
    private String fieldName;
    private Label wlFieldname;
    private CCombo wFieldname;
    private FormData fdlFieldname;
    private FormData fdFieldname;

    public ModPartitionerDialog(Shell parent, IVariables variables, TransformMeta transformMeta, TransformPartitioningMeta partitioningMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (BaseTransformMeta)transformMeta.getTransform(), pipelineMeta, partitioningMeta.getPartitioner().getDescription());
        this.transformMeta = transformMeta;
        this.partitioningMeta = partitioningMeta;
        this.partitioner = (ModPartitioner)partitioningMeta.getPartitioner();
        this.fieldName = this.partitioner.getFieldName();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell);
        ModifyListener lsMod = e -> this.partitioningMeta.hasChanged(true);
        this.changed = this.partitioningMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.partitioner.getDescription());
        int margin = this.props.getMargin();
        int middle = this.props.getMiddlePct();
        this.wlFieldname = new Label((Composite)this.shell, 131072);
        this.wlFieldname.setText("Fieldname");
        this.props.setLook((Control)this.wlFieldname);
        this.fdlFieldname = new FormData();
        this.fdlFieldname.left = new FormAttachment(0, 0);
        this.fdlFieldname.right = new FormAttachment(middle, -margin);
        this.fdlFieldname.top = new FormAttachment(0, margin);
        this.wlFieldname.setLayoutData((Object)this.fdlFieldname);
        this.wFieldname = new CCombo((Composite)this.shell, 18436);
        this.wFieldname.setText(this.fieldName == null ? "" : this.fieldName);
        this.props.setLook((Control)this.wFieldname);
        this.wFieldname.addModifyListener(lsMod);
        this.fdFieldname = new FormData();
        this.fdFieldname.left = new FormAttachment(middle, 0);
        this.fdFieldname.top = new FormAttachment(0, margin);
        this.fdFieldname.right = new FormAttachment(100, 0);
        this.wFieldname.setLayoutData((Object)this.fdFieldname);
        try {
            IRowMeta inputFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
            if (inputFields != null) {
                Object[] fieldNames = inputFields.getFieldNames();
                Arrays.sort(fieldNames);
                this.wFieldname.setItems((String[])fieldNames);
            }
        }
        catch (Exception e2) {
            new ErrorDialog(this.shell, "Error", "Error obtaining list of input fields:", e2);
        }
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.fdOk = new FormData();
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        this.partitioningMeta.hasChanged(this.changed);
        this.wOk.setEnabled(!StringUtil.isEmpty((String)this.wFieldname.getText()));
        ModifyListener modifyListener = modifyEvent -> this.wOk.setEnabled(!StringUtil.isEmpty((String)this.wFieldname.getText()));
        this.wFieldname.addModifyListener(modifyListener);
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        this.wFieldname.setText(this.fieldName == null ? "" : this.fieldName);
    }

    private void cancel() {
        this.transformName = null;
        this.partitioningMeta.hasChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        this.fieldName = this.wFieldname.getText();
        this.partitioner.setFieldName(this.fieldName);
        this.dispose();
    }

    private void setShellImage(Shell shell) {
        IPlugin plugin = PluginRegistry.getInstance().getPlugin(PartitionerPluginType.class, this.partitioner.getId());
        if (!Utils.isEmpty((CharSequence)plugin.getDocumentationUrl())) {
            HelpUtils.createHelpButton((Composite)shell, plugin);
        }
        shell.setImage(GuiResource.getInstance().getImageHopUi());
    }
}

