/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.collections4.properties.SortedProperties;
import org.apache.hop.core.Const;
import org.apache.hop.core.changed.ChangedFlag;
import org.apache.hop.core.exception.HopException;

public class BundleFile
extends ChangedFlag {
    private String filename;
    private String packageName;
    private String locale;
    private Map<String, String> contents;

    public BundleFile(String filename, String packageName, String locale, Map<String, String> contents) {
        this.filename = filename;
        this.packageName = packageName;
        this.locale = locale;
        this.contents = contents;
    }

    public BundleFile(String filename, String packageName, String locale) throws IOException {
        this(filename, packageName, locale, new HashMap<String, String>());
        Properties properties = new Properties();
        properties.load(new FileInputStream(filename));
        for (String key : properties.stringPropertyNames()) {
            this.contents.put(key, properties.getProperty(key));
        }
    }

    public String get(String key) {
        return this.contents.get(key);
    }

    public void put(String key, String value) {
        this.contents.put(key, value);
        this.setChanged();
    }

    public void remove(String key) {
        this.contents.remove(key);
        this.setChanged();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BundleFile that = (BundleFile)((Object)o);
        return this.filename.equals(that.filename);
    }

    public int hashCode() {
        return Objects.hash(this.filename);
    }

    public void write() throws HopException {
        try {
            File parent;
            File file = new File(this.filename);
            if (!file.exists() && !(parent = file.getParentFile()).exists()) {
                parent.mkdirs();
            }
            SortedProperties properties = new SortedProperties();
            for (String key : this.contents.keySet()) {
                properties.put(key, this.contents.get(key));
            }
            String licenseText = "\n Licensed to the Apache Software Foundation (ASF) under one or more\n contributor license agreements.  See the NOTICE file distributed with\n this work for additional information regarding copyright ownership.\n The ASF licenses this file to You under the Apache License, Version 2.0\n (the \"License\"); you may not use this file except in compliance with\n the License.  You may obtain a copy of the License at\n\n       http://www.apache.org/licenses/LICENSE-2.0\n\n Unless required by applicable law or agreed to in writing, software\n distributed under the License is distributed on an \"AS IS\" BASIS,\n WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n See the License for the specific language governing permissions and\n limitations under the License.\n\n";
            String comment = "File generated by Hop Translator for package '" + this.packageName + "' in locale '" + this.locale + "'" + Const.CR + Const.CR;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, licenseText + comment);
            fileOutputStream.close();
            this.setChanged(false);
        }
        catch (IOException e) {
            throw new HopException("Unable to save bundle (package: '" + this.packageName + "', locale: '" + this.locale + "' to file '" + this.filename + "'", (Throwable)e);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Map<String, String> getContents() {
        return this.contents;
    }

    public void setContents(Map<String, String> contents) {
        this.contents = contents;
    }
}

