/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hop.core.config.DescribedVariable;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.search.HopGuiDescribedVariableSearchable;
import org.apache.hop.ui.hopgui.search.HopGuiMetadataSearchable;
import org.apache.hop.ui.hopgui.search.HopGuiSearchLocation;

public class HopGuiSearchLocationIterator
implements Iterator<ISearchable> {
    private HopGui hopGui;
    private HopGuiSearchLocation location;
    private List<ISearchable> searchables;
    private Iterator<ISearchable> searchableIterator;

    public HopGuiSearchLocationIterator(HopGui hopGui, HopGuiSearchLocation location) throws HopException {
        this.hopGui = hopGui;
        this.location = location;
        this.searchables = new ArrayList<ISearchable>();
        for (IHopPerspective perspective : hopGui.getPerspectiveManager().getPerspectives()) {
            this.searchables.addAll(perspective.getSearchables());
        }
        for (Class metadataClass : hopGui.getMetadataProvider().getMetadataClasses()) {
            IHopMetadataSerializer serializer = hopGui.getMetadataProvider().getSerializer(metadataClass);
            for (String metadataName : serializer.listObjectNames()) {
                IHopMetadata hopMetadata = serializer.load(metadataName);
                HopGuiMetadataSearchable searchable = new HopGuiMetadataSearchable(hopGui.getMetadataProvider(), (IHopMetadataSerializer<IHopMetadata>)serializer, hopMetadata, serializer.getManagedClass());
                this.searchables.add(searchable);
            }
        }
        List describedVariables = HopConfig.getInstance().getDescribedVariables();
        for (DescribedVariable describedVariable : describedVariables) {
            this.searchables.add(new HopGuiDescribedVariableSearchable(describedVariable, null));
        }
        this.searchableIterator = this.searchables.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.searchableIterator.hasNext();
    }

    @Override
    public ISearchable next() {
        return this.searchableIterator.next();
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public void setHopGui(HopGui hopGui) {
        this.hopGui = hopGui;
    }

    public HopGuiSearchLocation getLocation() {
        return this.location;
    }

    public void setLocation(HopGuiSearchLocation location) {
        this.location = location;
    }
}

